/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JArray;
import JCollections.JSet;
import JWVFile.VFile;
import Jxe.DocumentStream;
import de.netcomputing.anyj.AJCompileAndBuildGUI;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.ITabbedPaneDiag;
import de.netcomputing.anyj.gui.AJClassSetBean;
import de.netcomputing.anyj.gui.AJEnvFileTextField;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.beans.numberpanel.NumberPanel;
import de.netcomputing.propertystore.beans.PathEditorBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;
import plugins.JavacPlugin;

public class AJCompileAndBuild
extends NCPanel
implements ITabbedPaneDiag {
    public static AJCompileAndBuild This;
    NCButton applyBtn;
    NCButton cancelBtn;
    JTabbedPane mainTabbedPane;
    JCheckBox useTmpFile;
    AJEnvFileTextField outputTxt;
    JTabbedPane tabbedPane;
    JLabel memLabel;
    NumberPanel memBox;
    JCheckBox javawChk;
    NCTextField clineJavac;
    NCTextField clineJVC;
    NCCheckBox jvcExtBox;
    NumberPanel warnPanel;
    NCTextField clineJikes;
    NCCheckBox verboseChk;
    NCCheckBox nowarnChk;
    NCCheckBox gChk;
    NCCheckBox optimizeChk;
    NCCheckBox dependChk;
    JToggleButton plugBtn;
    PathEditorBean sourcepathTxt;
    NCTreeBean spList;
    NCTreeBean clpList;
    PathEditorBean classpathTxt;
    NCButton runRMICBtn;
    AJEnvFileTextField rmiOut;
    NCCheckBox rmiNoWarnChk;
    NCCheckBox rmiDebugChk;
    AJClassSetBean fileSet;
    NCTextField excludeCompileTxt;
    String wdir;

    public AJCompileAndBuild() {
        this.initGui();
        This = this;
        try {
            this.getClineJavac().setText("-J-Xms48m -J-Xmx64m");
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void initGui() {
        new AJCompileAndBuildGUI().createGui(this);
        this.init();
        this.applyBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
        this.javawChk.setVisible(false);
        this.memBox.setVisible(false);
        this.memLabel.setVisible(false);
    }

    public void reset() {
        this.rmiOut.setText("($outputdir)");
        this.outputTxt.setText("");
        this.getFileSet().getListPanel().clear();
        this.classpathTxt.setText("");
        this.applyBtn_actionPerformed(null);
    }

    public AJClassSetBean getFileSet() {
        return this.fileSet;
    }

    public NCTextField getClineJavac() {
        return this.clineJavac;
    }

    public NCTextField getClineJikes() {
        return this.clineJikes;
    }

    public boolean getUseTmpFile() {
        return this.useTmpFile.isSelected() && this.tabbedPane.getSelectedIndex() != 1;
    }

    public PathEditorBean getSourcepathFld() {
        return this.sourcepathTxt;
    }

    public Vector getExcludeDirs() {
        return NCStringUtilities.SplitSeparatedString(";", this.excludeCompileTxt.getText());
    }

    public JTabbedPane getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    public AJEnvFileTextField getOutputTxt() {
        return this.outputTxt;
    }

    public PathEditorBean getClasspathTxt() {
        return this.classpathTxt;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    JTextField getCurrentClineText() {
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                return this.clineJavac;
            }
            case 1: {
                return this.clineJVC;
            }
        }
        return this.clineJikes;
    }

    public void init() {
        super.init();
        this.warnPanel.setRange(0, 4, 1);
        this.sourcepathTxt.setMirror(this.spList);
        this.classpathTxt.setMirror(this.clpList);
        this.useTmpFile.setSelected(true);
        this.useTmpFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AJCompileAndBuild.this.actionChk(null, null);
            }
        });
        NCCheckBox[] arr = new NCCheckBox[]{this.gChk, this.nowarnChk, this.dependChk, this.verboseChk, this.optimizeChk, this.rmiDebugChk, this.rmiNoWarnChk};
        int n = 0;
        while (n < arr.length) {
            arr[n].addTarget(this, "actionChk");
            ++n;
        }
        this.verboseChk.setPressed(true);
        this.verboseChk.setEnabled(false);
        EditApp.App.binderApplication().addTarget(this, "actionApplication");
        this.classpathTxt.setText("");
        this.outputTxt.setText("");
        this.rmiOut.setText("($workspaceDir)");
        this.enableApplyButtons(false);
        DocumentListener enableButtons = new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                AJCompileAndBuild.this.enableApplyButtons(true);
            }

            public void insertUpdate(DocumentEvent e) {
                AJCompileAndBuild.this.enableApplyButtons(true);
            }

            public void changedUpdate(DocumentEvent e) {
                AJCompileAndBuild.this.enableApplyButtons(true);
            }
        };
        this.outputTxt.addDocumentListener(enableButtons);
        this.classpathTxt.addDocumentListener(enableButtons);
        this.sourcepathTxt.addDocumentListener(enableButtons);
        this.clineJikes.addDocumentListener(enableButtons);
        this.clineJavac.addDocumentListener(enableButtons);
        this.clineJVC.addDocumentListener(enableButtons);
        this.rmiOut.addDocumentListener(enableButtons);
        this.excludeCompileTxt.addDocumentListener(enableButtons);
        this.warnPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJCompileAndBuild.this.enableApplyButtons(true);
            }
        });
        this.enableApplyButtons(false);
        this.getFileSet().getAddBtn().addTarget(this, "actionChk");
        this.getFileSet().getRemBtn().addTarget(this, "actionChk");
        this.getFileSet().getClearBtn().addTarget(this, "actionChk");
        this.plugBtn_itemStateChanged(null);
    }

    public void setClasspath(String cp) {
        this.classpathTxt.setText(cp);
    }

    public void setWdir(String wd) {
        this.wdir = wd;
    }

    public String getWdir() {
        if (this.wdir == null || !new File(this.wdir).exists()) {
            return File.separator;
        }
        return this.wdir;
    }

    public boolean useJVC() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            String jvc = (String)EditApp.App.getWorkspaceProperty("File.jvc");
            if (!new File(jvc).exists()) {
                File jvcFile = AJDirSelector.SelectDirModal((Window)this.getFrame(), "jvc.exe", "Please select the Directory of jvc.exe", null, null);
                if (jvcFile != null) {
                    EditApp.App.setWorkspaceProperty("File.jvc", jvcFile.getAbsolutePath() + File.separator + "jvc.exe");
                    return true;
                }
                this.tabbedPane.setSelectedIndex(0);
                return false;
            }
            return true;
        }
        return false;
    }

    public Object actionJVCOpt(Object arg, Object sen) {
        this.warnPanel.setEnabled(this.useJVC());
        this.jvcExtBox.setEnabled(this.useJVC());
        return null;
    }

    static String removeJMX(String s) {
        int i = s.indexOf("-J-m");
        if (i < 0) {
            i = s.indexOf("-J-Xm");
        }
        if (i >= 0) {
            String res = s.substring(0, i);
            while (i < s.length() && s.charAt(i) != ' ') {
                ++i;
            }
            res = res + s.substring(i);
            return AJCompileAndBuild.removeJMX(res);
        }
        return s;
    }

    public String getCompilerString() {
        int type = this.tabbedPane.getSelectedIndex();
        return this.getCompilerString(type);
    }

    public String getCompilerString(int type) {
        switch (type) {
            case 0: {
                return (String)EditApp.App.getWorkspaceProperty("File.javac");
            }
            case 1: {
                return (String)EditApp.App.getWorkspaceProperty("File.jvc");
            }
        }
        if (Platforms.IsWindows()) {
            return VFile.resolveName("#jxebase/bin/jikes/jikes.exe");
        }
        return VFile.GetOSCapitalization("jikes");
    }

    public boolean useOutputDir() {
        return true;
    }

    public String getOutputDir() {
        String s = this.outputTxt.getText();
        return s;
    }

    public Vector getOptions() {
        int type = this.tabbedPane.getSelectedIndex();
        return this.getOptions(type);
    }

    public Vector getOptions(int type) {
        Vector<String> v = new Vector<String>(10);
        v.insertElementAt(this.getCurrentClineText().getText(), 0);
        boolean hasVMSourcePath = this.getCurrentClineText().getText().indexOf("-sourcepath") >= 0;
        switch (type) {
            case 0: 
            case 2: {
                if (this.nowarnChk.isPressed()) {
                    v.addElement("-nowarn");
                }
                if (this.dependChk.isPressed() && !Platforms.IsJDK12("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"))) {
                    v.addElement("-depend");
                }
                if (this.verboseChk.isPressed()) {
                    v.addElement("-verbose");
                }
                if (this.optimizeChk.isPressed()) {
                    v.addElement("-O");
                }
                if (this.gChk.isPressed()) {
                    v.addElement("-g");
                }
                if (this.isOutputDirEnabled()) {
                    v.addElement("-d");
                    v.addElement(this.outputTxt.getText());
                }
                try {
                    String out = EditApp.App.getTemplateEngine().insertEnvVars(this.outputTxt.getText(), null);
                    new File(out).mkdirs();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (Platforms.IsJDK12("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"))) {
                    String sp;
                    if (!hasVMSourcePath && (sp = This.getSourcePathAndCompute().trim()).length() > 0) {
                        v.addElement("-sourcepath");
                        v.addElement(sp);
                    }
                    v.addElement("-classpath");
                    v.addElement(this.classpathTxt.getText());
                    break;
                }
                v.addElement("-classpath");
                v.addElement(this.classpathTxt.getText() + File.pathSeparator + This.getSourcePathAndCompute());
                break;
            }
            case 1: {
                hasVMSourcePath = true;
                if (this.nowarnChk.isPressed()) {
                    v.addElement("/nowarn");
                }
                if (this.dependChk.isPressed()) {
                    v.addElement("/ref");
                } else {
                    v.addElement("/ref-");
                }
                if (this.optimizeChk.isPressed()) {
                    v.addElement("/O:I");
                    v.addElement("/O:J");
                }
                if (this.gChk.isPressed()) {
                    v.addElement("/g:l");
                    v.addElement("/g:t");
                }
                v.addElement("/d");
                v.addElement("\"" + this.outputTxt.getText() + "\"");
                if (this.classpathTxt.getText().trim().length() > 0) {
                    v.addElement("/cp");
                    v.addElement(this.classpathTxt.getText() + File.pathSeparator + This.getSourcePathAndCompute());
                }
                if (this.jvcExtBox.isPressed()) {
                    v.addElement("/x");
                } else {
                    v.addElement("/x-");
                }
                v.addElement("/w" + this.warnPanel.getValue());
                v.addElement("/nologo");
            }
        }
        return v;
    }

    public boolean isOutputDirEnabled() {
        return this.outputTxt.getText().trim().length() > 0;
    }

    void enableApplyButtons(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            this.loadProperty(pw.getStream("JavacOptions"));
            this.memBox.setEnabled(this.javawChk.isSelected());
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.ok();
    }

    void ok() {
        try {
            this.storeProperty(EditApp.App.getLocalWriter().copyAbsolute("tmp").createStream("compopt_tmp"));
            this.memBox.setEnabled(this.javawChk.isSelected());
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    void cancel() {
        try {
            this.loadProperty(EditApp.App.getLocalWriter().copyAbsolute("tmp").getStream("compopt_tmp"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadProperty(DataInputStream dis) throws Exception {
        try {
            this.nowarnChk.setPressed(dis.readBoolean());
            this.dependChk.setPressed(dis.readBoolean());
            this.verboseChk.setPressed(true);
            dis.readBoolean();
            this.verboseChk.setEnabled(false);
            this.optimizeChk.setPressed(dis.readBoolean());
            this.gChk.setPressed(dis.readBoolean());
            this.outputTxt.setText(dis.readUTF());
            this.classpathTxt.setText(dis.readUTF());
            if (dis.readBoolean()) {
                this.tabbedPane.setSelectedIndex(1);
            }
            this.jvcExtBox.setPressed(dis.readBoolean());
            this.warnPanel.setValue(dis.readInt());
            dis.readBoolean();
            if (EditApp.App.getPropertyFileVersion() > 12) {
                this.getCurrentClineText().setText(dis.readUTF());
            }
            if (EditApp.App.getPropertyFileVersion() > 13) {
                dis.readUTF();
            }
            this.clineJavac.setText(dis.readUTF());
            this.clineJikes.setText(dis.readUTF());
            this.clineJVC.setText(dis.readUTF());
            dis.readBoolean();
            this.tabbedPane.setSelectedIndex(dis.readInt());
            this.getFileSet().getListPanel().clear();
            this.outputTxt.fillCombo();
            this.rmiOut.setText(dis.readUTF());
            Vector classes = this.getFileSet().getListPanel().getList();
            int siz = dis.readInt();
            int n = 0;
            while (n < siz) {
                classes.addElement(new ListItem(dis.readUTF()));
                ++n;
            }
            this.rmiDebugChk.setSelected(dis.readBoolean());
            this.rmiNoWarnChk.setSelected(dis.readBoolean());
            dis.readBoolean();
            this.excludeCompileTxt.setText(dis.readUTF());
            this.sourcepathTxt.setText(dis.readUTF());
            this.getFileSet().getListPanel().repaint();
            this.plugBtn.setSelected(dis.readBoolean());
            this.useTmpFile.setSelected(dis.readBoolean());
            try {
                this.javawChk.setSelected(dis.readBoolean());
                this.memBox.setValue(dis.readInt());
            }
            catch (Exception ex) {
                this.javawChk.setSelected(true);
                this.memBox.setValue(64);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.enableApplyButtons(false);
    }

    public void setOptions(boolean debug, boolean nowarn, boolean optimize, boolean dependent, boolean enableOut) {
        this.dependChk.setPressed(debug);
        this.nowarnChk.setPressed(nowarn);
        this.optimizeChk.setPressed(optimize);
        this.dependChk.setPressed(dependent);
    }

    public void storeProperty(PropWriter pw) throws Exception {
        this.storeProperty(pw.createStream("JavacOptions"));
    }

    void storeProperty(DataOutputStream dos) throws Exception {
        dos.writeBoolean(this.nowarnChk.isPressed());
        dos.writeBoolean(this.dependChk.isPressed());
        dos.writeBoolean(this.verboseChk.isPressed());
        dos.writeBoolean(this.optimizeChk.isPressed());
        dos.writeBoolean(this.gChk.isPressed());
        dos.writeUTF(this.outputTxt.getText());
        dos.writeUTF(this.classpathTxt.getText());
        dos.writeBoolean(this.tabbedPane.getSelectedIndex() == 1);
        dos.writeBoolean(this.jvcExtBox.isPressed());
        dos.writeInt(this.warnPanel.getValue());
        dos.writeBoolean(true);
        dos.writeUTF("");
        dos.writeUTF("");
        dos.writeUTF(this.clineJavac.getText());
        dos.writeUTF(this.clineJikes.getText());
        dos.writeUTF(this.clineJVC.getText());
        dos.writeBoolean(false);
        dos.writeInt(this.tabbedPane.getSelectedIndex());
        dos.writeUTF(this.rmiOut.getText());
        Vector classes = this.getFileSet().getListPanel().getList();
        dos.writeInt(classes.size());
        int n = 0;
        while (n < classes.size()) {
            dos.writeUTF(((ListItem)classes.elementAt(n)).getDisplayString());
            ++n;
        }
        dos.writeBoolean(this.rmiDebugChk.isSelected());
        dos.writeBoolean(this.rmiNoWarnChk.isSelected());
        dos.writeBoolean(false);
        dos.writeUTF(this.excludeCompileTxt.getText());
        dos.writeUTF(this.sourcepathTxt.getText());
        dos.writeBoolean(this.plugBtn.isSelected());
        dos.writeBoolean(this.getUseTmpFile());
        dos.writeBoolean(this.getUseJavaW());
        dos.writeInt(this.memBox.getValue());
    }

    public boolean getUseJavaW() {
        return false;
    }

    public int getJavaWMaxMem() {
        return this.memBox.getValue();
    }

    public Object actionChk(Object arg, Object sender) {
        this.enableApplyButtons(true);
        return null;
    }

    public Vector getRMIFileSet() {
        return this.getFileSet().getListPanel().getList();
    }

    public String getRMIOutput() {
        return this.rmiOut.getText();
    }

    public boolean getRMIDebug() {
        return this.rmiDebugChk.isSelected();
    }

    public boolean getRMINoWarn() {
        return this.rmiNoWarnChk.isSelected();
    }

    public boolean getRMIOnBuild() {
        return false;
    }

    public void javawChk_itemStateChanged(ItemEvent var0) {
        this.memBox.setEnabled(this.javawChk.isSelected());
        this.enableApplyButtons(true);
    }

    public static String findPackageRoot(File root) {
        String[] dir = root.list();
        int n = 0;
        while (dir != null && n < dir.length) {
            File cur = new File(root, dir[n]);
            if (cur.isDirectory()) {
                String res = AJCompileAndBuild.findPackageRoot(cur);
                if (res != null) {
                    return res;
                }
            } else if (dir[n].toLowerCase().endsWith(".java")) {
                try {
                    String pack = DocumentStream.ScanPackage(cur);
                    String r = root.getAbsolutePath();
                    r = AJCompileAndBuild.findRoot(pack, r);
                    return r;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return root.getAbsolutePath();
                }
            }
            ++n;
        }
        return null;
    }

    public static String findPackage(File root) {
        String[] dir = root.list();
        int n = 0;
        while (dir != null && n < dir.length) {
            File cur = new File(root, dir[n]);
            if (cur.isDirectory()) {
                String res = AJCompileAndBuild.findPackage(cur);
                if (res != null) {
                    return res;
                }
            } else if (dir[n].toLowerCase().endsWith(".java")) {
                try {
                    String pack = DocumentStream.ScanPackage(cur);
                    return pack;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public static String findRoot(String pack, String path) {
        pack = pack.replace('.', File.separatorChar);
        String r = path;
        if (!(r = VFile.GetOSCapitalization(r)).toLowerCase().endsWith(pack.toLowerCase())) {
            return path;
        }
        r = r.substring(0, r.length() - pack.length());
        while (r.endsWith(File.separator)) {
            r = r.substring(0, r.length() - 1);
        }
        return r;
    }

    JArray findPackageRoots() {
        return this.findPackageRoots(new Vector(10));
    }

    JArray findPackageRootsDebug() {
        return this.findPackageRoots(EditApp.App.getScanableDirs());
    }

    JArray findPackageRoots(Vector v) {
        Vector v1 = EditApp.App.getDirsToCompile();
        int n = 0;
        while (n < v1.size()) {
            v.addElement(v1.elementAt(n));
            ++n;
        }
        JSet map = new JSet(10);
        int n2 = 0;
        while (n2 < v.size()) {
            String root;
            String s = (String)v.elementAt(n2);
            Tracer.This.println("CHECKING ROOT:" + s);
            if (!s.toLowerCase().endsWith(".jar") && !s.toLowerCase().endsWith(".zip") && (root = AJCompileAndBuild.findPackageRoot(new File(s))) != null) {
                map.add(root);
                if (root.startsWith("WARNING:")) {
                    map.add(s);
                }
                Tracer.This.println("FOUND:" + root);
            }
            ++n2;
        }
        JArray res = map.asJArray();
        res.sort();
        return res;
    }

    public String getDebugSourcePath() {
        JArray arr = this.findPackageRootsDebug();
        String sp = "";
        int n = 0;
        while (n < arr.size()) {
            sp = sp + arr.at(n) + File.pathSeparator;
            ++n;
        }
        return This.getSourcePathAndCompute() + File.pathSeparator + sp;
    }

    void computePathesIfEnabled() {
        if (this.plugBtn.isSelected()) {
            JArray arr = this.findPackageRoots();
            String sp = "";
            int n = 0;
            while (n < arr.size()) {
                sp = sp + arr.at(n) + File.pathSeparator;
                ++n;
            }
            this.sourcepathTxt.setText(sp);
        }
    }

    public String getSourcePathAndCompute() {
        this.computePathesIfEnabled();
        return this.sourcepathTxt.getText();
    }

    public Object actionApplication(Object arg, Object sender) {
        if (((IValue)arg).stringValue().equals("VisibleSourceChanged")) {
            this.computePathesIfEnabled();
        }
        return null;
    }

    public void plugBtn_itemStateChanged(ItemEvent var0) {
        this.sourcepathTxt.setEnabled(!this.plugBtn.isSelected());
        this.computePathesIfEnabled();
        this.enableApplyButtons(true);
    }

    public void runRMICBtn_actionPerformed(ActionEvent var0) {
        JavacPlugin pin = (JavacPlugin)EditApp.App.getPluginNamed("CompilerPlugin");
        pin.runRMIC();
    }

    public void jvcExtBox_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void dependJikes_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void gChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void nowarnChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void optimizeChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void verboseChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void dependChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void tabbedPane_stateChanged(ChangeEvent var0) {
        this.enableApplyButtons(true);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.cancel();
        this.enableApplyButtons(false);
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.ok();
        this.enableApplyButtons(false);
    }
}

