/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.DirIterator;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.DocumentStream;
import de.netcomputing.anyj.AJDeploymentPanelGUI;
import de.netcomputing.anyj.AJExecPanel;
import de.netcomputing.anyj.DeploymentEntry;
import de.netcomputing.anyj.application.XMLProjectDescription;
import de.netcomputing.anyj.gui.AJClassSetBean;
import de.netcomputing.anyj.gui.AJEnvFileTextField;
import de.netcomputing.anyj.gui.AJFileSetBean;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.propertystore.beans.PathEditorBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JCheckBox;
import javax.swing.JTabbedPane;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Executor;
import netcomputing.tools.INCPrintOut;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;
import plugins.DebuggerPlugin;
import util.ClassFile;

public class AJDeploymentPanel
extends NCPanel {
    NCButton copyBtn;
    JTabbedPane tabbedPane;
    JCheckBox disableChk;
    JCheckBox recurseChk;
    NCTextField includeFilterTxt;
    NCTextField filterTxt;
    PathEditorBean resbaseTxt;
    AJEnvFileTextField copyTxt;
    NCTextField outputTxt;
    NCCheckBox hideOutputBox;
    NCTextField mainclassTxt;
    NCCheckBox exeBox;
    NCCheckBox compressBox;
    NCCheckBox createJarBox;
    AJClassSetBean beanClasses;
    AJFileSetBean fileSet;
    JUnsafeTable settings = new JUnsafeTable(13);
    String lastSel;

    public AJDeploymentPanel() {
        this.initGui();
    }

    public void initGui() {
        new AJDeploymentPanelGUI().createGui(this);
        this.copyBtn.setMnemonic('U');
        this.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init() {
        super.init();
        if (Platforms.IsLinux()) {
            this.copyTxt.setText("/tmp");
        } else {
            this.copyTxt.setText("c:\\temp");
        }
        this.fileSet.getListPanel().addTarget(this, "actionListSel");
        this.filterTxt.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                AJDeploymentPanel.this.inputChanged();
            }
        });
        this.createJarBox.setPressed(true);
        this.createJarBox.addTarget(this, "actionJarBoxPressed");
        this.exeBox.addTarget(this, "actionExeBoxPressed");
        this.exeBox.setVisible(false);
        this.hideOutputBox.setVisible(false);
        this.copyBtn.addTarget(this, "actionCopy");
        this.inputChanged();
        this.validateControlState();
        this.setName("hiddependencychecker");
        this.actionListSel(null, null);
    }

    void validateControlState() {
        this.compressBox.setEnabled(this.createJarBox.isPressed());
        this.hideOutputBox.setEnabled(this.exeBox.isPressed());
    }

    public Object actionJarBoxPressed(Object arg, Object sen) {
        this.validateControlState();
        return null;
    }

    public Object actionExeBoxPressed(Object arg, Object sen) {
        this.validateControlState();
        return null;
    }

    public void storeProperty(PropWriter pw) throws Exception {
        DataOutputStream out = pw.createStream(this);
        out.writeInt(this.fileSet.getListPanel().listSize());
        int n = 0;
        while (n < this.fileSet.getListPanel().listSize()) {
            File dir = (File)((BasicListItem)this.fileSet.getListPanel().at(n)).wrappedObject();
            DeploymentEntry entry = (DeploymentEntry)this.settings.get(dir.getAbsolutePath());
            out.writeUTF(entry.file);
            out.writeUTF(entry.includeFilter);
            out.writeUTF(entry.excludeFilter);
            out.writeBoolean(entry.enabled);
            out.writeBoolean(entry.recurse);
            ++n;
        }
        out.writeUTF(this.outputTxt.getText());
        out.writeUTF(this.resbaseTxt.getText());
        out.writeUTF(this.mainclassTxt.getText());
        out.writeUTF(this.copyTxt.getText());
        NCCheckBox[] checks = new NCCheckBox[]{this.createJarBox, this.compressBox, this.exeBox, this.hideOutputBox};
        int n2 = 0;
        while (n2 < checks.length) {
            out.writeBoolean(checks[n2].isPressed());
            ++n2;
        }
        out.writeInt(this.beanClasses.getListPanel().getList().size());
        Vector v = this.beanClasses.getListPanel().getList();
        int n3 = 0;
        while (n3 < v.size()) {
            String clazz = ((ListItem)v.elementAt(n3)).getDisplayString();
            out.writeUTF(clazz);
            ++n3;
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            DataInputStream in = pw.getStream(this);
            if (this.fileSet != null) {
                this.fileSet.getListPanel().clear();
            }
            int len = in.readInt();
            int n = 0;
            while (n < len) {
                DeploymentEntry entry = new DeploymentEntry();
                entry.file = in.readUTF();
                entry.includeFilter = in.readUTF();
                entry.excludeFilter = in.readUTF();
                entry.enabled = in.readBoolean();
                entry.recurse = in.readBoolean();
                this.settings.put(entry.file, entry);
                this.fileSet.addFile(new File(entry.file));
                ++n;
            }
            this.outputTxt.setText(in.readUTF());
            this.resbaseTxt.setText(in.readUTF());
            this.mainclassTxt.setText(in.readUTF());
            this.copyTxt.setText(in.readUTF());
            NCCheckBox[] checks = new NCCheckBox[]{this.createJarBox, this.compressBox, this.exeBox, this.hideOutputBox};
            int n2 = 0;
            while (n2 < checks.length) {
                checks[n2].setPressed(in.readBoolean());
                ++n2;
            }
            this.exeBox.setVisible(false);
            this.hideOutputBox.setVisible(false);
            this.exeBox.setPressed(false);
            this.hideOutputBox.setPressed(false);
            int siz = in.readInt();
            int n3 = 0;
            while (n3 < siz) {
                String clazz = in.readUTF();
                this.beanClasses.getListPanel().addItem(new ListItem(clazz));
                ++n3;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.validateControlState();
    }

    void inputChanged() {
        File f = (File)this.fileSet.getListPanel().getSelectedObject();
        this.filterTxt.setEnabled(f != null);
        this.includeFilterTxt.setEnabled(f != null);
    }

    public Object actionListSel(Object arg, Object sen) {
        this.tabbedPane.setSelectedIndex(0);
        if (this.lastSel != null) {
            this.readEntry(this.lastSel);
        }
        this.lastSel = this.fileSet.getListPanel().getSelectedObject() != null ? ((File)this.fileSet.getListPanel().getSelectedObject()).getAbsolutePath() : null;
        if (this.lastSel == null) {
            this.filterTxt.setEnabled(false);
            this.includeFilterTxt.setEnabled(false);
            this.recurseChk.setEnabled(false);
            this.disableChk.setEnabled(false);
            this.filterTxt.setText("");
            this.includeFilterTxt.setText("");
        } else {
            this.filterTxt.setEnabled(true);
            this.includeFilterTxt.setEnabled(true);
            this.recurseChk.setEnabled(true);
            this.disableChk.setEnabled(true);
            this.setSelection(this.lastSel);
        }
        return null;
    }

    public void addFile(File f) {
        this.fileSet.addFile(f);
    }

    boolean checkJar(ZipFile zf, String sourcefile) {
        String id = sourcefile.replace('\\', '/');
        Tracer.This.println("JAR lookup file " + id);
        ZipEntry ze = zf.getEntry(id);
        return ze != null;
    }

    void handleFile(File f, String inFilterString, Vector includeFilter, Vector filter, File base, Vector resbase, AJExecPanel out) throws Exception {
        int fn;
        String name = f.getName();
        boolean skip = true;
        if (!"all".equals(inFilterString) && !"".equals(inFilterString)) {
            fn = 0;
            while (fn < includeFilter.size()) {
                if (name.endsWith((String)includeFilter.elementAt(fn))) {
                    skip = false;
                    break;
                }
                ++fn;
            }
        } else {
            skip = false;
        }
        if (!skip) {
            fn = 0;
            while (fn < filter.size()) {
                if (name.endsWith((String)filter.elementAt(fn))) {
                    skip = true;
                    break;
                }
                ++fn;
            }
        }
        if (!skip && !f.isDirectory()) {
            if (name.endsWith(".java")) {
                String pack = DocumentStream.ScanPackage(f);
                pack = pack.startsWith(File.separator) ? "" : pack.replace('.', File.separatorChar);
                String newFile = base + File.separator + pack;
                new File(newFile).mkdirs();
                newFile = newFile + File.separator + f.getName();
                VFile.Copy(f, new File(newFile));
            } else if (name.endsWith(".class")) {
                ClassFile cf = new ClassFile();
                FileInputStream in = new FileInputStream(f);
                cf.read(in);
                String pack = cf.getClassName();
                pack = pack.indexOf(46) >= 0 ? pack.substring(0, pack.lastIndexOf(46)) : "";
                File tmp = new File(base.getAbsolutePath() + File.separator + pack.replace('.', File.separatorChar));
                tmp.mkdirs();
                VFile.Copy(f, new File(tmp, name));
            } else {
                String path = f.getAbsolutePath();
                boolean foundBase = false;
                int count = 0;
                while (!foundBase && count < resbase.size()) {
                    String rb = ("" + resbase.elementAt(count)).toLowerCase();
                    if (path.toLowerCase().startsWith(rb)) {
                        path = path.substring(rb.length());
                        File dest = new File(base + File.separator + path);
                        String destDir = VFile.RemoveLast(dest.getAbsolutePath());
                        new File(destDir).mkdirs();
                        VFile.Copy(f, dest);
                        foundBase = true;
                    }
                    ++count;
                }
                if (!foundBase) {
                    out.addMessage("* Warning: File " + f.getAbsolutePath() + " not copied, outside of resourcebase " + resbase);
                }
            }
        }
    }

    void handleJar(DeploymentEntry entry, AJExecPanel out, File dir, File base, String inFilterString, Vector includeFilter, Vector filter, Vector resbase) throws Exception {
        if (entry.enabled) {
            out.addMessage("Extracting jar:" + dir.getAbsolutePath());
            String jdkBin = "" + EditApp.App.getWorkspaceProperty("Directory.jdkHome") + File.separator + "bin" + File.separator;
            Process p = Executor.Exec(jdkBin + "jar -xf " + dir.getAbsolutePath(), base.getAbsolutePath(), out);
            p.waitFor();
            out.addMessage("...finished extracting jar");
        } else {
            this.handleFile(dir, inFilterString, includeFilter, filter, base, resbase, out);
        }
    }

    public Object actionCopy(Object arg, Object sen) {
        JWidgetsUtil.AddLongRunningJob(new Runnable(){

            public void run() {
                AJDeploymentPanel.this.runDeployment();
            }
        });
        return null;
    }

    public String runDeployment() {
        this.actionListSel(null, null);
        AJExecPanel out = new AJExecPanel(EditApp.App){

            public void init() {
                super.init();
                this.stopBtn.hide();
                this.txtField.hide();
                this.processBtn.hide();
            }

            public void startProcess() {
            }
        };
        JEBatchHostFrame.This().addPanel("Deploying " + VFile.NameWithoutExtension(this.outputTxt.getText()), out, true, NCApplication.GetImage("/images/filetypes/jar.gif"));
        JEBatchHostFrame.This().showTab("Deploying " + VFile.NameWithoutExtension(this.outputTxt.getText()));
        out.init();
        File base = new File(EditApp.App.getTemplateEngine().insertEnvVars(this.copyTxt.getText(), null));
        base.mkdirs();
        DebuggerPlugin jpin = DebuggerPlugin.This();
        String classpath = "";
        if (jpin != null) {
            classpath = jpin.getClasspath();
        }
        Vector cp = NCStringUtilities.SplitSeparatedString(File.pathSeparator, classpath);
        if (this.resbaseTxt.getText().length() == 0) {
            String rb = VFile.resolveName("#actproject");
            this.resbaseTxt.setText(rb);
        }
        Vector resbase = NCStringUtilities.SplitSeparatedString(";", EditApp.App.getTemplateEngine().insertEnvVars(this.resbaseTxt.getText().trim(), null));
        int n = 0;
        while (n < cp.size()) {
            String act = cp.elementAt(n).toString();
            if (!act.startsWith("/") && act.length() > 0 && act.charAt(1) != ':') {
                act = "" + resbase.elementAt(0) + File.separator + act;
                cp.setElementAt(act, n);
            }
            ++n;
        }
        if (!base.exists()) {
            ConfirmDiag.Msg((Window)this.getFrame(), "Failed to create " + base.getAbsolutePath());
            return null;
        }
        out.printLine("Start copying ...");
        int n2 = 0;
        while (n2 < this.fileSet.getListPanel().listSize()) {
            try {
                File dir = (File)((BasicListItem)this.fileSet.getListPanel().at(n2)).wrappedObject();
                DeploymentEntry entry = (DeploymentEntry)this.settings.get(dir.getAbsolutePath());
                String filterString = entry.excludeFilter;
                String inFilterString = entry.includeFilter;
                Vector filter = NCStringUtilities.SplitSeparatedString(";", filterString);
                Vector includeFilter = NCStringUtilities.SplitSeparatedString(";", inFilterString);
                if ((entry.enabled || dir.getName().endsWith(".jar")) && dir.getName().endsWith(".jar")) {
                    this.handleJar(entry, out, dir, base, inFilterString, includeFilter, filter, resbase);
                }
                if (dir.isDirectory()) {
                    Vector cont = DirIterator.DirContent(dir, "", entry.recurse);
                    int files = 0;
                    while (files < cont.size()) {
                        File f = (File)cont.elementAt(files);
                        this.handleFile(f, inFilterString, includeFilter, filter, base, resbase, out);
                        ++files;
                    }
                } else {
                    this.handleFile(dir, inFilterString, includeFilter, filter, base, resbase, out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                out.addMessage("** Error:" + e.getClass().getName() + ":" + e.getMessage());
            }
            ++n2;
        }
        out.printLine("... Finished copying");
        if (this.exeBox.isPressed()) {
            this.createExe(out, base.getAbsolutePath(), jpin);
        }
        if (this.createJarBox.isPressed()) {
            return this.createJar(out, base.getAbsolutePath(), jpin);
        }
        out.printLine("* DONE (concurrent processes may still run) *");
        return null;
    }

    void createExe(INCPrintOut out, String wdir, DebuggerPlugin dbin) {
        String mainClz = this.mainclassTxt.getText();
        String jarName = this.outputTxt.getText();
        if (jarName.trim().length() == 0) {
            jarName = mainClz;
            int i = jarName.lastIndexOf(46);
            if (i >= 0) {
                jarName = jarName.substring(i + 1);
            }
            if (jarName.length() == 0) {
                jarName = "unnamed";
            }
            this.outputTxt.setText(jarName);
        }
        jarName = VFile.NameWithExtension(jarName) + ".exe";
        out.printLine("Creating EXE:" + new File(wdir).getParent() + File.separator + jarName);
        String cline = EditApp.App.getWorkspaceProperty("Directory.msdkHome") + File.separator + "bin" + File.separator;
        cline = cline + "jexegen /R " + (this.hideOutputBox.isPressed() ? "/W" : "") + " /OUT:.." + File.separator + jarName + " /MAIN:" + mainClz + " *.*";
        Executor.Exec(cline, wdir, out);
    }

    String createJar(INCPrintOut out, String wdir, DebuggerPlugin dbin) {
        out.printLine("packing to jar ....");
        String mainClz = this.mainclassTxt.getText();
        String jarName = this.outputTxt.getText();
        if (jarName.trim().length() == 0) {
            jarName = mainClz;
            int i = jarName.lastIndexOf(46);
            if (i >= 0) {
                jarName = jarName.substring(i + 1);
            }
            if (jarName.length() == 0) {
                jarName = "unnamed";
            }
            this.outputTxt.setText(jarName);
        }
        if (jarName.indexOf(".") < 0) {
            jarName = VFile.NameWithoutExtension(jarName) + ".jar";
        }
        try {
            new File(wdir + File.separator + "META-INF/MANIFEST.MF").delete();
            new File(wdir + File.separator + "META-INF").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String manifestString = "";
        if (mainClz.trim().length() > 0 || this.beanClasses.getListPanel().listSize() > 0) {
            try {
                FileOutputStream fout = new FileOutputStream(wdir + File.separator + "manifest.txt");
                PrintStream pout = new PrintStream(fout);
                pout.println("Main-Class: " + mainClz);
                pout.println();
                Vector v = this.beanClasses.getListPanel().getList();
                int n = 0;
                while (n < v.size()) {
                    String clazz = ((ListItem)v.elementAt(n)).getDisplayString().replace('.', '/') + ".class";
                    pout.println("Name: " + clazz);
                    pout.println("Java-Bean: True");
                    pout.println();
                    ++n;
                }
                fout.close();
                manifestString = "manifest.txt";
            }
            catch (Exception e) {
                e.printStackTrace();
                out.printLine("Error:failed to create manifest");
            }
        }
        String jdkBin = "" + EditApp.App.getWorkspaceProperty("Directory.jdkHome") + File.separator + "bin" + File.separator;
        String result = new File(wdir).getParent() + File.separator + jarName;
        out.printLine("Creating JAR:" + result);
        try {
            if (this.compressBox.isPressed()) {
                if (manifestString.length() == 0) {
                    out.printLine("jar -cf .." + File.separator + jarName + " *");
                    Executor.Exec(jdkBin + "jar -cf .." + File.separator + jarName + " *", wdir, out).waitFor();
                } else {
                    out.printLine("jar -cmf " + manifestString + " .." + File.separator + jarName + " *");
                    Executor.Exec(jdkBin + "jar -cmf " + manifestString + " .." + File.separator + jarName + " *", wdir, out).waitFor();
                }
            } else if (manifestString.length() == 0) {
                out.printLine("jar -c0f .." + File.separator + jarName + " *");
                Executor.Exec(jdkBin + "jar -c0f .." + File.separator + jarName + " *", wdir, out).waitFor();
            } else {
                out.printLine("jar -c0mf " + manifestString + " .." + File.separator + jarName + " *");
                Executor.Exec(jdkBin + "jar -c0mf " + manifestString + " .." + File.separator + jarName + " *", wdir, out).waitFor();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    void readEntry(String fi) {
        DeploymentEntry entry = (DeploymentEntry)this.settings.get(fi);
        if (entry != null) {
            entry.includeFilter = this.includeFilterTxt.getText();
            entry.excludeFilter = this.filterTxt.getText();
            entry.recurse = this.recurseChk.isSelected();
            entry.enabled = !this.disableChk.isSelected();
        }
    }

    void applyEntry(DeploymentEntry de) {
        this.includeFilterTxt.setText(de.includeFilter);
        this.filterTxt.setText(de.excludeFilter);
        this.recurseChk.setSelected(de.recurse);
        this.disableChk.setSelected(!de.enabled);
    }

    void setSelection(String fi) {
        if (this.settings.get(fi) == null) {
            DeploymentEntry newOne = new DeploymentEntry();
            newOne.file = fi;
            this.settings.put(fi, newOne);
        }
        DeploymentEntry entry = (DeploymentEntry)this.settings.get(fi);
        this.applyEntry(entry);
    }

    public void writeXML(Node n, String name, String baseDir) {
        n.putField("Name", name);
        Enumeration en = this.settings.elements();
        while (en.hasMoreElements()) {
            DeploymentEntry de = (DeploymentEntry)en.nextElement();
            Node sub = new Node(n, "DeploymentEntry");
            sub.putField("File.content", NCFileUtilities.RelativeFile(null, baseDir, de.file));
            sub.putField("IncludeFilter.content", de.includeFilter);
            sub.putField("ExcludeFilter.content", de.excludeFilter);
            sub.putField("Recurse.content", de.recurse);
            sub.putField("Enabled.content", de.enabled);
        }
        n.putField("RessourceBase.content", NCFileUtilities.RelativePath(null, baseDir, this.resbaseTxt.getText()));
        n.putField("JarName.content", this.outputTxt.getText());
        n.putField("OuputDir.content", NCFileUtilities.RelativeFile(null, baseDir, this.copyTxt.getText()));
        n.putField("MainClass.content", this.mainclassTxt.getText());
        n.putField("CreateJar.content", this.createJarBox.isSelected());
        n.putField("UseCompression.content", this.compressBox.isSelected());
        Vector v = this.beanClasses.getListPanel().getList();
        int nn = 0;
        while (nn < v.size()) {
            Node sub = new Node(n, "BeanEntry");
            sub.putField("class.content", ((BasicListItem)v.elementAt(nn)).getDisplayString());
            ++nn;
        }
    }

    public void readXML(Node n, XMLProjectDescription xmlPrj) {
        XMLIterator en = n.getSubnodes("DeploymentEntry");
        while (en.hasMoreElements()) {
            DeploymentEntry de = new DeploymentEntry();
            Node sub = (Node)en.nextElement();
            de.file = xmlPrj.derelativeDir(sub.getField("File.content", ""));
            this.addFile(new File(xmlPrj.derelativeDir(de.file)));
            de.includeFilter = sub.getField("IncludeFilter.content", "");
            de.excludeFilter = sub.getField("ExcludeFilter.content", "");
            de.recurse = sub.getBooleanField("Recurse.content", true);
            de.enabled = sub.getBooleanField("Enabled.content", true);
            this.applyEntry(de);
        }
        this.resbaseTxt.setText(xmlPrj.derelativePath(n.getField("RessourceBase.content", "")));
        this.outputTxt.setText(n.getField("JarName.content", ""));
        this.copyTxt.setText(xmlPrj.derelativeDir(n.getField("OuputDir.content", "")));
        this.mainclassTxt.setText(n.getField("MainClass.content", ""));
        this.createJarBox.setSelected(n.getBooleanField("CreateJar.content", true));
        this.compressBox.setSelected(n.getBooleanField("UseCompression.content", true));
        en = n.getSubnodes("BeanEntry");
        while (en.hasMoreElements()) {
            String s = ((Node)en.nextElement()).getField("class.content", "");
            this.beanClasses.getListPanel().addLine(s);
        }
    }

    public void addDeploymentEntry(File f, String incl, String excl, boolean rec, boolean enab) {
        DeploymentEntry de = new DeploymentEntry();
        de.file = f.getAbsolutePath();
        this.addFile(new File(de.file));
        de.includeFilter = incl;
        de.excludeFilter = excl;
        de.recurse = rec;
        de.enabled = enab;
        this.applyEntry(de);
    }

    public void setOptions(String resBase, String jarName, String outDir, String mainClz, boolean createJar, boolean compress) {
        this.resbaseTxt.setText(resBase);
        this.outputTxt.setText(jarName);
        this.copyTxt.setText(outDir);
        this.mainclassTxt.setText(mainClz);
        this.createJarBox.setSelected(createJar);
        this.compressBox.setSelected(compress);
    }

    public void fileSet_actionPerformed(ActionEvent var0) {
        String file2 = var0.getActionCommand();
        if (this.lastSel != null) {
            this.readEntry(this.lastSel);
        }
        this.fileSet.getListPanel().setSelectedString(file2);
        this.actionListSel(null, null);
        this.setSelection(file2);
    }
}

