/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JArray;
import JWVFile.VFile;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJDirDiffGUI;
import de.netcomputing.anyj.application.ICloseable;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.DiffDirNode;
import de.netcomputing.anyj.jwidgets.DirDiffResult;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTabbedPane;

public class AJDirDiff
extends NCPanel
implements FilenameFilter,
ICloseable {
    JCheckBox ignoreComments;
    PropertyFileSel dirBTxt;
    NCButton compareBtn;
    NCButton copyAtoBBtn;
    NCButton copyBtoABtn;
    NCButton inspectBtn;
    NCTextField endTxt;
    PropertyFileSel dirATxt;
    JButton openBtn;
    JButton openBBtn;
    JButton openABtn;
    JTabbedPane tabbedPane;
    NCTreeBean aTree;
    NCTreeBean listPanel;
    static int cnt = 1000;

    public AJDirDiff() {
        this.initGui();
    }

    public void initGui() {
        new AJDirDiffGUI().createGui(this);
        this.dirATxt.setText("");
        this.dirBTxt.setText("");
        this.endTxt.setText(".java");
        this.listPanel.clear();
        this.listPanel.addTarget(this, "actionListSelect");
        this.aTree.addTarget(this, "actionListSelect");
        this.aTree.doubleClickBinder().addTarget(this, "actionListDoubleSelect");
        this.listPanel.doubleClickBinder().addTarget(this, "actionListDoubleSelect");
        this.dirATxt.addKeyListener(new KeyFilter(10, this, "actionCompare"));
        this.dirBTxt.addKeyListener(new KeyFilter(10, this, "actionCompare"));
        this.endTxt.addKeyListener(new KeyFilter(10, this, "actionCompare"));
        this.setName("hidDirDiff");
        this.init();
        this.actionListSelect(null, null);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    File[] getSelectedFiles() {
        DiffDirNode sel = null;
        if (this.tabbedPane.getSelectedIndex() == 0 && this.aTree.getSelectedItem() instanceof DiffDirNode) {
            sel = (DiffDirNode)this.aTree.getSelectedItem();
        } else if (this.listPanel.getSelectedItem() instanceof DiffDirNode) {
            sel = (DiffDirNode)this.listPanel.getSelectedItem();
        }
        if (sel != null) {
            DirDiffResult desc = sel.getDesc();
            switch (sel.getDiffType()) {
                case 68: {
                    return new File[]{new File(desc.getDiffRoot() + File.separator + sel.getFile().getPath()), new File(desc.getDiffBRoot() + File.separator + sel.getFile().getPath())};
                }
                case 43: {
                    return new File[]{new File(desc.getDiffRoot() + File.separator + sel.getFile().getPath()), null};
                }
                case 45: {
                    return new File[]{null, new File(desc.getDiffBRoot() + File.separator + sel.getFile().getPath())};
                }
                case 32: {
                    return new File[]{new File(desc.getDiffRoot() + File.separator + sel.getFile().getPath()), new File(desc.getDiffBRoot() + File.separator + sel.getFile().getPath())};
                }
            }
        }
        return null;
    }

    public void setFiles(String a, String b) {
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.compareBtn);
        }
        this.dirATxt.setText(a);
        this.dirBTxt.setText(b);
        this.listPanel.clear();
    }

    public void compare(File a, File b) {
        this.listPanel.clear();
        this.aTree.clear();
        try {
            DirDiffResult res = NCFileUtilities.compare(a, b, this, this.ignoreComments.isSelected(), true);
            this.aTree.addItemRepainting(new DiffDirNode(new File(File.separator), res));
            JArray adds = new JArray();
            adds.addAll(res.getAdded().enumerate());
            adds.sort();
            JArray rems = new JArray();
            rems.addAll(res.getRemoved().enumerate());
            rems.sort();
            JArray diffs = new JArray();
            diffs.addAll(res.getDiffs().enumerate());
            diffs.sort();
            this.listPanel.addLine("New in " + a.getAbsolutePath());
            this.listPanel.addLine("");
            int i = 0;
            while (i < adds.size()) {
                String act = (String)adds.at(i);
                this.listPanel.addItem(new DiffDirNode(new File(act), res));
                ++i;
            }
            this.listPanel.addLine("");
            this.listPanel.addLine("New in " + b.getAbsolutePath());
            this.listPanel.addLine("");
            int i2 = 0;
            while (i2 < rems.size()) {
                String act = (String)rems.at(i2);
                this.listPanel.addItem(new DiffDirNode(new File(act), res));
                ++i2;
            }
            this.listPanel.addLine("");
            this.listPanel.addLine("Changed Files");
            this.listPanel.addLine("");
            int i3 = 0;
            while (i3 < diffs.size()) {
                String act = (String)diffs.at(i3);
                this.listPanel.addItem(new DiffDirNode(new File(act), res));
                ++i3;
            }
            this.actionListSelect(null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
            return;
        }
    }

    public void frameClosing() {
        EditApp.App.dropFrame((Window)this.getFrame());
    }

    public void openSimpleFileDiff(String title, String titleA, String titleB, TextDocument a, TextDocument b) {
        EditApp.App.openSimpleFileDiff(title, titleA, titleB, a, b);
    }

    public boolean accept(File dir, String name) {
        String na = name.toUpperCase();
        return na.endsWith(this.endTxt.getText().toUpperCase()) || new File(dir, name).isDirectory();
    }

    public void openBBtn_actionPerformed(ActionEvent var0) {
        if (this.getSelectedFiles() != null) {
            EditApp.App.openEditorOrShow(this.getSelectedFiles()[1].getAbsolutePath());
        }
    }

    public void openABtn_actionPerformed(ActionEvent var0) {
        if (this.getSelectedFiles() != null) {
            EditApp.App.openEditorOrShow(this.getSelectedFiles()[0].getAbsolutePath());
        }
    }

    public void openBtn_actionPerformed(ActionEvent var0) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(new VFile("#process/outtmp" + ++cnt + ".txt")));
            Vector v = this.listPanel.getList();
            int n = 0;
            while (n < v.size()) {
                out.println(((BasicListItem)v.elementAt(n)).getDisplayString());
                ++n;
            }
            out.close();
            EditApp.App.openEditorOrShow(new VFile("#process/outtmp" + cnt + ".txt").getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object actionListDoubleSelect(Object arg, Object sen) {
        File[] sel = this.getSelectedFiles();
        if (sel == null) {
            return null;
        }
        if (sel[1] != null && sel[0] != null) {
            this.inspectBtn_actionPerformed(null);
        } else if (sel[1] != null || sel[0] != null) {
            if (sel[1] == null) {
                EditApp.App.openEditorOrShow(sel[0].getAbsolutePath());
            } else {
                EditApp.App.openEditorOrShow(sel[1].getAbsolutePath());
            }
        }
        return null;
    }

    public Object actionListSelect(Object arg, Object sen) {
        File[] sel = this.getSelectedFiles();
        if (sel == null) {
            this.inspectBtn.setEnabled(false);
            this.copyAtoBBtn.setEnabled(false);
            this.copyBtoABtn.setEnabled(false);
            this.openABtn.setEnabled(false);
            this.openBBtn.setEnabled(false);
        } else {
            this.inspectBtn.setEnabled(sel[1] != null && sel[0] != null && !sel[0].isDirectory());
            this.copyAtoBBtn.setEnabled(sel[0] != null && !sel[0].isDirectory());
            this.copyBtoABtn.setEnabled(sel[1] != null && !sel[1].isDirectory());
            this.openABtn.setEnabled(sel[0] != null && !sel[0].isDirectory());
            this.openBBtn.setEnabled(sel[1] != null && !sel[1].isDirectory());
        }
        return null;
    }

    public void inspectBtn_actionPerformed(ActionEvent var0) {
        File[] sel = this.getSelectedFiles();
        if (sel == null) {
            return;
        }
        TextDocument docA = new TextDocument();
        TextDocument docB = new TextDocument();
        docA.init(null);
        docB.init(null);
        docA.coreLoad(sel[0]);
        docB.coreLoad(sel[1]);
        this.openSimpleFileDiff("FileDiff", sel[0].getAbsolutePath(), sel[1].getAbsolutePath(), docA, docB);
    }

    public void copyAtoBBtn_actionPerformed(ActionEvent var0) {
        File[] sel = this.getSelectedFiles();
        if (sel == null) {
            return;
        }
        try {
            if (sel[1] == null) {
                sel[1] = new File(this.dirBTxt.getText() + sel[0].getAbsolutePath().substring(this.dirATxt.getText().length()));
            }
            new File(sel[1].getParent()).mkdirs();
            VFile.Copy(sel[0], sel[1]);
        }
        catch (Exception e) {
            ConfirmDiag.Msg(null, "File Copy failed");
        }
    }

    public void copyBtoABtn_actionPerformed(ActionEvent var0) {
        File[] sel = this.getSelectedFiles();
        if (sel == null) {
            return;
        }
        try {
            if (sel[0] == null) {
                sel[0] = new File(this.dirATxt.getText() + sel[1].getAbsolutePath().substring(this.dirBTxt.getText().length()));
            }
            new File(sel[0].getParent()).mkdirs();
            VFile.Copy(sel[1], sel[0]);
        }
        catch (Exception e) {
            ConfirmDiag.Msg(null, "File Copy failed");
        }
    }

    public void compareBtn_actionPerformed(ActionEvent var0) {
        while (this.dirATxt.getText().endsWith(File.separator)) {
            this.dirATxt.setText(this.dirATxt.getText().substring(0, this.dirATxt.getText().length() - 1));
        }
        while (this.dirBTxt.getText().endsWith(File.separator)) {
            this.dirBTxt.setText(this.dirBTxt.getText().substring(0, this.dirBTxt.getText().length() - 1));
        }
        File a = new File(this.dirATxt.getText());
        File b = new File(this.dirBTxt.getText());
        NCApplication.Pln(a + " " + b);
        if (!(a.isDirectory() && a.exists() && b.isDirectory() && b.exists())) {
            Confirm.ModalMsg((Window)this.getFrame(), "Error", new String[]{"The specified paths are not existent", "or not directories."});
            return;
        }
        this.compare(a, b);
    }
}

