/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import Jxe.JXEOptions;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJGenAccessorsGUI;
import de.netcomputing.anyj.jwidgets.BooleanItem;
import de.netcomputing.anyj.jwidgets.IntValue;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import editapp.FieldDescription;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class AJGenAccessors
extends NCPanel {
    JComboBox combo;
    NCButton cancelBtn;
    NCTreeBean listPanel;
    NCButton accessorBtn;
    NCCheckBox settersChk;
    NCCheckBox gettersChk;
    NCCheckBox remFirstChk;
    IndexEntry[] ies;
    IndexEntry lastClz;
    TextDocument doc;

    public static void Open(IndexEntry ie, TextDocument doc) {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Generate Accessors", true);
        AJGenAccessors ajem = new AJGenAccessors();
        dlg.getContentPane().add(ajem);
        dlg.pack();
        dlg.setSize(500, 400);
        ApplicationHelper.Singleton().centerWindow(dlg);
        ajem.init(ie, doc);
        ajem.getRootPane().setDefaultButton(ajem.accessorBtn);
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }

    public AJGenAccessors() {
        this.initGui();
    }

    public void initGui() {
        new AJGenAccessorsGUI().createGui(this);
        this.listPanel.binderIconClick().addTarget(this, "actionIconClick");
    }

    public Object actionIconClick(Object arg, Object sen) {
        int sel = ((IntValue)arg).intValue();
        if (sel >= 0 && sel < this.listPanel.listSize()) {
            BooleanItem item;
            item.setIsSel(!(item = (BooleanItem)this.listPanel.at(sel)).getIsSel());
            this.listPanel.repaintStartingAt(sel, 1);
        }
        return null;
    }

    public void init(IndexEntry clz, TextDocument adoc) {
        this.doc = adoc;
        this.lastClz = clz;
        this.ies = SourceBase.This().deriveLineFor(clz);
        this.combo.setModel(new DefaultComboBoxModel<IndexEntry>(this.ies));
        this.combo.setSelectedIndex(0);
        this.reinit();
    }

    void reinit() {
        HashSet<String> prevSel = new HashSet<String>();
        int i = 0;
        while (i < this.listPanel.listSize()) {
            MyBoolItem it = (MyBoolItem)this.listPanel.at(i);
            if (it.getIsSel()) {
                prevSel.add(it.ie.getName());
            }
            ++i;
        }
        this.listPanel.clear();
        HashSet set = new HashSet();
        int i2 = 0;
        while (i2 < this.combo.getSelectedIndex() + 1) {
            set.addAll(SourceBase.This().getMethodsAndFieldsOf(this.ies[i2]));
            ++i2;
        }
        HashSet<String> alreadyIn = new HashSet<String>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexEntry act = (IndexEntry)it.next();
            if (!act.isField() || alreadyIn.contains(act.getName())) continue;
            alreadyIn.add(act.getName());
            MyBoolItem bi = new MyBoolItem(act, act.getName() + "  [" + act.getType() + "]");
            bi.setIsSel(prevSel.contains(act.getName()));
            this.listPanel.addItem(bi);
        }
        this.listPanel.sortByString(true);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void combo_actionPerformed(ActionEvent var0) {
        if (this.lastClz != null) {
            this.reinit();
        }
    }

    public void accessorBtn_actionPerformed(ActionEvent var0) {
        int x = this.doc.cX();
        int y = this.doc.cY();
        ((Window)this.getTopLevelAncestor()).dispose();
        int i = 0;
        while (i < this.listPanel.listSize()) {
            MyBoolItem it = (MyBoolItem)this.listPanel.at(i);
            if (it.getIsSel()) {
                AJGenAccessors.GenerateAccessor(this.doc, it.ie, this.settersChk.isSelected(), this.remFirstChk.isSelected(), this.gettersChk.isSelected());
            }
            ++i;
        }
        this.doc.setSelection(x, y, this.doc.cX(), this.doc.cY());
        this.doc.repaint();
    }

    public static void GenerateAccessor(TextDocument doc, IndexEntry ie, boolean setters, boolean remFirst, boolean getters) {
        String sp1 = doc.constructSpace(JXEOptions.INDENT).toString();
        String sp2 = doc.constructSpace(JXEOptions.INDENT * 2).toString();
        StringBuffer funH = new StringBuffer(40);
        FieldDescription decl = (FieldDescription)ie.decl();
        String varName = decl.getName();
        if (remFirst && varName.length() > 1) {
            varName = varName.substring(1);
        }
        if (setters) {
            funH.append(sp1 + "public void").append(" set").append(varName.toUpperCase().charAt(0)).append(varName.substring(1)).append("( ").append(decl.getTypeClass() + " " + varName + " )");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(funH.toString());
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp1 + "{");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp2 + "this." + decl.getName() + " = " + varName + ";");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp1 + "}");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
        }
        if (getters) {
            doc.insertAndMove(sp1 + "public " + decl.getTypeClass() + " get" + varName.toUpperCase().charAt(0) + varName.substring(1) + "()");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp1 + "{");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp2 + "return " + decl.getName() + ";");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
            doc.insertAndMove(sp1 + "}");
            doc.lineBreak();
            doc.moveCursorAbs(0, doc.cY());
        }
    }

    static class MyBoolItem
    extends BooleanItem {
        IndexEntry ie;

        public MyBoolItem(IndexEntry ie, Object text) {
            super(text);
            this.ie = ie;
        }
    }
}

