/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.AJPathEditorGUI;
import de.netcomputing.anyj.jwidgets.DirNode;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import java.awt.Image;
import java.io.File;
import java.util.Vector;

public class AJPathEditor
extends AJDirSelector {
    NCButton upBtn;
    NCButton doBtn;
    NCButton remBtn;
    NCButton addBtn;
    NCTreeBean pathPanel;

    public AJPathEditor() {
        this.initGui();
    }

    public void initGui() {
        new AJPathEditorGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init() {
        super.init();
        this.label.setText("Edit the given Path");
        this.pathPanel.addTarget(this, "actionPathSelChanged");
        this.pathPanel.setDrawLines(false);
        this.addBtn.addTarget(this, "actionAdd");
        this.remBtn.addTarget(this, "actionRem");
        this.upBtn.addTarget(this, "actionUp");
        this.doBtn.addTarget(this, "actionDo");
        this.actionPathSelChanged(null, null);
        this.actionSelChange(null, null);
    }

    public Object actionListDClick(Object a, Object s) {
        this.actionAdd(null, null);
        return null;
    }

    public Object actionPathSelChanged(Object a, Object s) {
        IListItem o = this.pathPanel.getSelectedItem();
        this.upBtn.setEnabled(o != null && this.pathPanel.getSelectionIndex() > 0);
        this.doBtn.setEnabled(o != null && this.pathPanel.getSelectionIndex() < this.pathPanel.listSize() - 1);
        this.remBtn.setEnabled(o != null);
        if (o != null) {
            this.setInitialDir(EditApp.App.getTemplateEngine().insertEnvVars(((ListItem)o).getDisplayString(), null));
            this.listPanel.repaint();
        }
        return null;
    }

    public Object actionAdd(Object a, Object s) {
        if (this.lastSelection != null) {
            this.pathPanel.addItemRepainting(new ListItem(this.lastSelection.getAbsolutePath()));
            this.selectBtn.setEnabled(true);
        }
        return null;
    }

    public void setPath(String s) {
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, s);
        this.pathPanel.clear();
        int n = 0;
        while (n < v.size()) {
            this.pathPanel.addItem(new ListItem(v.elementAt(n).toString()));
            ++n;
        }
    }

    public boolean isValidSelection(File dir) {
        return true;
    }

    public String getPath() {
        Vector v = this.pathPanel.getList();
        StringBuffer res = new StringBuffer(200);
        int n = 0;
        while (n < v.size()) {
            res.append(((ListItem)v.elementAt(n)).getDisplayString());
            res.append(File.pathSeparator);
            ++n;
        }
        return res.toString();
    }

    public Object actionRem(Object a, Object s) {
        int i = this.pathPanel.getSelectionIndex();
        if (i >= 0) {
            this.pathPanel.remWithSelectionAt(i);
            this.selectBtn.setEnabled(true);
        }
        return null;
    }

    public Object actionUp(Object a, Object s) {
        this.pathPanel.moveSelUp();
        this.selectBtn.setEnabled(true);
        return null;
    }

    public Object actionDo(Object a, Object s) {
        this.pathPanel.moveSelDown();
        this.selectBtn.setEnabled(true);
        return null;
    }

    public Object actionSelChange(Object a, Object s) {
        IListItem o = this.listPanel.getSelectedItem();
        this.lastSelection = o != null ? ((DirNode)o).file : null;
        this.addBtn.setEnabled(o != null && this.isValidSelection(((DirNode)o).file));
        return null;
    }
}

