/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJPathEditor;
import de.netcomputing.anyj.AJProjectFromWombatGUI;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.anyj.wombatanalyzer.WombatAnalyzer;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class AJProjectFromWombat
extends JPanel {
    JButton magicBtn;
    JProgressBar progress;
    AJPathEditor pathBean;
    NCButton remBtn;
    NCButton remxBtn;
    NCButton remyBtn;
    NCTreeBean conflictPackList;
    NCTreeBean conflictList;
    NCTreeBean classRootList;
    NCTreeBean sourceRootList;
    WombatAnalyzer wa = new WombatAnalyzer();
    String lastSelectedRoot = "";

    public AJProjectFromWombat() {
        this.initGui();
    }

    public void initGui() {
        new AJProjectFromWombatGUI().createGui(this);
        this.pathBean.init();
        this.sourceRootList.binder().addTarget(this, "actionSourceListSel");
        this.classRootList.binder().addTarget(this, "actionClassListSel");
        this.conflictList.binder().addTarget(this, "actionConflictListSel");
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void doMagic(final Vector dirs) {
        new Thread(){

            public void run() {
                AJProjectFromWombat.this.magicBtn.setEnabled(false);
                AJProjectFromWombat.this.wa.doMagic(dirs, AJProjectFromWombat.this.progress);
                AJProjectFromWombat.this.magicBtn.setEnabled(true);
                AJProjectFromWombat.this.sourceRootList.clear();
                AJProjectFromWombat.this.classRootList.clear();
                AJProjectFromWombat.this.fillValues();
            }
        }.start();
    }

    void fillValues() {
        Iterator it = this.wa.computeSourceRoots().iterator();
        while (it.hasNext()) {
            this.sourceRootList.addLine(it.next());
        }
        this.sourceRootList.repaint();
        it = this.wa.computeClassRoots().iterator();
        while (it.hasNext()) {
            this.classRootList.addLine(it.next());
        }
        this.classRootList.sortByString();
    }

    void fillConflicts(String entry) {
        this.conflictPackList.clear();
        this.conflictList.clear();
        Iterator it = this.wa.getConflictRoots(entry).iterator();
        while (it.hasNext()) {
            this.conflictList.addLine(it.next());
        }
        this.conflictList.sortByString();
    }

    void fillPackConflicts(String rootentry, String conflEntry) {
        this.conflictPackList.clear();
        Iterator it = this.wa.getConflictPackages(rootentry, conflEntry).iterator();
        while (it.hasNext()) {
            this.conflictPackList.addLine(it.next());
        }
        this.conflictPackList.sortByString();
    }

    public void magicBtn_actionPerformed(ActionEvent var0) {
        Vector path = NCStringUtilities.SplitSeparatedString(File.pathSeparator, this.pathBean.getPath());
        this.doMagic(path);
    }

    public Object actionConflictListSel(Object arg, Object sen) {
        this.fillPackConflicts(this.lastSelectedRoot, this.conflictList.getSelectedString());
        return null;
    }

    public Object actionSourceListSel(Object arg, Object sen) {
        this.lastSelectedRoot = this.sourceRootList.getSelectedString();
        this.fillConflicts(this.lastSelectedRoot);
        return null;
    }

    public Object actionClassListSel(Object arg, Object sen) {
        this.lastSelectedRoot = this.classRootList.getSelectedString();
        this.fillConflicts(this.lastSelectedRoot);
        return null;
    }

    public static void main(String[] args) {
        AJProjectFromWombat pw = new AJProjectFromWombat();
        JFrame f = ApplicationHelper.Singleton().createFrameOn(pw);
        f.setBounds(0, 0, 800, 1000);
        f.show();
    }
}

