/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJSourceIndexerGUI;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.INCStatus;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.SourceBase;
import java.awt.Cursor;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import netcomputing.tools.PropWriter;

public class AJSourceIndexer
extends NCPanel
implements INCStatus {
    public static AJSourceIndexer This;
    JLabel statusLabel;
    NCButton stopBtn;
    NCTreeBean errorList;
    JTextField privateFld;
    NCButton defPrivateBtn;
    NCButton defExcludeBtn;
    JTextField excludeFld;
    JProgressBar percentBar;
    NCButton buildBtn;
    NCButton clearBtn;
    NCTreeBean listPanel;

    public AJSourceIndexer() {
        this.initGui();
        This = this;
    }

    public void initGui() {
        new AJSourceIndexerGUI().createGui(this);
        this.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init() {
        this.percentBar.setValue(0);
        this.buildBtn.addTarget(this, "actionBuild");
        this.clearBtn.addTarget(this, "actionClear");
        this.stopBtn.addTarget(this, "actionStop");
        this.defPrivateBtn.addTarget(this, "actionDefPrivate");
        this.defExcludeBtn.addTarget(this, "actionDefExclude");
        this.listPanel.clear();
        this.listPanel.noHorz();
        EditApp.App.binderApplication().addTarget(this, "actionApplication");
        this.setBackground(JWColor.For("background"));
        this.actionDefPrivate(null, null);
        this.actionDefExclude(null, null);
        this.setState(2);
    }

    public void setToDo(int value) {
        this.percentBar.setMaximum(value);
        EditFrame.Host().setProgressMaximum(value);
    }

    public void setText(String text) {
        this.statusLabel.setText(text);
    }

    public void setDone(int value) {
        try {
            String s = "100 %";
            if (this.percentBar.getMaximum() != 0) {
                s = Math.min(100 * value / this.percentBar.getMaximum(), 100) + " %";
            }
            this.percentBar.setString(s);
            this.percentBar.setValue(value);
            EditFrame.Host().setProgressString(s);
            EditFrame.Host().setProgressValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object actionDefPrivate(Object arg, Object sen) {
        this.privateFld.setText("sun.;sunw.;java.;ms.;javax.");
        return null;
    }

    public Object actionDefExclude(Object arg, Object sen) {
        this.excludeFld.setText("java.text.resources;javax.swing.plaf");
        return null;
    }

    public void setDefault() {
        this.actionDefExclude(null, null);
        this.actionDefPrivate(null, null);
    }

    public NCTreeBean getErrorList() {
        return this.errorList;
    }

    public NCTreeBean getFileList() {
        return this.listPanel;
    }

    public Object actionSetup(Object arg, Object sen) {
        EditApp.App.openOptions("Workspace.Directories");
        return null;
    }

    public void setState(int newState) {
        switch (newState) {
            case 0: {
                this.stopBtn.setEnabled(true);
                this.buildBtn.setEnabled(false);
                this.clearBtn.setEnabled(false);
                break;
            }
            case 1: {
                this.stopBtn.setEnabled(false);
                this.buildBtn.setEnabled(false);
                this.clearBtn.setEnabled(false);
            }
            case 2: {
                this.stopBtn.setEnabled(false);
                this.buildBtn.setEnabled(true);
                this.clearBtn.setEnabled(true);
            }
        }
    }

    public JTextField getPrivateFld() {
        return this.privateFld;
    }

    public JTextField getExcludeFld() {
        return this.excludeFld;
    }

    public Object actionApplication(Object arg, Object sen) {
        if (arg instanceof IValue && ((IValue)arg).value() instanceof String) {
            if (arg instanceof IValue && ((IValue)arg).stringValue().equals("rebuildIndex")) {
                Tracer.This.println("rebuildIndex1");
                this.setState(2);
            }
            if (((IValue)arg).stringValue().equals("propertiesRead") || ((IValue)arg).stringValue().equals("ScanSourceChanged")) {
                Vector v = EditApp.App.getScanableDirs();
                Vector<ListItem> newV = new Vector<ListItem>(v.size());
                int n = 0;
                while (n < v.size()) {
                    newV.addElement(new ListItem(new File(v.elementAt(n).toString())));
                    ++n;
                }
                this.listPanel.setList(newV, 0.0, -1);
                this.listPanel.repaint();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object actionClear(Object arg, Object sender) {
        this.setState(1);
        try {
            EditApp.Resetting = true;
            this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            SourceBase.This().reset();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getFrame().setCursor(Cursor.getDefaultCursor());
            EditApp.Resetting = false;
            this.setState(2);
            throw throwable;
        }
        this.getFrame().setCursor(Cursor.getDefaultCursor());
        EditApp.Resetting = false;
        this.setState(2);
        return null;
    }

    public synchronized void buildSynchronous() {
        this.buildSynchronous(true);
    }

    public synchronized void buildSynchronous(boolean check) {
        this.setState(0);
        SourceBase.This().buildSynchronous(this.listPanel.getList(), this.errorList, this, true, false, check);
    }

    public synchronized void buildSynchronous(Vector files, INCStatus stat) {
        this.buildSynchronous(files, stat, true);
    }

    public synchronized void buildSynchronous(Vector files, INCStatus stat, boolean check) {
        this.setState(0);
        SourceBase.This().buildSynchronous(files, this.errorList, stat, true, false, check);
    }

    public synchronized void build(Vector files) {
        this.setState(0);
        SourceBase.This().build(files, this.errorList, this, true, false);
    }

    public synchronized Object actionBuild(Object arg, Object sender) {
        this.setState(0);
        SourceBase.This().build(this.listPanel.getList(), this.errorList, this, true, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object actionStop(Object arg, Object sender) {
        try {
            this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            SourceBase.This().waitForBuilderStop();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getFrame().setCursor(Cursor.getDefaultCursor());
            this.setState(2);
            throw throwable;
        }
        this.getFrame().setCursor(Cursor.getDefaultCursor());
        this.setState(2);
        return null;
    }

    public void storeProperty(PropWriter pw) throws Exception {
        DataOutputStream o = pw.createStream(this);
        super.storeProperty(pw.copy("indexeroptions"));
        o.writeBoolean(false);
        o.writeUTF(this.excludeFld.getText());
        o.writeUTF(this.privateFld.getText());
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            DataInputStream o = pw.getStream(this);
            super.loadProperty(pw.copy("indexeroptions"));
            String s1 = "";
            String s2 = "";
            o.readBoolean();
            s1 = o.readUTF();
            s2 = o.readUTF();
            this.excludeFld.setText(s1);
            this.privateFld.setText(s2);
        }
        catch (Exception ex) {
            this.actionDefExclude(null, null);
            this.actionDefPrivate(null, null);
        }
    }
}

