/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JWVFile.VFile;
import de.netcomputing.anyj.AJExternalTools;
import de.netcomputing.anyj.AJVControlGUI;
import de.netcomputing.anyj.gui.AJEnvFileTextField;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jxeplugins.IVControl;
import netcomputing.tools.PropWriter;
import versioncontrol.AccessControl;

public class AJVControl
extends NCPanel
implements IVControl {
    AccessControl control = new AccessControl("");
    NCButton cvsBtn;
    NCButton ssBtn;
    NCTextField vcontrolTypes;
    NCButton cancelBtn;
    NCButton applyBtn;
    AJEnvFileTextField userRootDirFld;
    AJEnvFileTextField lockDirFld;
    NCButton userBtn;
    NCTextField userNameFld;
    NCCheckBox useChkBox;
    String[] propBuffer = new String[]{"", "", ""};
    boolean enableBuffer;
    Object[] cancelBuffer = new Object[]{"", "", "", null, null};

    public void initGui() {
        new AJVControlGUI().createGui(this);
        this.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init() {
        try {
            this.userBtn.addTarget(this, "actionUserBtn");
            this.useChkBox.addTarget(this, "actionEnableCheck");
            EditApp.App.binderApplication().addTarget(this, "actionApplication");
            this.lockDirFld.setText(this.propBuffer[0]);
            this.userRootDirFld.setText(this.propBuffer[1]);
            this.userNameFld.setText(this.propBuffer[2]);
            this.useChkBox.setPressed(this.enableBuffer);
            this.vcontrolTypes.setText((String)EditApp.App.getWorkspaceProperty("StringList.VersionControlTypes"));
            this.enableApplyButtons(false);
            ChangeListener enableButtons = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AJVControl.this.enableApplyButtons(true);
                }
            };
            DocumentListener enableButtons1 = new DocumentListener(){

                public void removeUpdate(DocumentEvent e) {
                    AJVControl.this.enableApplyButtons(true);
                }

                public void insertUpdate(DocumentEvent e) {
                    AJVControl.this.enableApplyButtons(true);
                }

                public void changedUpdate(DocumentEvent e) {
                    AJVControl.this.enableApplyButtons(true);
                }
            };
            this.lockDirFld.addDocumentListener(enableButtons1);
            this.vcontrolTypes.getDocument().addDocumentListener(enableButtons1);
            this.userRootDirFld.addDocumentListener(enableButtons1);
            this.userNameFld.getDocument().addDocumentListener(enableButtons1);
            this.useChkBox.addChangeListener(enableButtons);
            this.readCancelBuffer();
            this.applyDialogDataToControl();
            this.applyBtn.setMnemonic('O');
            this.cancelBtn.setMnemonic('C');
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void readCancelBuffer() {
        this.cancelBuffer[0] = this.lockDirFld.getText();
        this.cancelBuffer[1] = this.userRootDirFld.getText();
        this.cancelBuffer[2] = this.userNameFld.getText();
        this.cancelBuffer[3] = new Boolean(this.useChkBox.isSelected());
        this.cancelBuffer[4] = this.vcontrolTypes.getText();
    }

    void writeCancelBuffer() {
        this.lockDirFld.setText((String)this.cancelBuffer[0]);
        this.userRootDirFld.setText((String)this.cancelBuffer[1]);
        this.userNameFld.setText((String)this.cancelBuffer[2]);
        this.useChkBox.setSelected((Boolean)this.cancelBuffer[3]);
        this.vcontrolTypes.setText((String)this.cancelBuffer[4]);
    }

    void enableApplyButtons(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
    }

    void applyDialogDataToControl() {
        try {
            Window f;
            File fi;
            this.control.setLockDirectory(EditApp.App.getTemplateEngine().insertEnvVars(this.getLockDir(), null));
            this.control.setUserPath(EditApp.App.getTemplateEngine().insertEnvVars(this.getUserRoot(), null));
            if (!(!this.isAccessControlEnabled() || (fi = new File(this.control.getLockDirectory())).exists() && fi.canWrite() && fi.canRead() || (f = (Window)this.getFrame()) == null)) {
                Confirm.ModalMsg(f, "Access Control Error", new String[]{"The specified LockDirectory does not exist", "or is not accessible.", "", "AccessControl disabled."});
                this.useChkBox.setPressed(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isAccessControlEnabled() {
        try {
            if (this.propBuffer[0].length() == 0) {
                Tracer.This.println("------------------------- possible accessing unloaded properties ----------------");
            }
            if (this.useChkBox == null) {
                return this.enableBuffer;
            }
            return this.useChkBox.isPressed();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Object actionEnableCheck(Object arg, Object sen) {
        return null;
    }

    public Object actionApplication(Object arg, Object sen) {
        return null;
    }

    public void setUserName(String userName) {
        this.userNameFld.setText(userName);
    }

    public String getUserName() {
        if (this.userNameFld == null) {
            return this.propBuffer[2];
        }
        return this.userNameFld.getText();
    }

    public void setUserRoot(String userRoot) {
        this.userRootDirFld.setText(userRoot);
    }

    public String getUserRoot() {
        if (this.userRootDirFld == null) {
            return this.propBuffer[1];
        }
        return this.userRootDirFld.getText();
    }

    public void setLockDir(String lockDir) {
        this.lockDirFld.setText(lockDir);
    }

    public String getLockDir() {
        if (this.lockDirFld == null) {
            return this.propBuffer[0];
        }
        return this.lockDirFld.getText();
    }

    public Object actionUserBtn(Object arg, Object sen) {
        this.userNameFld.setText("" + System.getProperty("user.name"));
        return null;
    }

    public String setLock(File f) {
        if (!this.isAccessControlEnabled()) {
            return null;
        }
        String s = null;
        try {
            s = this.control.setLock(VFile.GetOSCapitalization(f.getAbsolutePath()), this.getUserName());
            if (!s.equals(this.getUserName())) {
                return "File is currently locked by " + s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public String releaseLock(File f) {
        if (!this.isAccessControlEnabled()) {
            return null;
        }
        String s = null;
        try {
            s = this.control.clearLock(VFile.GetOSCapitalization(f.getAbsolutePath()), this.getUserName());
            if (s != null) {
                return "File is locked by " + s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public String getOwnerOf(File f) {
        if (!this.isAccessControlEnabled()) {
            return this.getUserName();
        }
        try {
            return this.control.getOwner(VFile.GetOSCapitalization(f.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void saveProps(DataOutputStream o) throws Exception {
        o.writeUTF(this.lockDirFld.getText());
        o.writeUTF(this.userRootDirFld.getText());
        o.writeUTF(this.userNameFld.getText());
        o.writeBoolean(this.useChkBox.isPressed());
    }

    public void loadProps(DataInputStream o) throws Exception {
        int n = 0;
        while (n < this.propBuffer.length) {
            this.propBuffer[n] = o.readUTF();
            ++n;
        }
        this.enableBuffer = o.readBoolean();
    }

    public void storeProperty(PropWriter o) throws Exception {
    }

    public void loadProperty(PropWriter o) throws Exception {
    }

    public void ssBtn_actionPerformed(ActionEvent var0) {
        AJExternalTools.This.addTool("CHECKOUT", "($currentDir)", "ss checkout -I- ($currentFile)", true);
        AJExternalTools.This.addTool("CHECKIN", "($currentDir)", "ss checkin -I- ($currentFile)", true);
        Confirm.ModalMsg((Window)this.getFrame(), "Source Safe Tools added", new String[]{"External Tools for SourceSafe support", "have been added.", "Use the Popup Menu to access them or", "type into a 'Read Only' document.", "Important: set the 'directory based' option", "in SourceSafe and add the path to SourceSafe (\"ss.exe\") to your", "environment."});
        EditApp.App.openBrowserOn(VFile.ResolveName("#doc/ssintegr.html"));
    }

    public void cvsBtn_actionPerformed(ActionEvent var0) {
        AJExternalTools.This.addTool("CVS COMMIT", "($currentDir)", "cvs commit -m \"($ask:Please enter a comment)\" ($currentFile)", true);
        AJExternalTools.This.addTool("CVS UPDATE", "($currentDir)", "cvs update -d ($currentFile)", true);
        AJExternalTools.This.addTool("CVS ADD", "($currentDir)", "cvs add ($currentFile)", true);
        AJExternalTools.This.addTool("CVS DIFF", "($currentDir)", "cvs diff ($currentFile)", true);
        AJExternalTools.This.addTool("CVS HISTORY", "($currentDir)", "cvs history ($currentFile)", true);
        AJExternalTools.This.addTool("CVS STATUS", "($currentDir)", "cvs status ($currentFile)", true);
        Confirm.ModalMsg((Window)this.getFrame(), "CVS Tools added", new String[]{"External Tools for CVS support", "have been added.", "Use the Popup Menu to access them.", "Note that you have to setup CVSROOT and", "import/checkout your source manually."});
        EditApp.App.openBrowserOn("#doc/cvsintegr.html");
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.writeCancelBuffer();
        this.enableApplyButtons(false);
        this.applyDialogDataToControl();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.readCancelBuffer();
        this.applyDialogDataToControl();
        EditApp.App.setWorkspaceProperty("StringList.VersionControlTypes", this.vcontrolTypes.getText());
        this.enableApplyButtons(false);
        EditApp.App.propertyChanged();
    }
}

