/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.application;

import JCollections.DirIterator;
import JWVFile.VFile;
import de.netcomputing.anyj.AJChooseMulti;
import de.netcomputing.anyj.application.AJScriptClassLoader;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.scripting.AJExternalService;
import de.netcomputing.anyj.scripting.AJSOutput;
import de.netcomputing.anyj.scripting.AnyJAPI;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XmlReader;
import de.netcomputing.util.xml.XmlWriter;
import editapp.EditApp;
import editapp.ServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import netcomputing.beans.NCClassloader;
import netcomputing.tools.Executor;
import netcomputing.tools.INCExtendedPrintout;

public class AJScriptRegistry {
    static AJScriptRegistry This;
    NCClassloader loader;

    public static AJScriptRegistry This() {
        if (This == null) {
            This = new AJScriptRegistry();
        }
        return This;
    }

    public static void InitServices() {
        JEBasicService ser = null;
        ser = new JEBasicService("Scripting Support", "Compile Scripts", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                JWidgetsUtil.AddLongRunningJob(new Runnable(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        AJScriptRegistry.This().compileScripts();
                    }
                });
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Scripting Support", "Enable/Disable Scripts", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJScriptRegistry.This().showScriptOptions();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Scripting Support", "Dump Environment", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJSOutput out = AnyJAPI.This().getOrCreateOutputPanel("Scripting");
                out.printLine("==================== ENVIRONMENT =========================");
                Hashtable env = AnyJAPI.This().getEnvironment();
                Enumeration en = env.keys();
                while (en.hasMoreElements()) {
                    Object key = en.nextElement();
                    out.printLine(key + " => '" + env.get(key) + "'");
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Scripting Support", "Show Selected Objects [internal]", 1){
            ArrayList selectedClasses = new ArrayList();
            long lastAccess = 0L;

            public boolean canProcess(Object selection, Object selector) {
                if (System.currentTimeMillis() - this.lastAccess > 500L) {
                    this.selectedClasses.clear();
                }
                this.lastAccess = System.currentTimeMillis();
                this.selectedClasses.add(selection);
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJSOutput out = AnyJAPI.This().getOrCreateOutputPanel("Scripting");
                out.printLine("==================== SELECTED OBJECTS =========================");
                Iterator it = this.selectedClasses.iterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    out.printLine(next.getClass().getName());
                    out.printLine(" = " + next);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        AnyJAPI.This().registerMenuHandler(new SHOWSEL());
        ser = new JEBasicService("Scripting Support", "Reload Scripts", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJScriptRegistry.This().initScripts();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Scripting Support", "New Scripting Package", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJScriptRegistry.This().newScriptPackage();
            }
        };
        EditApp.ServReg.addService(ser);
    }

    public void initScripts() {
        EditApp.App.ResetMenus();
        AJScriptClassLoader.Reset();
        ((ServiceRegistry)EditApp.App.getServReg()).removeScriptingServices();
        List l = this.findDescriptions();
        int n = 0;
        while (n < l.size()) {
            try {
                this.processDescription((File)l.get(n));
            }
            catch (Throwable ex) {
                INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("Script Init");
                out.printLine("Exception during Script init:");
                out.printLine("       File:" + ((File)l.get(n)).getAbsolutePath());
                out.printLine("  Exception:" + ex.getClass().getName());
                out.printLine("        Msg:" + ex.getMessage());
                ex.printStackTrace(Tracer.This);
            }
            ++n;
        }
        AnyJAPI.This().updateMenus();
    }

    public void showScriptOptions() {
        List l = this.findDescriptions();
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<String> enabledItems = new ArrayList<String>();
        int n = 0;
        while (n < l.size()) {
            File f = (File)l.get(n);
            try {
                FileInputStream in = new FileInputStream(f);
                Node node = (Node)new XmlReader().read(in);
                in.close();
                nodes.add(node);
                boolean b = node.getBooleanField("enabled", true);
                String parName = f.getParentFile().getName();
                items.add(parName);
                if (b) {
                    enabledItems.add(parName);
                }
            }
            catch (Exception ex) {
                Confirm.MsgException(ex);
                Confirm.ModalMsg("Error " + f.getAbsolutePath(), "Please verify the correctness of the scripts 'description.xml' file");
                return;
            }
            ++n;
        }
        List selected = AJChooseMulti.ChooseFromList(EditApp.App.getMainWindow(), "Script Options", "Select active Script Extensions", items, enabledItems, 640, 400);
        if (selected == null) {
            return;
        }
        int n2 = 0;
        while (n2 < items.size()) {
            try {
                String s = (String)items.get(n2);
                File descFile = (File)l.get(n2);
                FileOutputStream out = new FileOutputStream(descFile);
                Node descNode = (Node)nodes.get(n2);
                descNode.putField("enabled", "" + selected.contains(s));
                new XmlWriter().write(out, descNode);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        this.initScripts();
    }

    List findDescriptions() {
        VFile scriptDir = new VFile("#userdata/scripts/");
        File[] cont = scriptDir.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        int n = 0;
        while (cont != null && n < cont.length) {
            File f;
            if (cont[n].isDirectory() && (f = new File(cont[n], "description.xml")).exists()) {
                result.add(f);
            }
            ++n;
        }
        return result;
    }

    void processDescription(File f) throws Exception {
        Node node = (Node)new XmlReader().read(new FileInputStream(f));
        boolean b = node.getBooleanField("enabled", true);
        if (!b) {
            return;
        }
        int i = 0;
        while (i < node.getSubnodeCount()) {
            Node sub = (Node)node.getSubnode(i);
            try {
                if (sub.getName().equals("Script")) {
                    this.parseScriptNode(sub);
                } else if (sub.getName().equals("AddMenu")) {
                    this.parseMenuConf(sub);
                }
            }
            catch (Throwable ex) {
                INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("Script Init");
                out.printLine("Exception during Script init:");
                out.printLine("       File:" + f.getAbsolutePath());
                out.printLine("  Exception:" + ex.getClass().getName());
                out.printLine("        Msg:" + ex.getMessage());
                ex.printStackTrace(Tracer.This);
            }
            ++i;
        }
    }

    void parseMenuConf(Node node) throws Exception {
        String[] menuConf = new String[]{node.getField("Name.content", "Tools"), node.getField("Category.content", "=>Unknown")};
        AnyJAPI.This().addMenuStructure(menuConf);
    }

    void parseScriptNode(Node node) throws Exception {
        boolean b = node.getBooleanField("enabled", true);
        if (!b) {
            return;
        }
        String clz = node.getField("Class.content");
        if (clz != null) {
            String nam;
            Class script = AJScriptClassLoader.This().findOrLoad(clz);
            AJExternalService serv = (AJExternalService)script.newInstance();
            String cat = node.getField("Category.content");
            if (cat != null) {
                serv.setCategory(cat);
            }
            if ((nam = node.getField("Name.content")) != null) {
                serv.setMenuName(nam);
            }
            AnyJAPI.This().registerMenuHandler(serv);
            String servName = node.getField("Category.content", "") + " " + node.getField("Name.content", "");
            JEBasicService service = (JEBasicService)EditApp.ServReg.getServiceNamed(servName);
            if (service != null) {
                service.setShowInList(node.getField("VisibleInLists.content", "").equals("true"));
                service.setShowInEditor(node.getField("VisibleInEditor.content", "").equals("true"));
            }
        }
    }

    public void newScriptPackage() {
        EditApp.App.newFromTemplate(new VFile("#userdata/scripts/"), "ScriptPackage");
    }

    public void compileScripts() {
        String cline = EditApp.App.getGlobalProperty("Directory.jdkHome") + File.separator + "bin" + File.separator + "javac ";
        cline = cline + "-classpath " + AnyJAPI.This().getEnvironment().get("anyjbin") + File.separator + "anyj.jar" + File.pathSeparator;
        cline = cline + AJScriptClassLoader.computeScriptingClassPathAsString();
        Vector sourcePath = new Vector();
        AJScriptClassLoader.computeScriptingSourcePath(sourcePath);
        cline = cline + " -sourcepath ";
        int i = 0;
        while (i < sourcePath.size()) {
            cline = cline + sourcePath.get(i) + File.pathSeparator;
            ++i;
        }
        String files = "";
        Vector javas = DirIterator.DirContent(new VFile("#userdata/scripts/"), "java", true);
        int i2 = 0;
        while (i2 < javas.size()) {
            files = files + ((File)javas.get(i2)).getAbsolutePath() + " ";
            ++i2;
        }
        try {
            File f = EditApp.App.getTmpFile();
            FileOutputStream out = new FileOutputStream(f);
            out.write(files.getBytes());
            out.close();
            cline = cline + " @" + f.getAbsolutePath();
            JEBatchHostFrame.This().createOutput("Compile Scripts").clear();
            JEBatchHostFrame.This().createOutput("Compile Scripts").printLine(cline);
            Process p = Executor.Exec(cline, VFile.ResolveName("#userdata/scripts/"), JEBatchHostFrame.This().createOutput("Compile Scripts"), false);
            try {
                p.waitFor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JEBatchHostFrame.This().createOutput("Compile Scripts").printLine("-FINISHED-");
    }

    public static class SHOWSEL
    extends AJExternalService {
        ArrayList selectedClasses = new ArrayList();
        long lastAccess = 0L;

        public SHOWSEL() {
            super("Show Selected Objects");
            this.category = "Scripting Support";
        }

        public boolean canProcessSelection(Object selection) {
            if (System.currentTimeMillis() - this.lastAccess > 500L) {
                this.selectedClasses.clear();
            }
            this.lastAccess = System.currentTimeMillis();
            this.selectedClasses.add(selection);
            return true;
        }

        public void doProcess(Object selection) {
            AJSOutput out = AnyJAPI.This().getOrCreateOutputPanel("Scripting");
            out.printLine("==================== SELECTED OBJECTS =========================");
            Iterator it = this.selectedClasses.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                out.printLine(next.getClass().getName());
                out.printLine(" = " + next);
            }
        }
    }
}

