/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.application;

import JWVFile.VFile;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.AbstractBooleanListItem;
import de.netcomputing.anyj.jwidgets.HiLightingListItem;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;

public class SearchResultItem
extends AbstractBooleanListItem {
    String file;
    String displayLine;
    int lineStart;
    int lineEnd;
    int colStart;
    int colEnd;
    boolean isError;
    String errorMsg = null;
    String toSearch;
    String resType;
    long timeStamp = System.currentTimeMillis();
    IListItem[] cont;

    public SearchResultItem(String file2, int lx, int ly, int elx, int ely, String displayLine, String srch) {
        this.file = file2;
        this.lineStart = ly;
        this.lineEnd = ely;
        this.colStart = lx;
        this.colEnd = elx;
        this.toSearch = srch;
        this.displayLine = displayLine;
    }

    public SearchResultItem(Object[] jgrepRow, int searchLen, String srch) {
        if ("regex".equals("" + jgrepRow[3])) {
            this.file = (String)jgrepRow[2];
            this.colStart = (Integer)jgrepRow[4];
            this.lineStart = (Integer)jgrepRow[5] - 1;
            this.colEnd = (Integer)jgrepRow[7];
            this.lineEnd = (Integer)jgrepRow[6];
            if (jgrepRow[0].toString().equals("(!) Parse Error")) {
                this.errorMsg = "Parse Error, pls ensure file is syntactically correct";
                this.isError = true;
            }
            this.toSearch = srch;
        } else {
            this.file = (String)jgrepRow[2];
            this.colStart = (Integer)jgrepRow[4];
            this.lineEnd = this.lineStart = ((Integer)jgrepRow[5]).intValue();
            this.colEnd = this.colStart + searchLen;
            if (jgrepRow[0].toString().equals("(!) Parse Error")) {
                this.errorMsg = "Parse Error, pls ensure file is syntactically correct";
                this.isError = true;
            }
            this.toSearch = srch;
            if ("false".equals(jgrepRow[3])) {
                this.setIsSel(false);
            }
            if (jgrepRow[1].toString().length() > 0) {
                this.errorMsg = jgrepRow[1].toString();
                this.isError = true;
            }
            if (jgrepRow.length > 6) {
                this.resType = (String)jgrepRow[6];
            }
        }
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public String getResType() {
        return this.resType;
    }

    public void setIsError(boolean isError) {
        this.isError = isError;
    }

    public boolean getIsError() {
        return this.isError;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public int getDepth() {
        return 1;
    }

    protected void drawDisplayString(Graphics g, int stringX, int stringY) {
        if (!this.isError) {
            super.drawDisplayString(g, stringX, stringY);
        } else {
            String ds = this.getDisplayString();
            Color old = g.getColor();
            g.setColor(Color.red.darker());
            g.drawString(ds, stringX, stringY);
            g.setColor(old);
        }
    }

    public Image getImage() {
        if (this.getIsSel()) {
            return NCApplication.GetImage("check1.gif");
        }
        return NCApplication.GetImage("check0.gif");
    }

    protected boolean getLinkStyle() {
        return true;
    }

    public Image getOpenImage() {
        return this.getImage();
    }

    public boolean hasContent() {
        return true;
    }

    public IListItem[] contents() {
        if (this.cont == null) {
            this.cont = this.constructCont();
        }
        return this.cont;
    }

    IListItem[] constructCont() {
        if (this.displayLine == null) {
            TextDocument doc = new TextDocument(new File(this.file));
            this.displayLine = this.lineStart > 0 ? doc.lineAt(this.lineStart - 1).toString().trim() : doc.lineAt(this.lineStart).toString().trim();
        }
        return new IListItem[]{new HiLightingListItem((Object)this.displayLine, this.toSearch)};
    }

    public String getFile() {
        return this.file;
    }

    public String getDisplayString() {
        String appendix;
        String dir = VFile.ExtractDir(this.file);
        String fi = VFile.NameWithExtension(this.file);
        String string = this.resType == null ? "" : (appendix = this.resType.startsWith(" [") ? this.resType : " [ used on " + this.resType + " ]");
        if (!this.isError || this.errorMsg == null) {
            return fi + " [ " + dir + " ] " + " (" + this.lineStart + ")" + appendix;
        }
        return fi + " [ " + dir + " ] " + " (" + this.errorMsg + ")" + appendix;
    }

    public void setLineStart(int lineStart) {
        this.lineStart = lineStart;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public void setLineEnd(int lineEnd) {
        this.lineEnd = lineEnd;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public void setColStart(int colStart) {
        this.colStart = colStart;
    }

    public int getColStart() {
        return this.colStart;
    }

    public void setColEnd(int colEnd) {
        this.colEnd = colEnd;
    }

    public int getColEnd() {
        return this.colEnd;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }
}

