/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.CharValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import de.netcomputing.anyj.debugger.DebuggerItem;

public class ArrayFieldItem
extends DebuggerItem {
    int field;
    ArrayReference val;
    Value cachedValue;
    String cachedDisplay;

    public ArrayFieldItem(int f, ArrayReference v) {
        this.field = f;
        this.val = v;
    }

    protected Value getValue() {
        if (this.cachedValue == null) {
            try {
                this.cachedValue = this.val.getValue(this.field);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return this.cachedValue;
    }

    public String getDisplayString() {
        try {
            if (this.cachedDisplay == null) {
                this.cachedDisplay = this.createDisplayString();
            }
            return this.cachedDisplay;
        }
        catch (Throwable ex) {
            return "invalid";
        }
    }

    public String createDisplayString() {
        try {
            Value v = this.val.getValue(this.field);
            if (v instanceof PrimitiveValue && !(v instanceof CharValue)) {
                return "[" + this.field + "] = " + v + "   (=" + ((PrimitiveValue)v).charValue() + ")";
            }
            if (v instanceof PrimitiveValue && v instanceof CharValue) {
                return "[" + this.field + "] = " + v + "   (=" + ((PrimitiveValue)v).intValue() + ")";
            }
            return "[" + this.field + "] = " + v;
        }
        catch (Exception ex) {
            return "Exc:" + ex.getClass().getName() + " " + ex.getMessage();
        }
    }
}

