/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import de.netcomputing.util.Tracer;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DebuggerClassloader
extends ClassLoader {
    ZipFile tools;

    public DebuggerClassloader(String toolsFile) {
        try {
            this.tools = new ZipFile(toolsFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected synchronized Class loadClass(String name, boolean ressolve) throws ClassNotFoundException {
        System.out.println("DebuggerClassLoader LOADCLASS:" + name);
        Class c = null;
        if (!name.endsWith(".Bootstrap")) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if ((c = this.findLoadedClass(name)) == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            if (ressolve) {
                this.resolveClass(c);
            }
        }
        return c;
    }

    public URL getResource(String name) {
        return super.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        ZipEntry ze = this.tools.getEntry(name);
        if (ze != null) {
            try {
                return this.tools.getInputStream(ze);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return super.getResourceAsStream(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            System.out.println("FINDCLASS:" + name);
            String zname = name.replace('.', '/') + ".class";
            ZipEntry ze = this.tools.getEntry(zname);
            InputStream zis = this.tools.getInputStream(ze);
            if (zis == null) {
                throw new ClassNotFoundException(name + " in DEBUGCLASSLOADER");
            }
            byte[] buf = new byte[(int)ze.getSize()];
            int nn = 0;
            while (nn < buf.length) {
                buf[nn] = (byte)zis.read();
                ++nn;
            }
            zis.close();
            Class<?> res = this.defineClass(buf, 0, buf.length);
            Tracer.This.println("defined class:" + res);
            return res;
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(name + " in DEBUGCLASSLOADER1");
        }
    }
}

