/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import de.netcomputing.anyj.debugger.ArrayFieldItem;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.debugger.FieldItem;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import java.awt.Image;
import java.util.List;

public abstract class DebuggerItem
extends BasicListItem {
    static Image dbgObj;
    static Image dbgObjClose;
    static Image noContObj;
    Image open = null;
    Image close = null;
    int d = 1;

    public int getDepth() {
        return this.d;
    }

    public void setDepth(int d) {
        this.d = d;
    }

    public boolean hasContent() {
        try {
            Value v = this.getValue();
            return !(v instanceof PrimitiveValue) && !(v instanceof StringReference) && v != null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected abstract Value getValue();

    static boolean shouldAdd(Field f) {
        if (DebuggerMainPanel.This().showStatics()) {
            return true;
        }
        return !f.isStatic();
    }

    public Image getOpenImage() {
        if (this.open == null) {
            if (dbgObjClose == null) {
                dbgObjClose = NCApplication.GetImage("/images/dbgobjectc.gif");
            }
            this.open = dbgObjClose;
        }
        return this.open;
    }

    public Image getImage() {
        if (this.close == null) {
            if (this.hasContent()) {
                if (dbgObj == null) {
                    dbgObj = NCApplication.GetImage("/images/dbgobject.gif");
                }
                this.close = dbgObj;
            } else {
                if (noContObj == null) {
                    noContObj = NCApplication.GetImage("/images/dbgintegral.gif");
                }
                this.close = noContObj;
            }
        }
        return this.close;
    }

    public static IListItem[] GetContent(ObjectReference v) {
        List fields = v.referenceType().allFields();
        IListItem[] contents = new IListItem[fields.size()];
        int count = 0;
        int n = 0;
        while (n < fields.size()) {
            if (DebuggerItem.shouldAdd((Field)fields.get(n))) {
                contents[count] = new FieldItem((Field)fields.get(n), v);
                ++count;
            }
            ++n;
        }
        IListItem[] cont = new IListItem[count];
        int n2 = 0;
        while (n2 < cont.length) {
            cont[n2] = contents[n2];
            ++n2;
        }
        return cont;
    }

    public String getVarName() {
        return "";
    }

    public IListItem[] contents() {
        try {
            Value v = this.getValue();
            if (v == null) {
                return new IListItem[0];
            }
            if (v instanceof ObjectReference) {
                if (v instanceof ArrayReference) {
                    List fields = ((ArrayReference)v).getValues();
                    IListItem[] contents = new IListItem[fields.size()];
                    int n = 0;
                    while (n < fields.size()) {
                        contents[n] = new ArrayFieldItem(n, (ArrayReference)v);
                        ++n;
                    }
                    return contents;
                }
                return DebuggerItem.GetContent((ObjectReference)v);
            }
            Tracer.This.println("UNKNOWN OBJREF:" + v.getClass().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IListItem[]{new ListItem(ex.getClass().getName())};
        }
        return new IListItem[0];
    }
}

