/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.gui;

import de.netcomputing.anyj.gui.AJEnvFileTextFieldGUI;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.templates.TemplateEngine;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.event.DocumentListener;

public class AJEnvFileTextField
extends NCPanel {
    PropertyFileSel txtField;
    JComboBox comboBox;
    long lastEvent;
    boolean ignoreNext = false;

    public AJEnvFileTextField() {
        this.initGui();
    }

    public void initGui() {
        new AJEnvFileTextFieldGUI().createGui(this);
    }

    public String getAcceptedExtensions() {
        return this.txtField.getAcceptedExtensions();
    }

    public void setLabel(String label) {
        this.txtField.setLabel(label);
    }

    public void setAcceptedExtensions(String acceptedExtensions) {
        this.txtField.setAcceptedExtensions(acceptedExtensions);
    }

    public String getLabel() {
        return this.txtField.getLabel();
    }

    public Object instantiationHook(Object obj) {
        if (obj instanceof PropertyFileSel) {
            return new PropertyFileSel(){

                public void setTextAfterChoosing(String s) {
                    String prev = this.getText().trim();
                    String val = EditApp.App.getTemplateEngine().insertEnvVars(prev, null);
                    if (s.startsWith(val)) {
                        s = prev + s.substring(val.length());
                    }
                    super.setTextAfterChoosing(s);
                }

                public String getTextBeforeChoosing() {
                    return EditApp.App.getTemplateEngine().insertEnvVars(this.getText(), null);
                }
            };
        }
        return obj;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setEnabled(boolean b) {
        this.fillCombo();
        this.txtField.setEnabled(b);
        this.comboBox.setEnabled(b);
    }

    public void addDocumentListener(DocumentListener tl) {
        this.txtField.addDocumentListener(tl);
    }

    public void fillCombo() {
        this.ignoreNext = true;
        if (this.comboBox.getItemCount() <= 0) {
            this.comboBox.removeAllItems();
            if (EditApp.App != null) {
                try {
                    this.comboBox.addItem("Select to insert ..");
                    Hashtable hash = EditApp.App.getTemplateEngine().buildEnvironment(TemplateEngine.CreateContext(new Object()));
                    Enumeration en = hash.keys();
                    while (en.hasMoreElements()) {
                        this.comboBox.addItem("($" + en.nextElement() + ")");
                    }
                    en = EditApp.App.getMergedUserProperties().keys();
                    while (en.hasMoreElements()) {
                        this.comboBox.addItem("($" + en.nextElement() + ")");
                    }
                    this.comboBox.addItem("($Swing)");
                    this.comboBox.addItem("($ServletSDK)");
                    this.comboBox.addItem("($Tools)");
                    this.comboBox.addItem("($SystemClasses)");
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
        }
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.setSelectedIndex(0);
        }
        this.ignoreNext = false;
    }

    public void setText(String text) {
        this.fillCombo();
        this.txtField.setText(text);
    }

    public String getText() {
        return this.txtField.getText();
    }

    public void comboBox_componentShown(ComponentEvent var0) {
        this.fillCombo();
    }

    public void txtField_componentShown(ComponentEvent var0) {
        this.fillCombo();
    }

    public void comboBox_itemStateChanged(ItemEvent var0) {
        if (this.ignoreNext) {
            return;
        }
        if (System.currentTimeMillis() - this.lastEvent > 500L) {
            this.txtField.replaceSelection(this.comboBox.getSelectedItem() + "");
        }
        this.lastEvent = System.currentTimeMillis();
        this.fillCombo();
    }
}

