/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.IDataItem;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListCanvas;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import netcomputing.tools.Platforms;

public abstract class BasicListItem
implements IListItem,
Serializable,
IDataItem {
    public static int InstanceCount = 0;
    public static Color selectionColor = JWColor.For("selection.bg");
    public static Color selectionTextColor = JWColor.For("selection.fg");
    public static Color selectionNoFocusTextColor = JWColor.For("selection.fg.nofocus");
    static Color linkColor = new Color(0, 0, 128);
    static final long serialVersionUID = 7163625831330845068L;

    public BasicListItem() {
        ++InstanceCount;
    }

    public IListItem[] contents() {
        return new IListItem[0];
    }

    public int getDepth() {
        return 0;
    }

    public void setDepth(int d) {
    }

    public int hotZoneX(Component comp) {
        return this.getImage() == null ? 0 : this.getImageWidth(comp) + 6;
    }

    public void paint(Graphics g, NCPanel sender, boolean selected, boolean isExpanded, int index) {
        Image im;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int height = this.heightIn(sender);
        int imHeight = this.getImageHeight(sender);
        int stringWidth = fm.stringWidth(this.getDisplayString());
        int stringHeight = fm.getHeight();
        int stringAscent = fm.getAscent();
        int xoff = 0;
        int imoff = 0;
        int textoff = 0;
        int selHeight = stringHeight;
        if (Platforms.IsLinux()) {
            selHeight -= 2;
        }
        Image image = im = isExpanded ? this.getOpenImage() : this.getImage();
        if (imHeight > stringHeight) {
            imoff = 0;
            textoff = (imHeight - stringHeight) / 2;
        } else {
            textoff = 0;
            imoff = (stringHeight - imHeight) / 2;
        }
        if (im != null) {
            if (sender instanceof ListCanvas && index >= 0 && ((ListCanvas)sender).getHiIndex() == index && !((ListCanvas)sender).isDragging()) {
                g.setColor(JWColor.BBARBG);
                g.fillRect(0, imoff, this.getImageWidth(sender), imHeight);
            }
            g.drawImage(im, 0, imoff, sender);
            if (sender instanceof ListCanvas && index >= 0 && ((ListCanvas)sender).getHiIndex() == index) {
                g.setColor(new Color(0, 0, 0, 96));
                g.drawRect(0, imoff, this.getImageWidth(sender), imHeight);
            }
            xoff = im.getWidth(sender) + 2;
        }
        int stringX = 3 + xoff;
        int stringY = stringAscent + textoff;
        Color textFG = this.getTextColor(sender);
        if (selected) {
            if (!sender.hasFocus()) {
                g.setColor(JWidgetsUtil.Brightness(sender.getBackground(), 80));
                g.fillRect(xoff, textoff, stringWidth + 7, selHeight + 2);
                g.setColor(textFG);
                this.drawDisplayString(g, stringX, stringY);
            } else {
                g.setColor(this.getSelectionColor());
                g.fillRect(xoff, textoff, stringWidth + 7, selHeight + 2);
                g.setColor(this.getSelectionForeground());
                g.drawRect(xoff, textoff, stringWidth + 6, selHeight + 1);
                this.drawDisplayString(g, stringX, stringY);
            }
        } else {
            g.setColor(textFG);
            this.drawDisplayString(g, stringX, stringY);
        }
        if (sender instanceof ListCanvas && index >= 0 && ((ListCanvas)sender).getHiIndex() == index && ((ListCanvas)sender).isDragging()) {
            IListItem it = ((ListCanvas)sender).getDragItem();
            ListCanvas lCanvas = (ListCanvas)sender;
            if (it != this) {
                g.translate(20, -height / 2);
                if (!lCanvas.canDrop(this, it)) {
                    g.setColor(new Color(208, 208, 208, 50));
                    g.fillRect(0, 0, it.widthIn(sender), height);
                    it.paint(g, sender, false, false, index);
                    g.setColor(new Color(208, 208, 208, 200));
                    g.fillRect(0, 0, it.widthIn(sender), height);
                } else {
                    g.setColor(new Color(208, 208, 208, 200));
                    g.fillRect(0, 0, it.widthIn(sender), height);
                    it.paint(g, sender, false, false, index);
                }
                g.setColor(Color.black);
                g.drawRect(0, 0, it.widthIn(sender), height);
                g.translate(-20, height / 2);
            }
        }
    }

    protected Color getTextColor(NCPanel sender) {
        Color c = sender.getForeground();
        if (this.getLinkStyle()) {
            int ci = c.getRGB() & 0xFFFFFF;
            if ((ci = (((ci & 0xFF0000) >> 16) + ((ci & 0xFF00) >> 8) + (ci & 0xFF)) / 3) <= 128) {
                return linkColor;
            }
        }
        return c;
    }

    protected void drawDisplayString(Graphics g, int stringX, int stringY) {
        g.drawString(this.getDisplayString(), stringX, stringY);
        if (this.getLinkStyle()) {
            g.drawLine(stringX, stringY + 2, stringX + g.getFontMetrics().stringWidth(this.getDisplayString()), stringY + 2);
        }
    }

    protected boolean getLinkStyle() {
        return false;
    }

    public Image getOpenImage() {
        return this.getImage();
    }

    public Color getSelectionColor() {
        return selectionColor;
    }

    public Color getSelectionForeground() {
        return selectionTextColor;
    }

    public Color getNoFocusSelectionForeground() {
        return selectionNoFocusTextColor;
    }

    public Image getImage() {
        return null;
    }

    public int getImageHeight(Component comp) {
        if (this.getImage() == null) {
            return 0;
        }
        return this.getImage().getHeight(comp);
    }

    public int getImageWidth(Component comp) {
        if (this.getImage() == null) {
            return 0;
        }
        return this.getImage().getWidth(comp);
    }

    public int widthIn(Component comp) {
        if (this.getImage() == null) {
            return comp.getFontMetrics(comp.getFont()).stringWidth(this.getDisplayString());
        }
        return this.getImageWidth(comp) + 6 + comp.getFontMetrics(comp.getFont()).stringWidth(this.getDisplayString());
    }

    public int heightIn(Component comp) {
        if (this.getImage() == null) {
            return comp.getFontMetrics(comp.getFont()).getHeight();
        }
        return Math.max(comp.getFontMetrics(comp.getFont()).getHeight(), this.getImage().getHeight(comp));
    }

    public abstract String getDisplayString();

    public boolean hasContent() {
        return false;
    }

    public Object dataObject() {
        Object res = this.wrappedObject();
        while (res instanceof IDataItem && res != this) {
            res = ((IDataItem)res).dataObject();
        }
        return res;
    }

    public Object wrappedObject() {
        return this;
    }

    public void itemHasCollapsed() {
    }
}

