/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class BrightnessFilter
extends RGBImageFilter {
    int[] percent = new int[3];
    int toAdd = 0;

    public BrightnessFilter(int perc) {
        this.canFilterIndexColorModel = false;
        this.percent[0] = perc;
        this.percent[1] = perc;
        this.percent[2] = perc;
    }

    public BrightnessFilter(int percRed, int percGreen, int percBlue) {
        this.canFilterIndexColorModel = false;
        this.percent[0] = percRed;
        this.percent[1] = percGreen;
        this.percent[2] = percBlue;
    }

    public BrightnessFilter(int percRed, int percGreen, int percBlue, int toAdd) {
        this.canFilterIndexColorModel = false;
        this.percent[0] = percRed;
        this.percent[1] = percGreen;
        this.percent[2] = percBlue;
        this.toAdd = toAdd;
    }

    public synchronized void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        int index = off;
        int cy = 0;
        while (cy < h) {
            int cx = 0;
            while (cx < w) {
                int mask = 0xFF0000;
                int res = 0;
                int n = 2;
                while (n >= 0) {
                    int c = ((pixels[index] & mask) >>> 8 * n) + this.toAdd;
                    c = Math.min(c * this.percent[n] / 100, 255);
                    res |= c << 8 * n;
                    mask >>>= 8;
                    --n;
                }
                pixels[index] = res | pixels[index] & 0xFF000000;
                ++index;
                ++cx;
            }
            index += scansize - w;
            ++cy;
        }
        this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
    }

    public int filterRGB(int x, int y, int rgb) {
        return 0;
    }
}

