/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.IVisual;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.Visual;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class ButtonDecorator
extends Visual
implements Cloneable {
    IVisual iv;
    boolean isPressed = false;
    boolean flat = false;

    public ButtonDecorator(Component par, IVisual _iv) {
        super(par);
        this.iv = _iv;
    }

    public ButtonDecorator(Component par, IVisual _iv, boolean flat) {
        super(par);
        this.iv = _iv;
        this.flat = flat;
    }

    public boolean pressed() {
        return this.isPressed;
    }

    public void paint(Graphics g) {
        Dimension d = this.preferredSize();
        if (!this.isPressed) {
            g.translate(3, 3);
            this.iv.paint(g, d.width - 4, d.height - 4);
            g.translate(-3, -3);
            g.setColor(Color.black);
            g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
            g.drawLine(d.width - 3, d.height - 1, d.width - 3, 0);
            g.setColor(JWColor.For("background.+"));
            g.drawLine(2, d.height - 2, 2, 1);
            g.drawLine(2, 1, d.width, 1);
        } else {
            g.translate(1, 1);
            this.iv.paint(g, d.width - 2, d.height - 2);
            g.translate(-1, -1);
        }
        g.setColor(this.parent.getBackground());
    }

    public Dimension preferredSize() {
        Dimension d = this.iv.preferredSize();
        d = new Dimension(d.width, d.height);
        if (d.width == 0 && d.height == 0) {
            d = this.parent.size();
            --d.width;
            --d.height;
        }
        d.width += 2;
        d.height += 2;
        return d;
    }

    public IVisual clone(String kind) {
        ButtonDecorator v = null;
        try {
            v = (ButtonDecorator)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(Tracer.This);
        }
        if (kind.equals("pressed")) {
            v.isPressed = true;
        }
        if (kind.equals("unpressed")) {
            v.isPressed = false;
        }
        v.iv = this.iv.clone(kind);
        return v;
    }
}

