/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JCanvas;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ScrollerPanel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class CustomScroller
extends JCanvas
implements Runnable,
MouseMotionListener,
MouseListener {
    public boolean mouseButtonState = false;
    public boolean isHorizontal = false;
    Image buffer = null;
    double minValue = 0.0;
    double maxValue = 50.0;
    double visibleRange = 10.0;
    double selection = 0.0;
    int delay = 70;
    double page;
    Dimension dim = new Dimension();
    int dragStart = -1;
    boolean first;
    boolean running = false;

    public void focusGained(FocusEvent e) {
        if (this.getParent() instanceof JWScrollPane) {
            this.getParent().requestFocus();
        }
    }

    public void requestFocus() {
        this.getParent().requestFocus();
    }

    public void init() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setVisibleRange(double d) {
        this.visibleRange = d;
        this.repaint();
    }

    public void setRange(double start, double end) {
        this.minValue = start;
        this.maxValue = end;
        double os = this.selection;
        this.selection = this.validateSelection(this.selection);
        this.repaint();
        if (os != this.selection) {
            this.binder().notifyTargets(this.selection);
        }
    }

    public void setSelection(double sel) {
        this.selection = this.validateSelection(sel);
        this.repaintImmediate();
    }

    public double getVisibleRange(double d) {
        return this.visibleRange;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSelection() {
        return this.selection;
    }

    public void beHorizontal(boolean b) {
        this.isHorizontal = b;
        this.repaint();
    }

    public void paintButton(Graphics g, int width, int height, boolean pressed) {
        g.setColor(JWColor.For("scrollbar.balken"));
        JWidgetsUtil.PaintBorder(g, width, height, false);
        g.fillRect(1, 1, width - 3, height - 3);
    }

    public void paintBackground(Graphics g) {
        Dimension d = this.size();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        g.drawLine(0, 0, d.width, 0);
        g.drawLine(0, 0, 0, d.height);
        g.setColor(Color.lightGray);
        g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
        g.drawLine(d.width, d.height - 1, 0, d.height - 1);
    }

    public void jwPaint(Graphics realG) {
        this.enableDoubleBuff(false);
        Dimension d = this.getSize();
        int w = this.isHorizontal ? d.height : d.width;
        int h = this.isHorizontal ? d.width : d.height;
        int buttonHeight = this.calcSizeIn(h);
        int buttonPos = this.calcPos(h, buttonHeight);
        if (d.width == 0 || d.height == 0) {
            return;
        }
        if (this.buffer == null || this.buffer.getHeight(this) != this.size().height || this.buffer.getWidth(this) != this.size().width) {
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = this.createImage(this.size().width, this.size().height);
            if (this.buffer == null) {
                return;
            }
        }
        Graphics buffG = this.buffer.getGraphics();
        this.paintBackground(buffG);
        if (this.isHorizontal) {
            buffG.translate(buttonPos, 0);
            this.paintButton(buffG, buttonHeight, w, this.mouseButtonState);
            buffG.translate(-buttonPos, 0);
            realG.drawImage(this.buffer, 0, 0, Color.black, this);
        } else {
            buffG.translate(0, buttonPos);
            this.paintButton(buffG, w, buttonHeight, this.mouseButtonState);
            buffG.translate(0, -buttonPos);
            realG.drawImage(this.buffer, 0, 0, Color.black, this);
        }
        buffG.dispose();
        this.enableDoubleBuff(true);
    }

    int calcPos(int fullSize, int buttonSize) {
        if (buttonSize >= fullSize) {
            return 0;
        }
        double range = Math.abs(this.maxValue - this.minValue);
        int result = (int)((double)fullSize * ((this.selection - this.minValue) / range));
        if (result + buttonSize >= fullSize) {
            result = fullSize - buttonSize;
        }
        return result;
    }

    int calcSizeIn(int fullSize) {
        double range = Math.abs(this.maxValue - this.minValue);
        if (range <= this.visibleRange) {
            return fullSize;
        }
        int result = 1 + (int)((double)fullSize * (this.visibleRange / range));
        if (result < 16) {
            result = 16;
        }
        return result;
    }

    public Dimension preferredSize() {
        if (this.isHorizontal) {
            this.dim.width = 100;
            this.dim.height = ScrollerPanel.BARSIZE;
        } else {
            this.dim.width = ScrollerPanel.BARSIZE;
            this.dim.height = 100;
        }
        return this.dim;
    }

    double selectionFromCoords(int coord, int fullSize) {
        double range = Math.abs(this.maxValue - this.minValue);
        return this.minValue + (double)coord / (double)fullSize * range;
    }

    protected void processEvent(AWTEvent e) {
        double oldSelection = this.selection;
        boolean oldMouse = this.mouseButtonState;
        super.processEvent(e);
        this.selection = this.validateSelection(this.selection);
        if (this.selection != oldSelection) {
            this.repaint();
            this.binder().notifyTargets(this.selection);
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.dragStart < 0) {
            return;
        }
        int h = this.size().height;
        if (this.isHorizontal) {
            x = e.getY();
            y = e.getX();
            h = this.size().width;
        }
        this.mouseButtonState = true;
        this.selection = this.selectionFromCoords(y - this.dragStart, h);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int buttonHeight;
        JWMenuBar.ResetMenu();
        Container c = this.getFrame();
        if (c != null && c instanceof Frame) {
            ((Frame)c).toFront();
        }
        int x = e.getX();
        int y = e.getY();
        this.first = true;
        if (this.mouseButtonState) {
            this.mouseButtonState = false;
            return;
        }
        this.mouseButtonState = true;
        if (this.isHorizontal) {
            x = e.getY();
            y = e.getX();
        }
        int w = this.isHorizontal ? this.size().height : this.size().width;
        int h = this.isHorizontal ? this.size().width : this.size().height;
        int buttonPos = this.calcPos(h, buttonHeight = this.calcSizeIn(h));
        if (y >= buttonPos && y <= buttonPos + buttonHeight) {
            this.dragStart = y - buttonPos;
            return;
        }
        if (e.isMetaDown()) {
            this.selection = this.selectionFromCoords(y, h) - this.visibleRange / 2.0;
        } else {
            this.page = y <= buttonPos ? -this.visibleRange : this.visibleRange;
            this.selection += this.page;
            if (!this.running) {
                new Thread(this).start();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseButtonState = false;
        this.dragStart = -1;
    }

    double validateSelection(double _selection) {
        return Math.max(Math.min(this.maxValue - this.visibleRange, _selection), this.minValue);
    }

    public void run() {
        this.running = true;
        try {
            if (this.first) {
                Thread.sleep(4 * this.delay);
            }
            this.first = false;
            while (this.mouseButtonState) {
                Thread.sleep(this.delay);
                double old = this.selection;
                this.selection = this.validateSelection(this.selection + this.page);
                if (this.selection == old) continue;
                this.repaint();
                this.binder().notifyTargets(this.selection);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.running = false;
    }
}

