/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import JWVFile.VFile;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;

public class DirNode
extends ListItem
implements FilenameFilter {
    public File file;
    String display;
    boolean hasContent = false;
    Image openImage;
    IListItem[] cont;

    public DirNode(File f) {
        super(f);
        this.file = f;
        this.hasContent = f.isDirectory();
        this.computeImage();
    }

    protected void computeImage() {
        File f = this.file;
        if (f.isDirectory()) {
            this.im = NCApplication.GetImage("dir.gif");
            this.openImage = NCApplication.GetImage("diropen.gif");
        } else {
            this.im = NCApplication.GetImage("file.gif");
            this.openImage = NCApplication.GetImage("fileopen.gif");
        }
    }

    public File getFile() {
        return this.file;
    }

    public Image getImage() {
        return this.im;
    }

    public Image getOpenImage() {
        if (this.openImage != null) {
            return this.openImage;
        }
        return this.getImage();
    }

    public void itemHasCollapsed() {
        this.cont = null;
    }

    public IListItem[] contents() {
        this.constructContent();
        return this.cont;
    }

    void constructContent() {
        String fname = this.file.getAbsolutePath();
        Object[] files = this.file.list(this);
        if (files == null) {
            files = new String[]{};
        }
        this.cont = new IListItem[files.length];
        JArray arr = new JArray(files.length + 1);
        arr.addAll(files);
        JArray.QuickSort(arr, JArray.UpperCaseStringSortFunc());
        int n = 0;
        while (n < arr.size()) {
            arr.setAt(n, this.constructSubNode(arr.at(n).toString(), n));
            ++n;
        }
        int n2 = 0;
        while (n2 < arr.size()) {
            this.cont[n2] = (IListItem)arr.at(n2);
            this.cont[n2].setDepth(this.getDepth() + 1);
            ++n2;
        }
        if (this.cont == null) {
            this.cont = new IListItem[0];
            this.hasContent = false;
        }
    }

    protected DirNode constructSubNode(String name, int n) {
        return new DirNode(new File(this.file, name));
    }

    public String getDisplayString() {
        if (this.display == null) {
            this.display = this.getDepth() == 1 ? this.file.getAbsolutePath() : this.file.getName();
        }
        return this.display;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public boolean accept(File dir, String name) {
        File f = new File(dir, name);
        String ext = "." + VFile.Extension(name);
        return AJDirSelector.matchAny || f.isDirectory() || ext != null && AJDirSelector.possTypes.contains(ext);
    }
}

