/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.FreeStyleVisualScroller;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWGradientVisual;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class JWGradientScroller
extends FreeStyleVisualScroller {
    int rgb = -1;

    public void init() {
        super.init();
        this.isHorizontal = true;
        this.backVisual = new JWGradientVisual(Color.black, Color.white);
        ((JWGradientVisual)this.backVisual).setRotation(270);
    }

    public void paintButton(Graphics g, int width, int height, boolean pressed) {
        JWidgetsUtil.PaintBorder(g, width, height, false);
        g.translate(1, 1);
        JWidgetsUtil.PaintBorder(g, width - 3, height - 3, true);
        g.translate(-1, -1);
    }

    public double getSelection() {
        return super.getSelection() / (this.getMaxValue() - this.getMinValue() - this.getVisibleRange(0.0));
    }

    public void setSelection(double sel) {
        super.setSelection(sel * (this.getMaxValue() - this.getMinValue() - this.getVisibleRange(0.0)));
    }

    public Color getSelectedColor() {
        return ((JWGradientVisual)this.backVisual).getColor(this.getSelection(), 0.5);
    }

    public void setSelection(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int max = g > r || b > r ? (g > b ? g : b) : r;
        int rgb = (int)(255.1 * (double)r / (double)max) << 16 | (int)(255.1 * (double)g / (double)max) << 8 | (int)(255.1 * (double)b / (double)max);
        if (this.rgb != rgb) {
            this.rgb = rgb;
            this.setColors(Color.black, new JWColor(0xFF000000 | rgb));
        }
        this.setSelection((double)max / 255.0);
    }

    public void setColors(Color startcolor, Color endcolor) {
        ((JWGradientVisual)this.backVisual).setColors(startcolor, endcolor);
    }
}

