/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import JCollections.JUnsafeTable;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.BufferSupport;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuItem;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCMenuWindow;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.ServiceRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalLookAndFeel;
import netcomputing.collections.NCBinder;
import netcomputing.tools.Platforms;

public class JWMenuBar
extends NCPanel
implements MouseListener,
MouseMotionListener {
    public static NCMenuWindow thePopup = null;
    public static Font MenuFont = MetalLookAndFeel.getMenuTextFont();
    static JWMenuBar activeBar = null;
    static boolean hideInsteadDispose = true;
    static int gap = 14;
    static int gapY = 4;
    static int insetY = 4;
    static NCMenuWindow[] windows = new NCMenuWindow[10];
    public static JWMenuBar[] bars = new JWMenuBar[10];
    public Vector items = new Vector(10);
    boolean active = false;
    public boolean isVertical = false;
    boolean hasMouse = false;
    int hlevel = 0;
    int focusCount = 0;
    long ticker = 0L;
    Component fakedParent = null;
    NCBinder binderPopOpening = new NCBinder(this);
    int maxH = 0;
    BufferSupport buff = new BufferSupport();
    int prevSel = -1;

    public JWMenuBar(int hlevel) {
        JWMenuBar.bars[hlevel] = this;
        this.hlevel = hlevel;
    }

    public void init() {
        super.init();
        this.setBackground(JWColor.For("background"));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.addKeyListener(new KeyFilter(38, this, "actionUp"));
        this.addKeyListener(new KeyFilter(40, this, "actionDown"));
        this.addKeyListener(new KeyFilter(10, this, "actionRet"));
        this.addKeyListener(new KeyFilter(39, this, "actionRight", false));
        this.addKeyListener(new KeyFilter(27, this, "actionESC"));
    }

    public NCBinder binderPopOpening() {
        return this.binderPopOpening;
    }

    public Object actionESC(Object a, Object s) {
        this.resetMenu();
        return null;
    }

    public Object actionRight(Object a, Object s) {
        if (windows[this.hlevel] == null) {
            this.initMenuWindows();
        }
        JWMenuItem item = this.at(0);
        int h = item.heightIn(this);
        int[] posAndIndex = new int[]{(h + gapY) * this.prevSel, this.prevSel};
        NCApplication.Pln("prevsel" + this.prevSel);
        this.forceRepaint(this.getParent());
        this.popUpMenuFor(posAndIndex[1], windows[this.hlevel], !this.isVertical);
        windows[this.hlevel].pack();
        Point p = this.getLocationOnScreen();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (!this.isVertical) {
            r.x = p.x + posAndIndex[0];
            r.y = p.y + this.getSize().height - insetY + 2;
        } else {
            r.x = p.x + this.maxH + 2 * gap;
            r.y = p.y + posAndIndex[0] - 6;
        }
        Dimension d = windows[this.hlevel].getMinimumSize();
        r.width = d.width;
        r.height = d.height;
        if (r.x + r.width > NCPanel.ScreenSize.width) {
            r.x = p.x - r.width;
        }
        JWidgetsUtil.ForceToScreenSize(r, 4);
        windows[this.hlevel].setLocation(r.x, r.y);
        windows[this.hlevel].show(true);
        windows[this.hlevel].toFront();
        this.hasMouse = true;
        JWMenuBar.hideSubWindows(this.hlevel + 1);
        return null;
    }

    public Object actionUp(Object a, Object s) {
        this.prevSel = (this.items.size() - 1 + this.prevSel) % this.items.size();
        int stopCount = 0;
        while (((JWMenuItem)this.items.elementAt(this.prevSel)).getDisplayString().equals("-") && stopCount++ < 20) {
            this.prevSel = (this.items.size() - 1 + this.prevSel) % this.items.size();
        }
        if (this.prevSel < 0) {
            this.prevSel = 0;
        }
        this.forceRepaint(this.getParent());
        return null;
    }

    public Object actionDown(Object a, Object s) {
        ++this.prevSel;
        this.prevSel %= this.items.size();
        int stopCount = 0;
        while (((JWMenuItem)this.items.elementAt(this.prevSel)).getDisplayString().equals("-") && stopCount++ < 20) {
            ++this.prevSel;
            this.prevSel %= this.items.size();
        }
        this.forceRepaint(this.getParent());
        return null;
    }

    public Object actionRet(Object a, Object s) {
        this.mousePressed(null);
        return null;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics gg) {
        Dimension d = this.getSize();
        this.buff.checkBuffer(d, this);
        Graphics g = this.buff.getGraphics();
        g.setColor(JWColor.For("background"));
        g.fillRect(0, 0, d.width, d.height);
        if (!this.isVertical) {
            int x = insetY;
            g.translate(0, insetY);
            g.setFont(MenuFont);
            int n = 0;
            while (n < this.items.size()) {
                JWMenuItem item = this.at(n);
                this.maxH = Math.max(this.maxH, item.heightIn(this));
                int w = item.widthIn(this);
                item.paint(g, this, n == this.prevSel, false, n);
                g.translate(w - 20, 0);
                ++n;
            }
        } else {
            JWidgetsUtil.PaintBorder(g, this.size().width + 3, this.size().height + 3, false);
            g.setColor(Color.black);
            boolean y = false;
            g.translate(gap, gapY + 4);
            int n = 0;
            while (n < this.items.size()) {
                int w = 0;
                JWMenuItem item = this.at(n);
                int oldMax = this.maxH;
                this.maxH = Math.max(this.maxH, item.widthIn(this) + gap / 2);
                if (this.maxH != oldMax) {
                    this.buff.dispose(g);
                    this.paint(gg);
                    return;
                }
                w = item.heightIn(this);
                if (this.at(n).getDisplayString().equals("-")) {
                    w = 4;
                    g.translate(-gap - 20, 4);
                    this.at(n).setEnabled(false);
                    JWidgetsUtil.PaintBorder(g, 60 + this.maxH + 2 * gap, 3, false);
                    g.translate(gap + 20, 0);
                } else {
                    item.paintMenu(g, this, n == this.prevSel, this.maxH);
                    if (item.hasContent() && item.isEnabled()) {
                        JWidgetsUtil.DrawButton(g, 35 + (n == this.prevSel ? 4 : 0), this.maxH - 3, 0, w - 2, w - 2);
                    }
                }
                g.translate(0, w + gapY);
                ++n;
            }
        }
        this.buff.drawImage(gg, 0, 0, this);
        this.buff.dispose(g);
    }

    public boolean hasFocus() {
        return this.focusCount > 0;
    }

    boolean hasAnyOneFocus() {
        int n = 0;
        while (n < bars.length) {
            if (bars[n] != null && bars[n].hasFocus()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean hasAnyOneMouse() {
        int n = 0;
        while (n < bars.length) {
            if (bars[n] != null && JWMenuBar.bars[n].hasMouse) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void focusLost(FocusEvent e) {
        if (this.hasFocus()) {
            --this.focusCount;
        }
    }

    public void focusGained(FocusEvent e) {
        ++this.focusCount;
    }

    boolean doSelect() {
        if (!this.at(this.prevSel).hasContent() && this.at(this.prevSel).isEnabled()) {
            JWMenuItem sel = this.at(this.prevSel);
            try {
                this.resetMenu();
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            try {
                if (sel.getActionTarget() instanceof ActionListener) {
                    ((ActionListener)sel.getActionTarget()).actionPerformed(new ActionEvent(this, 0, "service"));
                } else {
                    NCApplication.PerformAction(sel.getActionTarget(), sel.getAction(), sel, this);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace(Tracer.This);
            }
            return true;
        }
        return false;
    }

    public static void ResetMenu() {
        try {
            if (ServiceRegistry.lastOne != null && ServiceRegistry.lastOne.isVisible()) {
                ServiceRegistry.lastOne.setVisible(false);
                ServiceRegistry.lastOne.getParent().repaint();
                Platforms.ensureRepaintFinished(EditApp.App.jol);
            }
        }
        catch (Exception th) {
            // empty catch block
        }
        JWMenuBar.closeWindow(thePopup);
        int n = 0;
        while (n < windows.length) {
            if (windows[n] != null) {
                JWMenuBar.closeWindow(windows[n]);
            }
            ++n;
        }
        if (EditFrame.host != null) {
            EditFrame.Status().closeStatusPopup();
        }
    }

    public void resetMenu() {
        JWMenuBar.hideSubWindows(0);
        if (activeBar != null) {
            JWMenuBar.activeBar.prevSel = -1;
            JWMenuBar.activeBar.active = false;
            JWMenuBar.activeBar.focusCount = 0;
            activeBar.forceRepaint(activeBar);
            activeBar = null;
        }
        int n = 0;
        while (n < bars.length) {
            if (bars[n] != null) {
                JWMenuBar.bars[n].prevSel = -1;
                JWMenuBar.bars[n].hasMouse = false;
                JWMenuBar.bars[n].active = false;
                JWMenuBar.bars[n].focusCount = 0;
            }
            ++n;
        }
        if (JWMenuBar.bars[0].isVertical) {
            if (hideInsteadDispose) {
                ((NCMenuWindow)bars[0].getParent()).hide();
            } else {
                ((NCMenuWindow)bars[0].getParent()).dispose();
            }
        }
        if (Platforms.IsLinux()) {
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public void mouseReleased(MouseEvent e) {
        boolean foundTarget = false;
        Point me2 = this.getLocationOnScreen();
        e.translatePoint(me2.x, me2.y);
        int n = this.hlevel;
        while (n < windows.length) {
            Point org = new Point();
            try {
                org = windows[n].getLocationOnScreen();
            }
            catch (IllegalComponentStateException ee) {
                // empty catch block
            }
            Dimension dim = windows[n].getSize();
            Rectangle rect = new Rectangle(org.x, org.y, dim.width, dim.height);
            if (e.getX() > rect.x && e.getX() < rect.x + rect.width && e.getY() > rect.y && e.getY() < rect.y + rect.height) {
                e.translatePoint(-org.x, -org.y);
                if (bars[n + 1].doSelect()) {
                    foundTarget = true;
                }
                return;
            }
            ++n;
        }
        e.translatePoint(-me2.x, -me2.y);
        Dimension d = this.getSize();
        if (e.getX() < 0 || e.getY() < 0 || e.getX() > d.width || e.getY() > d.height) {
            this.resetMenu();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.hlevel == 0 && !this.isVertical) {
            activeBar = this;
            boolean bl = this.active = !this.active;
            if (this.active) {
                this.ticker = System.currentTimeMillis();
                if (thePopup != null) {
                    JWMenuBar.closeWindow(thePopup);
                    thePopup = null;
                }
                this.initMenuWindows();
                this.mouseMoved(e);
            } else {
                JWMenuBar.hideSubWindows(0);
                this.prevSel = -1;
                this.forceRepaint(this);
            }
        } else {
            this.doSelect();
        }
    }

    public void mouseExited(MouseEvent e) {
        this.hasMouse = false;
    }

    public void mouseEntered(MouseEvent e) {
        this.hasMouse = true;
    }

    public void mouseDragged(MouseEvent e) {
        Point me2 = new Point();
        me2 = this.getLocationOnScreen();
        e.translatePoint(me2.x, me2.y);
        int n = this.hlevel;
        while (n < windows.length) {
            try {
                Point org = windows[n].getLocationOnScreen();
                Dimension dim = windows[n].getSize();
                Rectangle rect = new Rectangle(org.x, org.y, dim.width, dim.height);
                if (e.getX() > rect.x && e.getX() < rect.x + rect.width && e.getY() > rect.y && e.getY() < rect.y + rect.height) {
                    e.translatePoint(-org.x, -org.y);
                    bars[n + 1].mouseMoved(e);
                    return;
                }
            }
            catch (IllegalComponentStateException ee) {
                // empty catch block
            }
            ++n;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.active) {
            int[] posAndIndex = this.locateCell(e.getX(), e.getY());
            if (posAndIndex == null) {
                return;
            }
            if (posAndIndex[1] == this.prevSel) {
                return;
            }
            if (windows[this.hlevel] == null) {
                this.initMenuWindows();
            }
            this.prevSel = posAndIndex[1];
            this.forceRepaint(this.getParent());
            IListItem[] it = this.at(posAndIndex[1]).contents();
            if (it != null && it.length > 0) {
                this.popUpMenuFor(posAndIndex[1], windows[this.hlevel], !this.isVertical);
                windows[this.hlevel].pack();
                Point p = this.getLocationOnScreen();
                Rectangle r = new Rectangle(0, 0, 0, 0);
                if (!this.isVertical) {
                    r.x = p.x + posAndIndex[0];
                    r.y = p.y + this.getSize().height - insetY + 2;
                } else {
                    r.x = p.x + this.maxH + 2 * gap;
                    r.y = p.y + posAndIndex[0] - 6;
                }
                Dimension d = windows[this.hlevel].getMinimumSize();
                r.width = d.width;
                r.height = d.height;
                if (this.isVertical && r.x + r.width > NCPanel.ScreenSize.width) {
                    r.x = p.x - r.width;
                }
                JWidgetsUtil.ForceToScreenSize(r, 4);
                windows[this.hlevel].setLocation(r.x, r.y);
                windows[this.hlevel].show(true);
                windows[this.hlevel].toFront();
                this.hasMouse = true;
                JWMenuBar.hideSubWindows(this.hlevel + 1);
            } else if (windows[this.hlevel] != null && windows[this.hlevel].isShowing()) {
                windows[this.hlevel].setSize(0, 0);
            }
        }
    }

    static void closeWindow(Window w) {
        if (w != null) {
            if (hideInsteadDispose) {
                w.hide();
            } else {
                w.dispose();
            }
        }
    }

    public void initMenuWindows() {
        Container c = this.getFrame();
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        int n = 0;
        while (n < windows.length) {
            if (windows[n] != null) {
                JWMenuBar.closeWindow(windows[n]);
            }
            JWMenuBar.windows[n] = null;
            JWMenuBar.windows[n] = NCMenuWindow.New((Frame)c);
            windows[n].setFont(MenuFont);
            windows[n].setBackground(JWColor.For("background"));
            windows[n].setLayout(new BorderLayout());
            ++n;
        }
    }

    public static void hideSubWindows(int start) {
        int n = start;
        while (n < windows.length - 1) {
            if (windows[n] != null) {
                windows[n].hide();
                if (bars[n + 1] != null) {
                    JWMenuBar.bars[n + 1].hasMouse = false;
                    JWMenuBar.bars[n + 1].focusCount = 0;
                }
            }
            ++n;
        }
    }

    public void requestFocus() {
        Tracer.This.println("requestfocus menubar @@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
    }

    public void popUpMenuFor(int i, NCMenuWindow w, boolean vert) {
        IListItem[] o = this.at(i).contents();
        if (o.length > 0) {
            this.binderPopOpening().notifyTargets(o);
            if (w.countComponents() > 0) {
                w.remove(0);
            }
            JWMenuBar b = new JWMenuBar(this.hlevel + 1);
            b.init();
            int n = 0;
            while (n < o.length) {
                b.add(o[n]);
                ++n;
            }
            b.isVertical = true;
            b.active = true;
            w.add("Center", b);
        }
    }

    void forceRepaint(Container w) {
        Graphics g = this.getGraphics();
        this.paint(g);
        g.dispose();
        if (Platforms.IsLinux()) {
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public int[] locateCell(int x, int y) {
        if (!this.isVertical) {
            int w = 0;
            int n = 0;
            while (n < this.items.size()) {
                JWMenuItem item = this.at(n);
                int oldW = w;
                if (x < (w += item.widthIn(this) - 20) && x > oldW) {
                    return new int[]{oldW, n};
                }
                ++n;
            }
        } else {
            int w = gapY;
            int n = 0;
            while (n < this.items.size()) {
                JWMenuItem item = this.at(n);
                int oldW = w;
                w = item.getDisplayString().equals("-") ? (w += 8 + gapY) : (w += item.heightIn(this) + gapY);
                if (y < w && y > oldW) {
                    return new int[]{oldW, n};
                }
                ++n;
            }
        }
        return null;
    }

    public Dimension getMinimumSize() {
        if (!this.isVertical) {
            int w = 0;
            int n = 0;
            while (n < this.items.size()) {
                JWMenuItem item = this.at(n);
                item.isHorz = true;
                this.maxH = Math.max(this.maxH, item.heightIn(this));
                w += item.widthIn(this) + gap;
                ++n;
            }
            return new Dimension(w, this.maxH + insetY * 2);
        }
        int w = 0;
        int n = 0;
        while (n < this.items.size()) {
            JWMenuItem item = this.at(n);
            item.isHorz = false;
            this.maxH = Math.max(this.maxH, item.widthIn(this));
            w = item.getDisplayString().equals("-") ? (w += 8 + gapY) : (w += item.heightIn(this) + gapY);
            ++n;
        }
        if (w == 0 || this.maxH == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.maxH + 3 * gap - gap / 2, w + 2 * gapY + 6);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public final int itemSize() {
        return this.items.size();
    }

    public void setAt(Object obj, int index) {
        this.items.setElementAt(obj, index);
    }

    public void removeAt(int index) {
        this.items.removeElementAt(index);
    }

    public boolean remove(Object obj) {
        return this.items.removeElement(obj);
    }

    public void removeAll() {
        this.items.removeAllElements();
    }

    public void insertAt(Object obj, int index) {
        this.items.insertElementAt(obj, index);
    }

    public Enumeration elements() {
        return this.items.elements();
    }

    public JWMenuItem at(int index) {
        return (JWMenuItem)this.items.elementAt(index);
    }

    public void add(Object obj) {
        this.items.addElement(obj);
    }

    public static void main(String[] arg) {
        Frame f = new Frame();
        f.setFont(new Font("SansSerif", 0, 12));
        JWMenuBar menu = new JWMenuBar(0);
        menu.init();
        int n = 0;
        while (n < 10) {
            JWMenuItem item = new JWMenuItem((Object)("Hallo " + n), new JWMenuItem[]{new JWMenuItem("poaskaa d"), new JWMenuItem("poaasd asd   asd skd"), new JWMenuItem((Object)"po aaaaaaaaaaaaaaa  askd", new JWMenuItem[]{new JWMenuItem("poaskd"), new JWMenuItem("poasasda  asd kd"), new JWMenuItem("-"), new JWMenuItem("poaskd"), new JWMenuItem("poas asd kd"), new JWMenuItem("poaskd")}), new JWMenuItem((Object)"poaskd", new JWMenuItem[]{new JWMenuItem("poaskd"), new JWMenuItem("-"), new JWMenuItem("poaskd"), new JWMenuItem((Object)"poaskd", new JWMenuItem[]{new JWMenuItem("------------------"), new JWMenuItem("poaskd"), new JWMenuItem("poaskd")}), new JWMenuItem("po  askd"), new JWMenuItem("poa  skd")}), new JWMenuItem("-"), new JWMenuItem("po  askd"), new JWMenuItem("poa  skd"), new JWMenuItem("poa skd")});
            menu.add(item);
            ++n;
        }
        f.setLayout(new BorderLayout());
        f.add("North", menu);
        f.add("Center", new JTextField());
        f.pack();
        f.show();
    }

    public static void validateItemMap(JUnsafeTable items) {
        Enumeration e = items.keys();
        while (e.hasMoreElements()) {
            String msg = (String)e.nextElement();
            Object[] o = (Object[])items.get(msg);
            Object result = null;
            if (!NCApplication.RespondsToAction(o[1], msg)) {
                result = Boolean.FALSE;
                items.remove(o[1]);
            } else {
                String s = "isValid_" + msg;
                if (NCApplication.RespondsToAction(o[1], s)) {
                    result = NCApplication.PerformAction(o[1], s, null, null);
                } else {
                    items.remove(o[1]);
                }
            }
            ((JWMenuItem)o[0]).setEnabled(result == null);
        }
    }

    public static JWMenuBar buildMenuBarFrom(Object[][] ms, JUnsafeTable itemMap, Font f) {
        JWMenuBar mb = new JWMenuBar(0);
        if (f != null) {
            mb.setFont(f);
        }
        int n = 0;
        while (n < ms.length) {
            mb.add(JWMenuBar.buildMenuFrom(ms[n], itemMap));
            ++n;
        }
        return mb;
    }

    public static JWMenuItem buildMenuFrom(Object[] ms, JUnsafeTable itemMap) {
        JWMenuItem newMenu = new JWMenuItem((Object)ms[0].toString(), (Image)null);
        newMenu.setIsHorz(true);
        JArray newMenuChildren = new JArray(15);
        try {
            Object target = ms[2];
            String prefix = ms[1].toString();
            int n = 3;
            while (n < ms.length) {
                if (ms[n] instanceof Object[]) {
                    newMenuChildren.add(JWMenuBar.buildMenuFrom((Object[])ms[n++], itemMap));
                    continue;
                }
                String item = ms[n].toString();
                ++n;
                String men = item.trim();
                if (item.indexOf(":") > 0) {
                    men = men.substring(0, item.indexOf(":"));
                }
                JWMenuItem mi = new JWMenuItem((Object)item, NCApplication.GetImage("/images/menus/" + men + ".gif"));
                mi.setAction(prefix + "_" + ms[n].toString());
                mi.setActionTarget(target);
                if (itemMap != null) {
                    Object[] tmp = new Object[]{mi, target};
                    itemMap.put(prefix + "_" + ms[n], tmp);
                }
                ++n;
                newMenuChildren.add(mi);
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
        IListItem[] cont = new IListItem[newMenuChildren.size()];
        int n = 0;
        while (n < newMenuChildren.size()) {
            cont[n] = (IListItem)newMenuChildren.at(n);
            ++n;
        }
        newMenu.contents(cont);
        return newMenu;
    }

    public void show(Component org, int x, int y) {
        Frame f = null;
        f = org instanceof NCPanel ? (Frame)((NCPanel)org).getFrame() : (Frame)org;
        NCMenuWindow top = NCMenuWindow.New(f);
        Point p = org.getLocationOnScreen();
        x += p.x;
        y += p.y;
        this.isVertical = true;
        this.active = true;
        if (thePopup != null) {
            JWMenuBar.closeWindow(thePopup);
            thePopup = null;
        }
        thePopup = top;
        top.setLayout(new BorderLayout());
        top.setBackground(JWColor.For("background"));
        top.setFont(MenuFont);
        top.add("Center", this);
        top.pack();
        Dimension d = top.getPreferredSize();
        Rectangle r = new Rectangle(x, y, d.width, d.height);
        JWidgetsUtil.ForceToScreenSize(r, 4);
        top.setLocation(r.x, r.y);
        top.show(true);
        top.toFront();
        this.initMenuWindows();
        this.fakedParent = org;
    }

    public static JWMenuBar buildPopUpFrom(Object[][] ms, JUnsafeTable itemMap, Font f) {
        JWMenuBar newMenu = JWMenuBar.buildMenuBarFrom(ms, itemMap, f);
        return newMenu;
    }
}

