/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.NCApplication;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;

public class MemImageCreator
implements ImageConsumer,
ImageObserver {
    int[] pix;
    Dimension dim;
    ImageProducer source;
    boolean aborted;
    boolean complete;
    MemoryImageSource memSrc = null;

    public MemImageCreator() {
    }

    public MemImageCreator(String path) {
        this.readImage(path);
    }

    synchronized void readImage(String path) {
        this.dim = new Dimension(NCApplication.GetImage(path).getWidth(this), NCApplication.GetImage(path).getHeight(this));
        int w = this.dim.width;
        int h = this.dim.height;
        if (this.pix == null) {
            this.pix = new int[w * h];
        }
        this.memSrc = null;
        this.source = NCApplication.GetImage(path).getSource();
        this.source.startProduction(this);
    }

    public int getWidth() {
        return this.dim.width;
    }

    public int getHeight() {
        return this.dim.height;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x40) != 0 || (infoflags & 0x80) != 0) {
            this.aborted = true;
            return false;
        }
        return true;
    }

    public int[] getPix() {
        return this.pix;
    }

    public MemoryImageSource getSource() {
        if (this.memSrc == null) {
            this.memSrc = new MemoryImageSource(this.dim.width, this.dim.height, this.pix, 0, this.dim.width);
            return this.memSrc;
        }
        return this.memSrc;
    }

    public void imageComplete(int status) {
        this.complete = true;
        this.source.removeConsumer(this);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public int calcColor(int color, ColorModel model) {
        color = model.getRGB(color);
        return color;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int offs = y * this.dim.width;
        int idy = 0;
        while (idy < h) {
            byte rgb = pixels[off];
            int acol = this.calcColor(rgb & 0xFF, model);
            int idx = 0;
            while (idx < w) {
                if (rgb != pixels[off + idx]) {
                    rgb = pixels[off + idx];
                    acol = this.calcColor(rgb & 0xFF, model);
                }
                this.pix[offs + idx + x] = acol;
                ++idx;
            }
            offs += this.dim.width;
            off += scansize;
            ++idy;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int offs = y * this.dim.width;
        int idy = 0;
        while (idy < h) {
            int rgb = pixels[off];
            int acol = this.calcColor(rgb, model);
            int idx = 0;
            while (idx < w) {
                if (rgb != pixels[off + idx]) {
                    rgb = pixels[off + idx];
                    acol = this.calcColor(rgb, model);
                }
                this.pix[offs + idx + x] = acol;
                ++idx;
            }
            offs += this.dim.width;
            off += scansize;
            ++idy;
        }
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int width, int height) {
    }

    public void setHints(int hintflags) {
    }

    public void setProperties(Hashtable props) {
    }
}

