/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JSet;
import de.netcomputing.anyj.AJIDEOptions;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IBuilderInstanceCreator;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JTableCanvas;
import de.netcomputing.anyj.jwidgets.JTableHeader;
import de.netcomputing.anyj.jwidgets.JTableModel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.ScrollerPanel;
import de.netcomputing.anyj.jwidgets.TestModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.SwingUtilities;

public class NCTableView
extends NCPanel
implements IBuilderInstanceCreator {
    JTableHeader header;
    JTableCanvas canv;
    JTableModel model;
    JWScrollPane spane;
    public static int COLPRESSABLE = 1;
    public static int COLMOVABLE = 2;
    public static int COLMULTI = 4;
    public static int COLSIZEABLE = 8;
    public static int COLPUSHABLE = 16;
    public static int LASTHEADER = 32;
    public static int ROWMULTI = 32;
    public static int RANGESELECTION = 64;
    public static int CELLEDITABLE = 128;
    public static int NOGROW = 256;
    public static int ROWSELECTABLE = 512;
    public static int LBOXLIKE = COLSIZEABLE | ROWSELECTABLE;
    public static int MULTILBOXLIKE = ROWMULTI | COLSIZEABLE | ROWSELECTABLE;
    public static int ALLFLAGS = 1023;
    int flags;
    boolean autoFit = false;

    protected JTableCanvas newCanvas(JTableModel m, JTableHeader h) {
        return new JTableCanvas(this.model, this.header);
    }

    public void init() {
        super.init();
        this.setFont(JListPanel.ListFont);
        this.setLayout(null);
        this.header = new JTableHeader();
        this.add(this.header);
        this.header.init();
        this.header.setBackground(JWColor.For("background"));
        this.header.binderDragOccured().addTarget(this, "actionDrag");
        this.header.setFlag(JTableHeader.MULTI);
        this.canv = this.newCanvas(this.model, this.header);
        this.canv.binderShouldScrollY().addTarget(this, "actionComponentScrolLY");
        this.spane = new JWScrollPane(this.canv);
        this.add(this.spane);
        this.spane.scrollbarHorz().binder().addTarget(this, "actionScrollH");
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((NCTableView.this.flags & ROWMULTI) == ROWMULTI) {
                    return;
                }
                int i = NCTableView.this.getRowSelection();
                int ch = NCTableView.this.canv.ch;
                if (e.getKeyCode() == 38) {
                    if (i > 0) {
                        NCTableView.this.setSelection(i - 1);
                        NCTableView.this.binderRowSelection().notifyTargets(this);
                        NCTableView.this.spane.scrollToVisibleY(ch * (i - 1), ch * i);
                        NCTableView.this.repaint();
                    }
                } else if (e.getKeyCode() == 40) {
                    if (i < 0 && NCTableView.this.model.dimY() > 0) {
                        NCTableView.this.setSelection(0);
                        NCTableView.this.binderRowSelection().notifyTargets(this);
                        NCTableView.this.spane.scrollToVisibleY(0, ch);
                        NCTableView.this.repaint();
                        return;
                    }
                    if (NCTableView.this.model.dimY() > i + 1) {
                        NCTableView.this.setSelection(i + 1);
                        NCTableView.this.binderRowSelection().notifyTargets(this);
                        NCTableView.this.spane.scrollToVisibleY(ch * (i + 1), ch * (i + 2));
                        NCTableView.this.repaint();
                    }
                }
            }
        });
        this.setBackground(JWColor.For("listpanel.background"));
        this.spane.setBackground(JWColor.For("listpanel.background"));
        try {
            this.addMWListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    SwingUtilities.invokeLater(new Runnable(this, e){
                        private final /* synthetic */ MouseWheelEvent val$e;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$e = val$e;
                        }

                        public void run() {
                            2.access$000(this.this$1).spane.scrollYTo(2.access$000(this.this$1).spane.yOff() + this.val$e.getWheelRotation() * (1 + AJIDEOptions.This.getMouseWheelAmount()) * 2.access$000(this.this$1).spane.getHeight() / 14);
                        }
                    });
                }

                static /* synthetic */ NCTableView access$000(2 x0) {
                    return x0.NCTableView.this;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addMWListener(Object li) {
        try {
            Method m = this.getClass().getMethod("addMouseWheelListener", Class.forName("java.awt.event.MouseWheelListener"));
            if (m != null) {
                m.invoke((Object)this, li);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addKeyListener(KeyListener k) {
        this.spane.addKeyListener(k);
        super.addKeyListener(k);
    }

    public void doLayout() {
        this.header.setBounds(2, 0, this.size().width - ScrollerPanel.BARSIZE - 4, this.header.preferredSize().height);
        this.spane.setBounds(0, this.header.preferredSize().height, this.size().width, this.size().height - this.header.preferredSize().height);
        if (this.autoFit) {
            this.fitColumnsToView(1024);
        }
    }

    public void update(Graphics g) {
    }

    public void paint(Graphics g) {
        g.setColor(JWColor.For("background"));
        g.fillRect(0, 0, this.getSize().width, this.header.getSize().height);
        super.paint(g);
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    public boolean getAutoFit() {
        return this.autoFit;
    }

    public Object actionModelChanged(Object a, Object sender) {
        if (((IValue)a).value() instanceof Object[]) {
            Object[] arg = (Object[])((IValue)a).value();
            String sel = (String)arg[0];
            int st = (Integer)arg[1];
            int en = (Integer)arg[2];
            this.spane.checkComponentValues();
            if (sel.equals("line")) {
                this.canv.repaintLines(st, en);
                if (en == this.model.dimY()) {
                    Dimension siz = this.canv.getSize();
                    if (siz.height > this.canv.ch * this.model.dimY()) {
                        this.canv.repaint(0, this.canv.ch * this.model.dimY(), siz.width, siz.height);
                    }
                }
            } else if (sel.equals("col")) {
                this.canv.repaintCols(st, en);
            } else if (sel.equals("field")) {
                this.canv.repaintCell(st, en);
            } else {
                this.canv.repaint();
            }
        } else {
            this.canv.repaint();
        }
        this.spane.checkComponentValues();
        return null;
    }

    public void addFlags(int newFlags) {
        this.flags |= newFlags;
        this.header.flags |= this.flags & LASTHEADER - 1;
        this.canv.isSelectable = this.isAll(ROWSELECTABLE);
        this.canv.isMulti = this.isAll(ROWMULTI);
        this.canv.isCellEditable = this.isAll(CELLEDITABLE);
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
        this.header.flags = this.flags & LASTHEADER - 1;
        this.header.allowGrow = !this.isAll(NOGROW);
        this.canv.isSelectable = this.isAll(ROWSELECTABLE);
        this.canv.isMulti = this.isAll(ROWMULTI);
        this.canv.isCellEditable = this.isAll(CELLEDITABLE);
    }

    public void clearFlags(int newFlag) {
        this.flags &= ~newFlag;
        this.header.flags = this.flags & LASTHEADER - 1;
        this.canv.isSelectable = this.isAll(ROWSELECTABLE);
        this.canv.isMulti = this.isAll(ROWMULTI);
        this.canv.isCellEditable = this.isAll(CELLEDITABLE);
    }

    public boolean isAll(int fl) {
        return (this.flags & fl) == fl;
    }

    public boolean isAny(int fl) {
        return (this.flags & fl) != 0;
    }

    public void repaint() {
        if (this.header == null || this.spane == null) {
            return;
        }
        if (this.autoFit) {
            this.fitColumnsToView(1024);
        }
        if (this.autoFit) {
            this.fitColumnsToView(1024);
        }
        super.repaint();
    }

    public Object actionComponentScrolLY(Object arg, Object sender) {
        int amount = ((IValue)arg).intValue();
        this.scrollY(amount);
        return null;
    }

    public Object actionScrollH(Object arg, Object sender) {
        this.header.offX = this.spane.xOff();
        this.header.repaint();
        return null;
    }

    public Object actionDrag(Object arg, Object sender) {
        if (this.autoFit) {
            this.fitColumnsToView(1024);
        }
        this.spane.checkComponentValues();
        return null;
    }

    public void scrollX(int x) {
        this.spane.checkComponentValues();
        this.spane.scrollbarHorz().setSelection(x);
    }

    public void scrollY(int x) {
        this.spane.checkComponentValues();
        this.spane.scrollbarVert().setSelection(x);
    }

    public void scrollYLine(int line) {
        this.scrollY(this.canv.ch * line);
    }

    public void scrollToEnd() {
        this.scrollY(this.canv.ch * this.model.dimY() - this.canv.size().height + this.canv.ch);
    }

    public void addHeader(String title, Object assoc, int modelPos, int size) {
        this.header.addHeader(title, assoc, modelPos, size);
    }

    public void deselectHeaderQuietNoNotify() {
        this.canv.deselectHeaderQuietNoNotify();
    }

    public void clearRowSelections() {
        this.canv.clearSelectionsQuiet();
    }

    public int getRowSelection() {
        return this.canv.getSelection();
    }

    public JSet getRowSelectionsAsSet() {
        return this.canv.getRowSelections();
    }

    public int[] getRowSelections() {
        JSet set = this.canv.getRowSelections();
        int[] res = new int[set.size()];
        Enumeration e = set.enumerate();
        int n = 0;
        while (e.hasMoreElements()) {
            int i = (Integer)e.nextElement();
            res[n++] = i;
        }
        return res;
    }

    public int getColSelection() {
        int[] i = this.getColSelections();
        if (i.length > 0) {
            return i[0];
        }
        return -1;
    }

    public int[] getColSelections() {
        return this.header.getIntSelectionsModel();
    }

    public Binder binderRowSelection() {
        return this.canv.binderRowSelection();
    }

    public Binder binderDoubleRowSelection() {
        return this.canv.binderDoubleRowSelection();
    }

    public Binder binderDoubleCellSelection() {
        return this.canv.binderDoubleCellSelection();
    }

    public Binder binderColSelection() {
        return this.header.binderColSelection();
    }

    public void stopEditing() {
        this.canv.stopEditing();
    }

    public void cancelEditing() {
        this.canv.cancelEditing();
    }

    void doEdit(int viewX, int viewY) {
        this.canv.doEdit(viewX, viewY);
    }

    public JTableModel getModel() {
        return this.model;
    }

    public void setModelSameHeader(JTableModel newM) {
        this.stopEditing();
        if (this.model == null) {
            this.setModel(newM);
            return;
        }
        this.model.binderModelChange().removeTarget(this, "actionModelChanged");
        this.canv.setModel(this.model);
        this.model.binderModelChange().addTarget(this, "actionModelChanged");
        this.repaint();
    }

    public void setModel(JTableModel newM) {
        this.stopEditing();
        if (this.model != null) {
            this.model.binderModelChange().removeTarget(this, "actionModelChanged");
        }
        this.model = newM;
        this.canv.setModel(this.model);
        this.model.binderModelChange().addTarget(this, "actionModelChanged");
        this.header.removeAllHeaders();
        int n = 0;
        while (n < this.model.dimX()) {
            int[] width = new int[]{50};
            String title = this.model.titleAt(n, width);
            this.addHeader(title, this.model.assocAt(n), n, width[0]);
            ++n;
        }
        this.repaint();
    }

    public void initWithModel(JTableModel tm) {
        this.model = tm;
        this.init();
        this.setModel(this.model);
        this.addFlags(ALLFLAGS);
    }

    public void initForBuilder() {
        this.model = new TestModel();
        this.init();
        this.setModel(this.model);
        this.addFlags(ALLFLAGS);
    }

    public void setSelection(int idx) {
        int oldidx = this.getRowSelection();
        this.canv.clearSelectionsQuiet();
        if (idx >= 0) {
            this.canv.addSelection(idx);
        }
        if (oldidx >= 0) {
            this.canv.repaintLines(oldidx, oldidx + 1);
        }
    }

    public void fitLastColumnToView(boolean force) {
        int actWidth = this.canv.getSize().width;
        int headWidth = this.header.preferredSize().width;
        if (actWidth < headWidth && !force) {
            return;
        }
        if (actWidth - headWidth + this.header.getSizeAt(this.model.dimX() - 1) > 0) {
            this.header.setSizeAt(this.model.dimX() - 1, actWidth - headWidth + this.header.getSizeAt(this.model.dimX() - 1));
        }
    }

    public void fitColumnsToView(int maxWidth) {
        int actWidth = this.canv.getSize().width;
        int headWidth = this.header.preferredSize().width;
        if (actWidth < headWidth) {
            return;
        }
        int n = 0;
        while (n < this.model.dimX()) {
            this.header.setSizeAt(n, Math.min(maxWidth, this.header.getSizeAt(n) * actWidth / headWidth));
            ++n;
        }
    }

    public void setHeaderMinWidth(int minWidth) {
        int n = 0;
        while (n < this.model.dimX()) {
            this.header.setSizeAt(n, Math.max(minWidth, this.header.getSizeAt(n)));
            ++n;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public static void main(String[] arg) {
        try {
            NCApplication.DocBase = new URL("file:/g:/j11/classes11/jwidgets");
            NCApplication.TK = Toolkit.getDefaultToolkit();
        }
        catch (Exception e) {
            // empty catch block
        }
        Frame f = new Frame();
        NCTableView tv = new NCTableView();
        f.setLayout(new BorderLayout());
        f.add("Center", tv);
        NCApplication.Pln("************************************+");
        tv.initForBuilder();
        f.pack();
        f.resize(640, 400);
        f.show();
    }
}

