/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.IVisual;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class VisualLayout
extends Canvas
implements IVisual {
    float[] fakx = new float[2];
    float[] faky = new float[2];
    int[] posx = new int[2];
    int[] posy = new int[2];
    IVisual[] visuals = new IVisual[2];
    Component parent;

    VisualLayout() {
    }

    public VisualLayout(Component par, IVisual vA, float _fakx, float _faky, IVisual vB, float _fak1x, float _fak1y) {
        this(par, vA, _fakx, _faky, vB, _fak1x, _fak1y, 2);
    }

    public VisualLayout(Component par, IVisual vA, float _fakx, float _faky, IVisual vB, float _fak1x, float _fak1y, int maxElem) {
        this.parent = par;
        this.fakx = new float[maxElem];
        this.faky = new float[maxElem];
        this.posx = new int[maxElem];
        this.posy = new int[maxElem];
        this.visuals = new IVisual[maxElem];
        this.visuals[0] = vA;
        this.visuals[1] = vB;
        this.fakx[0] = _fakx;
        this.faky[0] = _faky;
        this.fakx[1] = _fak1x;
        this.faky[1] = _fak1y;
    }

    public void update(Graphics g) {
        this.preferredSize();
        int n = 0;
        while (n < this.visuals.length) {
            g.translate(this.posx[n], this.posy[n]);
            this.visuals[n].paint(g, this.visuals[n].preferredSize().width, this.visuals[n].preferredSize().height);
            g.translate(-this.posx[n], -this.posy[n]);
            ++n;
        }
    }

    public void paint(Graphics g, int w, int h) {
        this.update(g);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public Dimension preferredSize() {
        Dimension ad = this.visuals[0].preferredSize();
        Dimension bd = this.visuals[1].preferredSize();
        int sizex = 0;
        int sizey = 0;
        this.posy[0] = 0;
        this.posx[0] = 0;
        int n = 1;
        while (n < this.visuals.length) {
            int i;
            int ihCenter = (int)((float)this.posy[0] + (float)ad.height * this.faky[0]);
            int iwCenter = (int)((float)this.posx[0] + (float)ad.width * this.fakx[0]);
            this.posx[n] = iwCenter - (int)((float)bd.width * this.fakx[n]);
            this.posy[n] = ihCenter - (int)((float)bd.height * this.faky[n]);
            if (this.posx[n] < 0) {
                i = 0;
                while (i < n) {
                    int n2 = i++;
                    this.posx[n2] = this.posx[n2] - this.posx[n];
                }
                this.posx[n] = 0;
            }
            if (this.posy[n] < 0) {
                i = 0;
                while (i < n) {
                    int n3 = i++;
                    this.posy[n3] = this.posy[n3] - this.posy[n];
                }
                this.posy[n] = 0;
            }
            sizex = Math.max(this.posx[n] + bd.width, this.posx[0] + (int)((float)iwCenter / this.fakx[0]));
            sizey = Math.max(this.posy[n] + bd.height, this.posy[0] + (int)((float)ihCenter / this.faky[0]));
            ++n;
        }
        return new Dimension(sizex, sizey);
    }

    public IVisual visualAt(int i) {
        return this.visuals[i];
    }

    public void visualPut(int i, IVisual v) {
        this.visuals[i] = v;
    }

    public IVisual clone(String s) {
        VisualLayout v = null;
        v = new VisualLayout();
        v.visuals = new IVisual[this.visuals.length];
        int n = 0;
        while (n < this.visuals.length) {
            v.visuals[n] = this.visuals[n].clone(s);
            ++n;
        }
        v.parent = this.parent;
        v.fakx = this.fakx;
        v.faky = this.faky;
        v.posx = this.posx;
        v.posy = this.posy;
        return v;
    }
}

