/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import JWVFile.VFile;
import Jack.InputObject;
import Jxe.AttributedTextLine;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.io.File;
import java.util.Vector;
import netcomputing.tools.INCPrintOut;

public class PackageReplacer
extends SyntaxAnalyzer {
    public void replacePackages(String sourceRoot, String outputDir, Vector files, Vector packages, Vector newPackages, INCPrintOut out) throws Exception {
        sourceRoot = VFile.StripDoubleSeps(sourceRoot, File.separatorChar).toString();
        outputDir = VFile.StripDoubleSeps(outputDir, File.separatorChar).toString();
        int n = 0;
        while (n < files.size()) {
            this.replacePackage(sourceRoot, outputDir, (File)files.elementAt(n), packages, newPackages, out);
            ++n;
        }
    }

    void replacePackage(String sourceRoot, String outputDir, File f, Vector packages, Vector newPackages, INCPrintOut out) throws Exception {
        if (!f.getName().endsWith(".gml") && f.getName().endsWith(".java")) {
            Tracer.This.println("REPLACE PACK:" + f.getAbsolutePath());
            Vector v = this.pureParse(f, false);
            if (v != null) {
                TextDocument doc = new TextDocument();
                doc.setFile(f);
                doc.load(f);
                this.replacePackRecursive(doc, packages, newPackages, out, (InputObject)v.elementAt(0));
                String normalizedIn = VFile.StripDoubleSeps(f.getAbsolutePath(), File.separatorChar).toString();
                String pack = DocumentStream.ScanPackage(doc);
                pack = pack.replace('.', File.separatorChar);
                String outfi = outputDir + File.separator + pack + File.separator + f.getName();
                File oFil = new File(outfi);
                new File(oFil.getParent()).mkdirs();
                doc.save(oFil);
            } else if (out != null) {
                out.printLine("ERROR: could not parse " + f.getAbsolutePath() + " (not modified, copied)");
            }
        }
    }

    int findPackIndex(String packageName, Vector packages, Vector newPack) {
        packageName = packageName + packageName;
        int n = 0;
        while (n < packages.size()) {
            if (packageName.startsWith(packages.elementAt(n).toString())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    String replacePackLine(String bruttoPack, String line, Vector packages, Vector newPack) {
        String nettoPack = NCStringUtilities.GetLastStringComplement(".", bruttoPack);
        int i = this.findPackIndex(nettoPack, packages, newPack);
        if (i >= 0) {
            Tracer.This.println("REPLACING IN:" + line);
            Tracer.This.println("  BRUTTO    :" + bruttoPack);
            return NCStringUtilities.Replace(line, packages.elementAt(i).toString(), newPack.elementAt(i).toString());
        }
        return line;
    }

    void replacePackRecursive(TextDocument doc, Vector packages, Vector newPackages, INCPrintOut out, InputObject act) {
        switch (act.getIntVal()) {
            case 65601: {
                InputObject packName = act.getContent()[1];
                String name = packName.toString() + ".*";
                int col = packName.colPosition();
                int line = packName.linePosition();
                doc.setLine(line, new AttributedTextLine(this.replacePackLine(name, doc.lineAt(line).toString(), packages, newPackages)));
                break;
            }
            case 65600: {
                InputObject packName = act.getContent()[1];
                String name = packName.toString();
                if (act.toString().indexOf(".*") >= 0) {
                    name = name + ".*";
                }
                int col = packName.colPosition();
                int line = packName.linePosition();
                doc.setLine(line, new AttributedTextLine(this.replacePackLine(name, doc.lineAt(line).toString(), packages, newPackages)));
                break;
            }
            case 65630: {
                InputObject[] obj = act.getContent();
                StringBuffer currentDef = new StringBuffer(200);
                int lastLength = 0;
                int n = 0;
                while (n < obj.length) {
                    if (obj[n].getIntVal() != 65563) {
                        if (obj[n].getIntVal() == 65589 || n == obj.length - 1) {
                            if (obj[n].getIntVal() == 65589) {
                                currentDef.setLength(lastLength);
                            }
                            String clname = currentDef.toString();
                            int line = obj[Math.max(0, n - 1)].linePosition();
                            doc.setLine(line, new AttributedTextLine(this.replacePackLine(clname, doc.lineAt(line).toString(), packages, newPackages)));
                            currentDef.setLength(0);
                        } else {
                            lastLength = currentDef.length();
                            currentDef.append(obj[n].toString());
                        }
                    }
                    ++n;
                }
                break;
            }
            case 65602: 
            case 65623: {
                InputObject packName = act;
                String name = act.toString();
                int col = packName.colPosition();
                int line = packName.linePosition();
                doc.setLine(line, new AttributedTextLine(this.replacePackLine(name, doc.lineAt(line).toString(), packages, newPackages)));
            }
            default: {
                InputObject[] obj = act.getContent();
                int n = 0;
                while (obj != null && n < obj.length) {
                    this.replacePackRecursive(doc, packages, newPackages, out, obj[n]);
                    ++n;
                }
                break block0;
            }
        }
    }
}

