/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import netcomputing.tools.INCPrintOut;

public class ProgStats {
    public int parseErrors = 0;
    public int classDefs = 0;
    public int anonymClassDefs = 0;
    public int statements = 0;
    public int forLoop = 0;
    public int whileLoop = 0;
    public int doLoop = 0;
    public int ifStat = 0;
    public int newCall = 0;
    public int methCall = 0;
    public int methDef = 0;
    public int constrDef = 0;
    public int instanceOf = 0;

    public static String rd4(double d) {
        String res = "" + d;
        int i = res.lastIndexOf(".");
        if (res.equals("NaN")) {
            return res;
        }
        if (i < 0) {
            return res + ".0000";
        }
        int miss = res.length() - i;
        while (miss < 5) {
            res = res + "0";
            ++miss;
        }
        miss = res.length() - i;
        while (miss > 5) {
            res = res.substring(0, res.length() - 1);
            --miss;
        }
        return res;
    }

    public void dump() {
        System.out.println("parseErros =" + this.parseErrors);
        System.out.println("classDefs =" + this.classDefs);
        System.out.println("anonymClassDefs = " + this.anonymClassDefs);
        System.out.println("statements = " + this.statements);
        System.out.println("forLoop = " + this.forLoop);
        System.out.println("whileLoop = " + this.whileLoop);
        System.out.println("doLoop = " + this.doLoop);
        System.out.println("ifStat = " + this.ifStat);
        System.out.println("newCall = " + this.newCall);
        System.out.println("methCall = " + this.methCall);
        System.out.println("methDef = " + this.methDef);
        System.out.println("constrDef = " + this.constrDef);
    }

    public float percNew() {
        return (float)this.newCall / (float)this.statements * 100.0f;
    }

    public float iofPerStat() {
        return (float)this.instanceOf / (float)this.statements;
    }

    public float mtdCallPerStat() {
        return (float)this.methCall / (float)this.statements;
    }

    public float statPerMtd() {
        return (float)this.statements / (float)(this.constrDef + this.methDef);
    }

    public float statPerCls() {
        return (float)this.statements / (float)this.classDefs;
    }

    public float percLoop() {
        return (float)(this.forLoop + this.whileLoop + this.doLoop) / (float)this.statements * 100.0f;
    }

    public float percIf() {
        return (float)this.ifStat / (float)this.statements * 100.0f;
    }

    public void dump(INCPrintOut out) {
        out.printLine("========================================================================");
        out.printLine("Parse Errors        = " + this.parseErrors);
        out.printLine("Classes             = " + this.classDefs);
        out.printLine("Statements (LOC)    = " + this.statements);
        out.printLine("For Loops           = " + this.forLoop);
        out.printLine("While Loops         = " + this.whileLoop);
        out.printLine("Do Loops            = " + this.doLoop);
        out.printLine("If Statements       = " + this.ifStat);
        out.printLine("Calls of 'new XY()' = " + this.newCall);
        out.printLine("Method Calls        = " + this.methCall);
        out.printLine("Methods             = " + this.methDef);
        out.printLine("Constructors        = " + this.constrDef);
        out.printLine("Uses of instanceof  = " + this.instanceOf);
        out.printLine("");
        out.printLine("Percentage values:");
        out.printLine("New Statements  : " + this.percNew() + "%");
        out.printLine("If Statements   : " + this.percIf() + "%");
        out.printLine("Loop Statements : " + this.percLoop() + "%");
        out.printLine("");
        out.printLine("Misc values:");
        out.printLine("AVG Lines/Class : " + this.statPerCls());
        out.printLine("AVG Lines/Method: " + this.statPerMtd());
        out.printLine("AVG MethodCalls per Statement: " + this.mtdCallPerStat());
        out.printLine("AVG InstanceOf per Statement : " + this.iofPerStat());
        out.printLine("");
    }
}

