/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import JCollections.DirIterator;
import Jack.InputObject;
import de.netcomputing.anyj.parsing.ProgStats;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class StatBuilder
extends SyntaxAnalyzer {
    public TreeMap buildModuleStats(String pathOfDirs) {
        TreeMap<String, ProgStats> result = new TreeMap<String, ProgStats>();
        HashSet hSet = DirIterator.DirContent(pathOfDirs, "none");
        Iterator it = hSet.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            ProgStats pStats = new ProgStats();
            Vector files = DirIterator.DirContent(f, ".java", false);
            if (files.size() <= 0) continue;
            int i = 0;
            while (i < files.size()) {
                this.buildStats((File)files.get(i), pStats);
                ++i;
            }
            result.put(f.getAbsolutePath(), pStats);
        }
        return result;
    }

    public ProgStats buildStats(String pathOfDirs) {
        ProgStats pStats = new ProgStats();
        HashSet hSet = DirIterator.DirContent(pathOfDirs, ".java");
        Iterator it = hSet.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            this.buildStats(f, pStats);
        }
        return pStats;
    }

    protected void buildStats(File file2, ProgStats pStats) {
        Vector v = null;
        try {
            v = this.pureParse(EditApp.App.getStreamFor(file2), false, true);
            this.treeWalk((InputObject)v.get(0), null, -1, pStats);
        }
        catch (Throwable ex) {
            ex.printStackTrace(Tracer.This);
            if (ex instanceof OutOfMemoryError) {
                EditApp.App.outOfMemWarning();
            }
            v = null;
            ++pStats.parseErrors;
        }
    }

    private void treeWalk(InputObject act, InputObject parent, int parentIndex, ProgStats pStats) {
        switch (act.getIntVal()) {
            case 65607: {
                ++pStats.classDefs;
                break;
            }
            case 40000: {
                ++pStats.anonymClassDefs;
                break;
            }
            case 65632: {
                ++pStats.statements;
                break;
            }
            case 65569: {
                ++pStats.forLoop;
                break;
            }
            case 65565: {
                ++pStats.whileLoop;
                break;
            }
            case 65575: {
                ++pStats.doLoop;
                break;
            }
            case 65576: {
                ++pStats.ifStat;
                break;
            }
            case 65570: {
                ++pStats.newCall;
                break;
            }
            case 65617: {
                ++pStats.methCall;
                break;
            }
            case 65628: {
                ++pStats.constrDef;
                break;
            }
            case 65629: {
                ++pStats.methDef;
                break;
            }
            case 65539: {
                ++pStats.instanceOf;
            }
        }
        InputObject[] obj = act.getContent();
        int n = 0;
        while (obj != null && n < obj.length) {
            this.treeWalk(obj[n], act, n, pStats);
            ++n;
        }
    }
}

