/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import JWVFile.VFile;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.AJWorkspaceNursery;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.parsing.ProgStats;
import de.netcomputing.anyj.parsing.StatBuilder;
import de.netcomputing.anyj.services.WorkspaceContext;
import de.netcomputing.installer.AJUpdatePanel;
import de.netcomputing.templates.engine.TemplateExecutor;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.util.TreeMap;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Executor;
import netcomputing.tools.INCExtendedPrintout;
import netcomputing.tools.INCPrintOut;

public class AJWorkSpaceServices {
    static AJWorkSpaceServices This = new AJWorkSpaceServices();
    String lastAntBuild = "/";

    public static AJWorkSpaceServices This() {
        return This;
    }

    public void RegisterServices() {
        JEBasicService ser = new JEBasicService("Workspace", "Check Workspace Settings", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJWorkspaceNursery.Open();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Ant", "Generate Ant build.xml File in Selected Dir", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory();
            }

            public void doProcess(Object selection, Object selector) {
                AJWorkSpaceServices.This().generateAntFile((File)selection);
                EditApp.App.updateDirTree();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("File", "Update AnyJ from the Internet", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJUpdatePanel.Open();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Ant", "Setup Ant Home", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                File f;
                String initial = EditApp.App.getMergedUserProperty("anthome");
                if (initial == null) {
                    initial = VFile.ResolveName("#jxebase/lib");
                }
                if ((f = AJDirSelector.SelectDirModal(EditApp.App.getMainWindow(), null, "Please select Ant 1.5 Home", null, initial)) != null) {
                    EditApp.App.getOptions().putUserProp("anthome", f.getAbsolutePath());
                    if (!f.exists()) {
                        Confirm.ModalMsg("File does not exist", "Please select a valid Ant home");
                    }
                }
            }
        };
        EditApp.ServReg.addService(ser);
        final JEBasicService runantser = new JEBasicService("Ant", "Run Ant in selected Dir", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory() && new File((File)selection, "build.xml").exists();
            }

            public void doProcess(Object selection, Object selector) {
                AJWorkSpaceServices.this.runAnt(selection);
            }
        };
        EditApp.ServReg.addService(runantser);
        ser = new JEBasicService("Ant", "Run With Ant", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).getName().equals("build.xml");
            }

            public void doProcess(Object selection, Object selector) {
                AJWorkSpaceServices.this.runAnt(((File)selection).getParentFile());
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Ant", "Rerun with least recently build.xml", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                runantser.doProcess(new File(AJWorkSpaceServices.this.lastAntBuild), this);
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("XMLExport", "Import Xml DTD", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                File s = AJDirSelector.SelectDirModal(EditApp.App.getMainWindow(), null, "Select a DTD File to add to [anyj]" + File.separator + "bin" + File.separator + "dtds", "", VFile.resolveName("#actproject"), ".dtd");
                if (s != null) {
                    try {
                        VFile.Copy(s, new VFile("#jxebase/bin/dtds/" + s.getName()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                        Confirm.MsgException(ex);
                    }
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Metrics", "Compute Metrics of Selected Dir", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory();
            }

            public void doProcess(Object selection, Object selector) {
                INCExtendedPrintout pout = JEBatchHostFrame.This().createOutput("Metrics");
                Thread t = new Thread(this, pout, selection){
                    private final /* synthetic */ INCExtendedPrintout val$pout;
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$pout = val$pout;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        this.val$pout.printLine("gathering data on " + ((File)this.val$selection).getAbsolutePath() + " ...");
                        StatBuilder sBuilder = new StatBuilder();
                        ProgStats pStats = sBuilder.buildStats(((File)this.val$selection).getAbsolutePath());
                        pStats.dump(this.val$pout);
                    }
                };
                t.setPriority(1);
                t.start();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Metrics", "Compute Per Package Metrics of Selected Dir", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory();
            }

            public void doProcess(Object selection, Object selector) {
                INCExtendedPrintout pout = JEBatchHostFrame.This().createOutput("Metrics");
                Thread t = new Thread(this, pout, selection){
                    private final /* synthetic */ INCExtendedPrintout val$pout;
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$pout = val$pout;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        this.val$pout.printLine("gathering data on " + ((File)this.val$selection).getAbsolutePath() + " ...");
                        StatBuilder sBuilder = new StatBuilder();
                        TreeMap res = sBuilder.buildModuleStats(((File)this.val$selection).getAbsolutePath());
                        this.val$pout.printLine("generating report ...");
                        11.access$000(this.this$1).generateMetricsFile(res, this.val$pout);
                        this.val$pout.printLine("finished");
                    }
                };
                t.setPriority(1);
                t.start();
            }

            static /* synthetic */ AJWorkSpaceServices access$000(11 x0) {
                return x0.AJWorkSpaceServices.this;
            }
        };
        EditApp.ServReg.addService(ser);
    }

    public void runAnt(Object selection) {
        String initial = EditApp.App.getMergedUserProperty("anthome");
        this.lastAntBuild = ((File)selection).getAbsolutePath();
        if (initial == null) {
            initial = VFile.ResolveName("#jxebase/lib");
        }
        if (!new File(initial, "lib" + File.separator + "ant.jar").exists()) {
            Confirm.ModalMsg("Wrong Ant Home", "Ant Home not set or wrong");
        }
        String cline = "($jdkhome)\\bin\\java -classpath ($Tools);($anthome)\\lib\\ant.jar;($anthome)\\lib\\xercesImpl.jar;($anthome)\\lib\\xml-apis.jar;($anthome)\\lib\\optional.jar -Dant.home=($anthome) org.apache.tools.ant.Main";
        cline = EditApp.App.insertEnvVars(cline, null);
        cline = cline.replace(';', File.pathSeparatorChar);
        cline = cline.replace('\\', File.separatorChar);
        INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("Ant");
        out.clear();
        out.printLine(cline);
        out.printLine("working dir:" + ((File)selection).getAbsolutePath());
        out.printLine("=============================================================================================");
        Executor.Exec(cline, ((File)selection).getAbsolutePath(), out);
    }

    public void generateMetricsFile(TreeMap data, INCPrintOut out) {
        try {
            String tmp = VFile.ResolveName("#process");
            TemplateExecutor exec = new TemplateExecutor(tmp);
            File outF = new File(tmp, "metrics" + (int)(Math.random() * 1000.0) + ".html");
            JEBatchHostFrame.This().createOutput("Metrics", false).printLine("Generating " + outF.getAbsolutePath());
            exec.setFiles(new VFile("#templates/engine/metricreport.jpl"), outF, data);
            exec.execute();
            EditApp.App.openBrowserOn(outF.getAbsolutePath());
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace(Tracer.This);
        }
    }

    public void generateAntFile(File base) {
        try {
            String tmp = VFile.ResolveName("#process");
            TemplateExecutor exec = new TemplateExecutor(tmp);
            File outF = new File(base, "build.xml");
            if (outF.exists() && !Confirm.ModalConfirm("File exists", new String[]{"File build.xml exists", "Overwrite ?"})) {
                return;
            }
            JEBatchHostFrame.This().createOutput("TExec", false).clear();
            JEBatchHostFrame.This().createOutput("TExec", false).printLine("Generating " + outF.getAbsolutePath());
            exec.setFiles(new VFile("#templates/engine/antfromworkspace.jpl"), outF, new WorkspaceContext(base));
            exec.execute();
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace(Tracer.This);
        }
    }
}

