/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import Jxe.TextDocument;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.io.File;

public class ServiceUtilities {
    public static boolean IsMethodOrFieldSelected(Object selection) {
        if (selection instanceof IndexEntry) {
            IndexEntry ie = (IndexEntry)selection;
            return (ie.isMethod() || ie.isField()) && !ie.isConstructor();
        }
        if (selection instanceof TextDocument) {
            TextDocument doc = (TextDocument)selection;
            return SourceBase.This().isMethodOrFieldIdentifier(doc.getSelectedString()) || SourceBase.This().isMethodOrFieldIdentifier(doc.getCurrentWordAsString());
        }
        return false;
    }

    public static boolean IsInstanceVarIdentifier(Object selection) {
        if (selection instanceof IndexEntry) {
            IndexEntry ie = (IndexEntry)selection;
            return ie.isField();
        }
        if (selection instanceof TextDocument) {
            TextDocument doc = (TextDocument)selection;
            boolean res = SourceBase.This().isInstanceVarIdentifier(doc.getSelectedString()) || SourceBase.This().isInstanceVarIdentifier(doc.getCurrentWordAsString());
            return res;
        }
        return false;
    }

    public static boolean IsWebAppHome(File f) {
        File tmpFile = new File(f, "ROOT");
        boolean tomcat = f.isDirectory() && "webapps".equals(f.getName()) && tmpFile.exists() && tmpFile.isDirectory();
        boolean bea = new File(f, "web_module.prp").exists();
        return tomcat || bea;
    }

    public static boolean IsModuleDeploy(File f) {
        return "deploy".equals(f.getName()) && (ServiceUtilities.IsEJBModule(f.getParentFile()) || ServiceUtilities.IsWebAppHome(f.getParentFile()));
    }

    public static boolean IsEJBModule(File f) {
        return new File(f, "ejb_module.prp").exists();
    }

    public static boolean IsWebApp(File f) {
        return f.getParentFile().getName().equals("webapps");
    }
}

