/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.beans.propedit;

import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.beans.propedit.PropTableModel;
import de.netcomputing.beans.propedit.PropertyTableGUI;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class PropertyTable
extends JPanel {
    JButton remBtn;
    JButton addBtn;
    JTable table;
    PropTableModel model;

    public PropertyTable() {
        this.initGui();
    }

    public void addTableModelListener(TableModelListener l) {
        this.model.addTableModelListener(l);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.model.removeTableModelListener(l);
    }

    public void initGui() {
        new PropertyTableGUI().createGui(this);
        this.model = new PropTableModel(new Vector(13), new Vector(13));
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertyTable.this.rowSelChanged(e);
            }
        });
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setBackground(JWColor.For("background"));
        this.table.getColumn("Key").setCellRenderer(renderer);
        this.table.getColumn("Value").setCellRenderer(renderer);
    }

    void rowSelChanged(ListSelectionEvent e) {
    }

    public void setHash(Dictionary dic) {
        this.model.keys.setSize(0);
        this.model.values.setSize(0);
        Enumeration en = dic.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            this.model.keys.addElement(key);
            this.model.values.addElement(dic.get(key));
        }
        this.table.setModel(this.model);
        this.model.fireChangeEvent();
    }

    public Vector getLeft() {
        return this.model.keys;
    }

    public Vector getRight() {
        return this.model.values;
    }

    public Dictionary getHash(Dictionary dic) {
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        try {
            this.table.setRowSelectionInterval(0, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        int n = 0;
        while (n < this.model.keys.size()) {
            dic.put(this.model.keys.elementAt(n), this.model.values.elementAt(n));
            ++n;
        }
        return dic;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public JTable getTable() {
        return this.table;
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        int n = 0;
        while (this.model.keys.contains("new" + n)) {
            ++n;
        }
        this.model.keys.addElement("new" + n);
        this.model.values.addElement("null");
        this.model.fireChangeEvent();
    }

    public void remBtn_actionPerformed(ActionEvent var0) {
        int i = this.table.getSelectedRow();
        if (i >= 0) {
            this.model.keys.removeElementAt(i);
            this.model.values.removeElementAt(i);
            this.model.fireChangeEvent();
        }
    }

    public static void main(String[] arg) {
        JFrame f = ApplicationHelper.Singleton().createFrameOn(new PropertyTable());
        f.show();
    }
}

