/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import JWVFile.VFile;
import de.netcomputing.cvswrap.commands.CVSCommand;
import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CheckoutWrapper
extends CVSCommand {
    Hashtable projects;
    String lastError = "";

    public CheckoutWrapper(String repository) {
        super(repository);
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean checkout(String projectName, String basedir, String tag, boolean sticky) {
        File tmp = CVSCommand.getTmpFile();
        int res = 0;
        String string = tag = tag == null ? "" : tag.trim();
        if (tag.length() > 1) {
            tag = "-r " + tag + " ";
        }
        try {
            new File(basedir).mkdirs();
            res = this.execute(VFile.RemoveLast(basedir), CVSCommand.CVS + "-d " + this.getRepositoryDir() + " " + CVSCommand.CHECKOUT + tag + (sticky ? "" : "-A ") + "-d " + basedir + " " + projectName, tmp.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public Vector getTags(String project) {
        File tmp = CVSCommand.getTmpFile();
        String cline = CVSCommand.CVS + "-d " + this.getRepositoryDir() + " " + CVSCommand.HISTORY + "-T -a -n " + project;
        int res = this.execute(".", cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            Vector v = new Vector(20);
            if (this.parseTagEntries(din, v) == null) {
                return v;
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public String parseTagEntries(DataInputStream din, Vector result) {
        try {
            String line = null;
            while ((line = din.readLine()) != null) {
                Tracer.This.println(line);
                if (!line.startsWith("T ")) {
                    return line;
                }
                int i = line.indexOf("[");
                Tracer.This.println(i);
                if (i < 0) continue;
                String name = line.substring(i + 1).trim();
                if ((i = name.indexOf(":")) > 0) {
                    name = name.substring(0, i);
                }
                result.addElement(name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Unexpected command Output, check output";
        }
        return null;
    }

    public Vector getProjects() {
        File tmp = CVSCommand.getTmpFile();
        String cline = CVSCommand.CVS + "-d " + this.getRepositoryDir() + " " + CVSCommand.HISTORY + "-a";
        this.projects = new Hashtable(31);
        int res = this.execute(".", cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (this.parseHistoryEntries(din, ".")) {
                Vector v = new Vector(this.projects.size());
                Enumeration en = this.projects.keys();
                while (en.hasMoreElements()) {
                    v.addElement(en.nextElement());
                }
                return v;
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public boolean parseHistoryEntries(DataInputStream din, String base) {
        try {
            this.projects = new Hashtable();
            String line = null;
            while ((line = din.readLine()) != null) {
                int i = line.indexOf("=");
                if (i < 0) continue;
                String name = line.substring(0, i - 1).trim();
                i = name.lastIndexOf(" ");
                name = name.substring(i + 1);
                Tracer.This.println("PROJECT:<" + name + ">");
                this.projects.put(name, Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

