/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import de.netcomputing.cvswrap.commands.CVSCommand;
import de.netcomputing.cvswrap.commands.UpdateWrapper;
import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class CommitWrapper
extends CVSCommand {
    Vector msg;
    Vector updated;
    Vector commited;
    boolean commitSuccessful;

    public CommitWrapper(String repository) {
        super(repository);
    }

    public boolean getCommitSuccessful() {
        return this.commitSuccessful;
    }

    public Vector getMsg() {
        return this.msg;
    }

    public Vector getUpdated() {
        return this.updated;
    }

    public Vector getCommited() {
        return this.commited;
    }

    public String runCommitAll(String wdir, String comment) {
        File tmp = CVSCommand.getTmpFile();
        this.commitSuccessful = true;
        String cline = CVSCommand.CVS + CVSCommand.COMMIT + "-m \"" + comment + "\"";
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseCommitEntries(din, wdir)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        return null;
    }

    String rename(Object[] absFiles) {
        String ending = "_" + (int)(Math.random() * 1000.0);
        int n = 0;
        while (n < absFiles.length) {
            new File(absFiles[n].toString()).renameTo(new File(absFiles[n].toString() + ending));
            if (!new File(absFiles[n].toString() + ending).exists()) {
                return null;
            }
            ++n;
        }
        return ending;
    }

    String rename(Object[] absFiles, String ending) {
        int n = 0;
        while (n < absFiles.length) {
            new File(absFiles[n].toString() + ending).renameTo(new File(absFiles[n].toString()));
            if (!new File(absFiles[n].toString() + ending).exists()) {
                return null;
            }
            ++n;
        }
        return ending;
    }

    boolean delete(Object[] absFiles) {
        int n = 0;
        while (n < absFiles.length) {
            new File(absFiles[n].toString()).delete();
            if (!new File(absFiles[n].toString()).exists()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String runCommit(String wdir, String comment, Object[] absFiles, boolean force) {
        File tmp = CVSCommand.getTmpFile();
        this.commitSuccessful = true;
        String ending = null;
        if (force) {
            ending = this.rename(absFiles);
            if (ending == null) {
                return "unable to temporary rename files, aborted";
            }
            UpdateWrapper wrap = new UpdateWrapper(null);
            String upres = wrap.runUpdate(wdir, absFiles);
            Tracer.This.println(upres);
            if (upres != null) {
                return "fatal: (simulated) update failed, original files end with:\"" + ending + "\"";
            }
        }
        String cline = CVSCommand.CVS + CVSCommand.COMMIT + "-m \"" + comment + "\"";
        while (wdir.endsWith(File.separator)) {
            wdir = wdir.substring(0, wdir.length() - 1);
        }
        int n = 0;
        while (n < absFiles.length) {
            cline = cline + " " + absFiles[n].toString().substring(Math.min(wdir.length() + 1, absFiles[n].toString().length()));
            ++n;
        }
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseCommitEntries(din, wdir)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        if (force) {
            boolean delRes = this.delete(absFiles);
            if (delRes) {
                return "fatal, unable to delete temporary updated files, aborted. Original files end with:\"" + ending + "\"";
            }
            String rren = this.rename(absFiles, ending);
            if (rren == null) {
                return "fatal: renaming failed, original files end with:\"" + ending + "\"";
            }
        }
        return null;
    }

    public boolean parseCommitEntries(DataInputStream din, String base) {
        try {
            String line = null;
            this.msg = new Vector();
            this.updated = new Vector();
            this.commited = new Vector();
            String prevLine = null;
            while ((line = din.readLine()) != null) {
                if (line.startsWith("cvs [commit aborted]: correct above errors first!")) {
                    this.commitSuccessful = false;
                    return true;
                }
                if (line.indexOf(" <-- ") >= 0) {
                    String m = "Commited " + line.substring(line.indexOf(" <-- ") + 5);
                    line = din.readLine();
                    m = m + " " + line.substring(line.indexOf("revision: ") + "revision: ".length());
                    this.msg.addElement(m);
                    String search = "Checking in ";
                    int i = prevLine.indexOf(search);
                    if (i < 0) {
                        search = "Removing ";
                        i = prevLine.indexOf(search);
                    }
                    if (i >= 0) {
                        m = prevLine.substring(i + search.length(), prevLine.length() - 1);
                        m = m.replace('/', File.separatorChar);
                        m = base + File.separator + m;
                        this.commited.addElement(m);
                    } else {
                        Tracer.This.println("APSODKASPDOKAPSDOKAPSODKAPSODKAPSDOKAPSDOKAPSDOK unexpected output");
                    }
                } else if (line.indexOf("Up-to-date check failed for `") >= 0) {
                    int i = line.indexOf("Up-to-date check failed for `");
                    String nam = line.substring(i + "Up-to-date check failed for `".length(), line.trim().length() - 1);
                    nam = nam.replace('/', File.separatorChar);
                    nam = base + File.separator + nam;
                    this.updated.addElement(nam);
                }
                prevLine = line;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

