/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import JWVFile.VVolume;
import de.netcomputing.cvswrap.commands.CVSCommand;
import de.netcomputing.cvswrap.commands.LogEntry;
import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class StatusWrapper
extends CVSCommand {
    Vector logEntries;

    public StatusWrapper(String repository) {
        super(repository);
    }

    public String runLog(String wdir, String file2) {
        File tmp = CVSCommand.getTmpFile();
        if (new File(wdir, file2).isDirectory()) {
            return "not applicable to directories";
        }
        if (this.execute(wdir, CVSCommand.CVS + CVSCommand.LOG + file2, tmp.getAbsolutePath()) != 0) {
            return "unable to execute cvs log " + file2;
        }
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseLog(din)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of cvs log " + file2;
        }
        return null;
    }

    public Vector getLogEntries() {
        return this.logEntries;
    }

    public boolean parseLog(DataInputStream din) throws Exception {
        String line = null;
        LogEntry act = null;
        this.logEntries = new Vector();
        boolean appendDescr = false;
        Hashtable<String, String> symbolics = new Hashtable<String, String>(31);
        block0: while ((line = din.readLine()) != null) {
            if (line.startsWith("symbolic names:")) {
                while (!(line = din.readLine()).startsWith("--") && !line.startsWith("keyword ")) {
                    line = line.trim();
                    Tracer.This.println(line);
                    int i = line.indexOf(":");
                    if (i < 0 || i + 2 >= line.length()) continue block0;
                    String label = line.substring(0, i);
                    String version = line.substring(i + 2);
                    String prev = (String)symbolics.get(version);
                    if (prev == null) {
                        symbolics.put(version, label);
                        continue;
                    }
                    symbolics.put(version, prev + "," + label);
                }
                continue;
            }
            if (line.equals("----------------------------")) {
                boolean head = act == null;
                act = new LogEntry();
                act.setIsHeader(head);
                this.logEntries.addElement(act);
                line = din.readLine();
                String revision = null;
                revision = line.substring(line.indexOf("revision ") + 9);
                act.setRevision(revision);
                line = din.readLine();
                act.setDate(line.substring(line.indexOf("date: ") + 6, line.indexOf(";")));
                line = line.substring(line.indexOf("author: "));
                act.setAuthor(line.substring(8, line.indexOf(";")));
                int i = line.indexOf("lines: ");
                if (i >= 0) {
                    line = line.substring(i + 7);
                    act.setLines(line);
                }
                act.setDescr(din.readLine());
                String tag = (String)symbolics.get(revision);
                if (tag != null) {
                    act.setTag(tag);
                }
                appendDescr = true;
                continue;
            }
            if (!appendDescr || line.startsWith("=======================================")) continue;
            act.setDescr(act.getDescr() + " ; " + line);
        }
        if (act != null) {
            act.setDescr("Initial revision");
            act.setLines("");
        }
        return true;
    }

    public void dumpLog() {
        int n = 0;
        while (n < this.logEntries.size()) {
            LogEntry ent = (LogEntry)this.logEntries.elementAt(n);
            Tracer.This.println("======" + ent.getIsHeader());
            Tracer.This.println("Rev:" + ent.getRevision());
            Tracer.This.println("Dat:" + ent.getDate());
            Tracer.This.println("Des:" + ent.getDescr());
            Tracer.This.println("Aut:" + ent.getAuthor());
            Tracer.This.println("Cha:" + ent.getLines());
            ++n;
        }
    }

    public static void main(String[] args) {
        StatusWrapper wrapper = new StatusWrapper("\\\\MARS\\D\\cvsroot");
        VVolume.New("process", "c:\\temp");
        Tracer.This.println(wrapper.runLog("D:\\work\\anyj\\source\\plugins", "JavacPlugin.java"));
        Vector logEntries = wrapper.logEntries;
        int n = 0;
        while (n < logEntries.size()) {
            LogEntry ent = (LogEntry)logEntries.elementAt(n);
            Tracer.This.println("======" + ent.getIsHeader());
            Tracer.This.println("Rev:" + ent.getRevision());
            Tracer.This.println("Dat:" + ent.getDate());
            Tracer.This.println("Des:" + ent.getDescr());
            Tracer.This.println("Aut:" + ent.getAuthor());
            Tracer.This.println("Cha:" + ent.getLines());
            ++n;
        }
    }
}

