/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import de.netcomputing.cvswrap.commands.CVSCommand;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class UpdateWrapper
extends CVSCommand {
    Vector unknown;
    Vector modified;
    Vector conflicts;
    Vector updated;

    public UpdateWrapper(String repository) {
        super(repository);
    }

    public Vector getUpdated() {
        return this.updated;
    }

    public Vector getUnknown() {
        return this.unknown;
    }

    public Vector getModified() {
        return this.modified;
    }

    public Vector getConflicts() {
        return this.conflicts;
    }

    public String runUpdate(String wdir, Object[] absFiles) {
        return this.runUpdate(wdir, absFiles, false);
    }

    public String runUpdate(String wdir, Object[] absFiles, boolean simulate) {
        File tmp = CVSCommand.getTmpFile();
        this.unknown = new Vector();
        this.modified = new Vector();
        this.conflicts = new Vector();
        this.updated = new Vector();
        String opt = simulate ? "-n " : "";
        String cline = CVSCommand.CVS + opt + CVSCommand.UPDATE + "-d ";
        while (wdir.endsWith(File.separator)) {
            wdir = wdir.substring(0, wdir.length() - 1);
        }
        int n = 0;
        while (n < absFiles.length) {
            String tmpString = absFiles[n].toString();
            cline = cline + " " + tmpString.substring(Math.min(wdir.length() + 1, tmpString.length()));
            ++n;
        }
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseUpdateEntries(din, wdir)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        return null;
    }

    public String runUpdate(String wdir, boolean noOp, String actfile) {
        File tmp = CVSCommand.getTmpFile();
        this.unknown = new Vector();
        this.modified = new Vector();
        this.conflicts = new Vector();
        this.updated = new Vector();
        String opt = noOp ? "-n " : "";
        String cline = null;
        actfile = actfile == null ? "" : actfile;
        cline = CVSCommand.CVS + opt + CVSCommand.UPDATE + "-d -P " + actfile;
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseUpdateEntries(din, wdir)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        return null;
    }

    public boolean parseUpdateEntries(DataInputStream din, String base) {
        try {
            String line = null;
            String lastLine = "";
            while ((line = din.readLine()) != null) {
                line = line.replace('/', File.separatorChar);
                boolean cont = false;
                int i = 0;
                do {
                    cont = false;
                    if (line.startsWith("A ")) {
                        this.unknown.addElement("(scheduled for add) " + base + File.separator + line.substring(2));
                        continue;
                    }
                    if (line.indexOf(": New directory ") >= 0) {
                        String dir = line.substring(line.indexOf(": New directory ") + 17);
                        dir = dir.substring(0, dir.indexOf(39));
                        this.updated.add("[new folder in repository] " + base + File.separator + dir);
                        continue;
                    }
                    if (line.startsWith("U ") || line.startsWith("P ")) {
                        this.updated.addElement(base + File.separator + line.substring(2));
                        continue;
                    }
                    if (line.startsWith("? ")) {
                        this.unknown.addElement(base + File.separator + line.substring(2));
                        continue;
                    }
                    if (line.indexOf(" is not (any longer) pertinent") >= 0) {
                        line = line.substring(0, line.length() - " is not (any longer) pertinent".length());
                        this.unknown.addElement("[removed in repository] " + base + File.separator + line.substring("cvs update: warning: ".length()));
                        continue;
                    }
                    if (line.startsWith("M ") && !lastLine.startsWith("Merging")) {
                        this.modified.addElement(base + File.separator + line.substring(2));
                        continue;
                    }
                    if (line.startsWith("C ") || line.startsWith("M ") && lastLine.startsWith("Merging")) {
                        this.conflicts.addElement(base + File.separator + line.substring(2));
                        continue;
                    }
                    if (line.startsWith("R ")) {
                        this.unknown.addElement("(scheduled for rem) " + base + File.separator + line.substring(2));
                        continue;
                    }
                    i = line.indexOf("M ");
                    if (i < 0 && (i = line.indexOf("U ")) < 0 && (i = line.indexOf("R ")) < 0 && (i = line.indexOf("C ")) < 0 && (i = line.indexOf("? ")) < 0 && (i = line.indexOf("A ")) < 0) continue;
                    line = line.substring(i);
                    cont = true;
                } while (cont);
                lastLine = line;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

