/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.database.DBCreateConnectionGUI;
import de.netcomputing.database.DBRootNode;
import de.netcomputing.propertystore.beans.PathEditorBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCProperties;
import de.netcomputing.util.Tracer;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import netcomputing.beans.NCClassloader;

public class DBCreateConnection
extends JPanel {
    public static HashMap DriverToInstance = new HashMap();
    PathEditorBean driverJar;
    JTextField dbUrlTxt;
    NCButton cancelBtn;
    NCButton applyBtn;
    JTextField userTxt;
    JPasswordField pwdTxt;
    JTextField driverNameTxt;
    public boolean result = false;
    public DBRootNode dbRoot;

    public static Connection Connect(NCClassloader loader, String cp, String dbDriver, String user, String pwd, String dbName) throws Exception {
        loader.setClassPath(NCFileUtilities.GetPathAsVector(cp));
        Driver dr = (Driver)DriverToInstance.get(dbDriver);
        if (dr == null) {
            dr = (Driver)Class.forName(dbDriver, false, loader).newInstance();
            DriverToInstance.put(dbDriver, dr);
        }
        NCProperties prps = new NCProperties();
        prps.put("user", user);
        prps.put("password", pwd);
        return dr.connect(dbName, prps);
    }

    public static DBCreateConnection Open(Frame par) {
        return DBCreateConnection.Open(par, null);
    }

    public static DBCreateConnection Open(Frame par, DBRootNode node) {
        JDialog dg = new JDialog(par, "New Connection", true);
        DBCreateConnection dbc = new DBCreateConnection();
        dg.getContentPane().add(dbc);
        dg.pack();
        try {
            JWidgetsUtil.CenterWindow((Window)dg, par);
        }
        catch (Exception ex) {
            // empty catch block
        }
        dbc.getRootPane().setDefaultButton(dbc.applyBtn);
        if (node != null) {
            dbc.init(node);
        }
        dg.setDefaultCloseOperation(2);
        dg.show();
        if (dbc.result) {
            return dbc;
        }
        return null;
    }

    public DBCreateConnection() {
        this.initGui();
        this.dbUrlTxt.setText("jdbc:db2:sample");
        this.driverJar.setText("e:\\Programme\\SQLLIB\\java\\db2java.zip");
        this.driverNameTxt.setText("COM.ibm.db2.jdbc.app.DB2Driver");
    }

    public void initGui() {
        new DBCreateConnectionGUI().createGui(this);
    }

    public void init(DBRootNode node) {
        this.driverJar.setText(node.getClassPath());
        this.dbUrlTxt.setText(node.getDbName());
        this.driverNameTxt.setText(node.getDbDriver());
        this.pwdTxt.setText(node.getPwd());
        this.userTxt.setText(node.getUser());
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        NCClassloader loader = new NCClassloader();
        Vector v = NCFileUtilities.GetPathAsVector(this.driverJar.getText());
        loader.setClassPath(v);
        try {
            Connection con = null;
            try {
                con = DriverManager.getConnection(this.dbUrlTxt.getText(), this.userTxt.getText(), this.pwdTxt.getText());
            }
            catch (SQLException ex) {
                Tracer.This.println(ex);
            }
            if (con == null) {
                Driver dr = (Driver)DriverToInstance.get(this.driverNameTxt.getText());
                if (dr == null) {
                    dr = (Driver)Class.forName(this.driverNameTxt.getText(), true, loader).newInstance();
                    DriverToInstance.put(this.driverNameTxt.getText(), dr);
                }
                NCProperties prps = new NCProperties();
                prps.put("user", this.userTxt.getText());
                prps.put("password", this.pwdTxt.getText());
                con = dr.connect(this.dbUrlTxt.getText(), prps);
            }
            if (con == null) {
                throw new RuntimeException("Null connection returned");
            }
            con.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
            return;
        }
        this.result = true;
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public static void main(String[] args) {
        DBCreateConnection.Open(new JFrame());
    }
}

