/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.IPropertyStorer;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.application.services.NCCustomPopupGetter;
import de.netcomputing.database.DBCreateConnection;
import de.netcomputing.database.DBExplorerGUI;
import de.netcomputing.database.DBQueryNode;
import de.netcomputing.database.DBRootNode;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import netcomputing.tools.PropWriter;

public class DBExplorer
extends NCPanel
implements IPropertyStorer {
    JButton cutBtn;
    JButton connectBtn;
    NCTreeBean listPanel;
    public static DBExplorer This;

    public DBExplorer() {
        this.initGui();
        this.listPanel.binder().addTarget(this, "actionListSel");
        this.listPanel.setPopUpGetter(new NCCustomPopupGetter(EditApp.App.getServReg(), new String[]{"Database"}));
        this.cutBtn.setEnabled(false);
        This = this;
    }

    public Object actionListSel(Object a, Object s) {
        this.cutBtn.setEnabled(this.listPanel.getSelectedItem() instanceof DBRootNode);
        return null;
    }

    public void update() {
        this.listPanel.collapseAndExpandAll();
    }

    public void initGui() {
        new DBExplorerGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void connectBtn_actionPerformed(ActionEvent var0) {
        DBCreateConnection dbc;
        DBRootNode root = null;
        if (this.listPanel.getSelectedItem() instanceof DBRootNode) {
            root = (DBRootNode)this.listPanel.getSelectedItem();
        }
        if ((dbc = DBCreateConnection.Open(EditApp.App.getMainWindow(), root)) != null) {
            DBRootNode dbRoot = new DBRootNode();
            dbRoot.setDbDriver(dbc.driverNameTxt.getText());
            dbRoot.setClassPath(dbc.driverJar.getText());
            dbRoot.setDbName(dbc.dbUrlTxt.getText());
            dbRoot.setPwd(dbc.pwdTxt.getText());
            dbRoot.setUser(dbc.userTxt.getText());
            this.listPanel.addItemRepainting(dbRoot);
        }
    }

    public void cutBtn_actionPerformed(ActionEvent var0) {
        DBRootNode dbr = (DBRootNode)this.listPanel.getSelectedItem();
        try {
            if (dbr.connection != null) {
                dbr.connection.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        int startD = this.listPanel.getSelectedItem().getDepth();
        this.listPanel.remSelection();
        while (this.listPanel.getSelectedItem() != null && this.listPanel.getSelectedItem().getDepth() > startD) {
            this.listPanel.remSelection();
        }
    }

    public void storeProperty(PropWriter o) throws Exception {
        DataOutputStream out = o.createStream("DBExplorer");
        this.listPanel.collapseAll();
        out.writeInt(this.listPanel.listSize());
        int i = 0;
        while (i < this.listPanel.listSize()) {
            DBRootNode node = (DBRootNode)this.listPanel.at(i);
            out.writeUTF(node.getClassPath());
            out.writeUTF(node.getDbDriver());
            out.writeUTF(node.getDbName());
            out.writeUTF(node.getUser());
            out.writeUTF(node.getPwd());
            out.writeUTF("SEPARATOR");
            ++i;
        }
        int i2 = 0;
        while (i2 < this.listPanel.listSize()) {
            DBRootNode node = (DBRootNode)this.listPanel.at(i2);
            ArrayList l = node.getQueries();
            out.writeInt(l.size());
            int ii = 0;
            while (ii < l.size()) {
                DBQueryNode qn = (DBQueryNode)l.get(ii);
                out.writeUTF(qn.getQuery());
                out.writeUTF(qn.getName());
                out.writeUTF("separator");
                ++ii;
            }
            ++i2;
        }
    }

    public void loadProperty(PropWriter o) throws Exception {
        DataInputStream in = o.getStream("DBExplorer");
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            DBRootNode node = new DBRootNode();
            node.setClassPath(in.readUTF());
            node.setDbDriver(in.readUTF());
            node.setDbName(in.readUTF());
            node.setUser(in.readUTF());
            node.setPwd(in.readUTF());
            this.listPanel.addItem(node);
            in.readUTF();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.listPanel.listSize()) {
            DBRootNode node = (DBRootNode)this.listPanel.at(i2);
            int len = in.readInt();
            int ii = 0;
            while (ii < len) {
                String st = in.readUTF();
                String na = in.readUTF();
                String sep = in.readUTF();
                node.addQuery(new DBQueryNode(node, st, na));
                ++ii;
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        DBExplorer dbEx = new DBExplorer();
        f.getContentPane().add(dbEx);
        f.pack();
        f.show();
    }
}

