/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.database.BasicDBNode;
import de.netcomputing.database.DBRootNode;
import de.netcomputing.database.TableColumnNode;
import de.netcomputing.util.Tracer;
import java.awt.Image;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class TableNode
extends BasicDBNode {
    String tableName = "UNKNOWN";
    String schema = null;
    String type = null;
    DBRootNode root;
    IListItem[] cont;
    Image img;

    public TableNode(DBRootNode root, Connection con) {
        super(con);
        this.root = root;
    }

    public DBRootNode getRoot() {
        return this.root;
    }

    public void initFrom(ResultSet rs) {
        try {
            this.tableName = rs.getString("TABLE_NAME");
            this.schema = rs.getString("TABLE_SCHEM");
            this.type = rs.getString("TABLE_TYPE");
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    void retrieveAttributes() throws SQLException {
        Statement st = this.connection.createStatement();
        boolean b = false;
        st.setMaxRows(2);
        if (this.schema == null || this.schema.length() == 0) {
            st.execute("SELECT * FROM " + this.tableName);
        } else {
            st.execute("SELECT * FROM " + this.schema + "." + this.tableName);
        }
        ResultSet rs = st.getResultSet();
        ResultSetMetaData md = rs.getMetaData();
        this.cont = new IListItem[md.getColumnCount()];
        int i = 1;
        while (i <= md.getColumnCount()) {
            String name = md.getColumnName(i);
            String type = md.getColumnTypeName(i);
            this.cont[i - 1] = new TableColumnNode(this.connection, name, md, i);
            ++i;
        }
        rs.close();
    }

    public IListItem[] contents() {
        if (this.cont == null) {
            try {
                this.retrieveAttributes();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Confirm.MsgException(ex);
            }
        }
        return this.cont;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        if (this.schema == null) {
            return "";
        }
        return this.schema;
    }

    public String getType() {
        if (this.type == null) {
            return "";
        }
        return this.type;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDisplayString() {
        return this.tableName;
    }

    public Image getImage() {
        if (this.img == null) {
            this.img = NCApplication.GetImage("/de/netcomputing/database/images/table.gif");
        }
        return this.img;
    }
}

