/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database.metadata;

import de.netcomputing.database.metadata.DBMetaData;
import de.netcomputing.database.metadata.DBTableMetaData;
import de.netcomputing.util.NCProperties;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class DBGenerationContext {
    Connection connection;
    DBMetaData dbMetaData;
    DBTableMetaData currentTable;
    Properties currentProps;
    File templateDir;
    String resultFileName;
    String driver;
    String url;
    String user;
    String pwd;
    String classPath;
    HashMap tabToProps = new HashMap();

    public DBGenerationContext(Connection con, File tplDir, DBMetaData dbMeta) {
        this.connection = con;
        this.dbMetaData = dbMeta;
        this.templateDir = tplDir;
    }

    public void setConnectInfo(String driver, String url, String user, String pwd, String classPath) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        this.classPath = classPath;
    }

    public Properties getTableProps(String tableName) {
        if (this.tabToProps.get(tableName) == null) {
            try {
                File tabPropFile = new File(this.getTemplateDir() + File.separator + ".." + File.separator + "properties" + File.separator + tableName + ".properties");
                NCProperties p = new NCProperties(((NCProperties)this.getCurrentProps()).getDefaults());
                FileInputStream in = new FileInputStream(tabPropFile);
                p.load(in);
                in.close();
                this.tabToProps.put(tableName, p);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        }
        return (Properties)this.tabToProps.get(tableName);
    }

    public String getProperty(String key) {
        return this.getCurrentProps().getProperty(key);
    }

    public String[] getPropertyAsList(String key) {
        String res = this.getCurrentProps().getProperty(key);
        if (res == null) {
            return null;
        }
        Vector resV = NCStringUtilities.SplitSeparatedString(",", res);
        String[] resA = new String[resV.size()];
        int i = 0;
        while (i < resV.size()) {
            resA[i] = (String)resV.get(i);
            ++i;
        }
        return resA.length > 0 ? resA : null;
    }

    public ArrayList getPropertyKeysStartingWith(String start) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<?> it = this.getCurrentProps().propertyNames();
        while (it.hasMoreElements()) {
            String s = (String)it.nextElement();
            if (!s.startsWith(start)) continue;
            result.add(s);
        }
        return result.size() > 0 ? result : null;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setCurrentProps(Properties currentProps) {
        this.currentProps = currentProps;
    }

    public Properties getCurrentProps() {
        return this.currentProps;
    }

    public void setCurrentTable(DBTableMetaData currentTable) {
        this.currentTable = currentTable;
    }

    public DBTableMetaData getCurrentTable() {
        return this.currentTable;
    }

    public void setDbMetaData(DBMetaData dbMetaData) {
        this.dbMetaData = dbMetaData;
    }

    public DBMetaData getDbMetaData() {
        return this.dbMetaData;
    }

    public void setTemplateDir(File templateDir) {
        this.templateDir = templateDir;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }
}

