/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.installer;

import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.INCStatus;
import de.netcomputing.installer.SyncEntry;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import netcomputing.tools.Platforms;

public class Synchronizer {
    public static Synchronizer This = new Synchronizer();
    String baseUrl = System.getProperty("updateurl", "http://www.anyj-download.de/");
    public boolean doCancel = false;

    public void patchClasses(Set diffs, String anyjHome, INCStatus progress) throws Exception {
        String newJarFile = anyjHome + File.separator + "bin" + File.separator + "anyj_in_update.jar";
        this.patchZip(diffs, anyjHome + File.separator + "bin" + File.separator + "anyj.jar", newJarFile, this.baseUrl + "update/classes/", progress);
        this.buildZipMapFile(newJarFile, anyjHome + File.separator + "bin" + File.separator + "classes.txt");
        if (!this.doCancel) {
            boolean success = new File(newJarFile).renameTo(new File(anyjHome + File.separator + "bin" + File.separator + "anyjupd.jar"));
            if (!success) {
                throw new RuntimeException("Unable to rename " + newJarFile + " to 'anyj.jar'. Pls ensure it is not locked !");
            }
        } else {
            new File(newJarFile).delete();
        }
    }

    public void patchFiles(Set diffs, String anyjHome, INCStatus progress) throws Exception {
        this.patchFileTree(diffs, anyjHome, anyjHome + File.separator + "update", this.baseUrl + "update/files/", progress);
    }

    public void patchFileTree(Set diffs, String baseDir, String outBase, String updateUrl, INCStatus progress) throws Exception {
        int by;
        FileOutputStream out;
        progress.setToDo(diffs.size());
        int progCount = 0;
        boolean hadWriteLock = false;
        Iterator it = diffs.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            InputStream in = null;
            String url = updateUrl + name;
            url = NCStringUtilities.Replace(url, " ", "%20");
            in = new URL(url).openStream();
            progress.setText(name);
            File outF = new File(baseDir + File.separator + name.replace('/', File.separatorChar));
            if (outF.exists() && !outF.canWrite()) {
                outF = new File(outBase + File.separator + name.replace('/', File.separatorChar));
                outF.getParentFile().mkdirs();
                hadWriteLock = true;
            }
            out = new FileOutputStream(outF);
            progress.setDone(++progCount);
            by = 0;
            while ((by = in.read()) >= 0) {
                out.write(by);
            }
            out.close();
            in.close();
        }
        int count = 0;
        File outF = new File(baseDir + File.separator + "bin" + File.separator + "files.txt");
        File outSure = new File(baseDir + File.separator + "bin" + File.separator + "files1.txt");
        do {
            if (hadWriteLock) {
                outF = new File(outBase + File.separator + "bin" + File.separator + "files.txt");
                outF.getParentFile().mkdirs();
            }
            InputStream in = new URL(this.baseUrl + "/update/files.txt").openStream();
            out = new FileOutputStream(outF);
            by = 0;
            while ((by = in.read()) >= 0) {
                out.write(by);
            }
            out.close();
            in.close();
            try {
                in = new URL(this.baseUrl + "/update/files.txt").openStream();
                out = new FileOutputStream(outSure);
                by = 0;
                while ((by = in.read()) >= 0) {
                    out.write(by);
                }
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
        } while (outF.length() != outSure.length() && count++ < 5);
        if (count >= 5) {
            throw new RuntimeException("unable to read files.txt from server");
        }
    }

    public void patchZip(Set diffs, String zipFile, String zipOut, String updateUrl, INCStatus progress) throws Exception {
        InputStream in;
        JarEntry je;
        String name;
        progress.setText("patching " + zipFile);
        ZipFile zf = new ZipFile(zipFile);
        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(zipOut));
        int progCount = 0;
        int toDo = 0;
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry zen = en.nextElement();
            ++toDo;
        }
        Iterator it = diffs.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            if (zf.getEntry(name) != null) continue;
            ++toDo;
        }
        progress.setToDo(toDo);
        en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry zen = en.nextElement();
            je = new JarEntry(zen.getName());
            in = null;
            if (!zen.isDirectory() && diffs.contains(zen.getName())) {
                String url = updateUrl + zen.getName();
                url = NCStringUtilities.Replace(url, " ", "%20");
                in = new URL(url).openStream();
                progress.setText(zen.getName());
            } else {
                in = zf.getInputStream(zen);
            }
            progress.setDone(++progCount);
            jarOut.putNextEntry(je);
            int by = 0;
            while ((by = in.read()) >= 0) {
                jarOut.write(by);
            }
            jarOut.closeEntry();
            in.close();
            if (!this.doCancel) continue;
            return;
        }
        it = diffs.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            if (zf.getEntry(name) != null) continue;
            je = new JarEntry(name);
            in = null;
            String url = updateUrl + name;
            url = NCStringUtilities.Replace(url, " ", "%20");
            in = new URL(url).openStream();
            progress.setText(name);
            progress.setDone(++progCount);
            jarOut.putNextEntry(je);
            int by = 0;
            while ((by = in.read()) >= 0) {
                jarOut.write(by);
            }
            jarOut.closeEntry();
            in.close();
            if (!this.doCancel) continue;
            return;
        }
        zf.close();
        jarOut.close();
    }

    public void makeServerUpdate(String localhome, String outBase) throws Exception {
        File in;
        File out;
        String name;
        Set classes = this.findServerClassUpdates(localhome);
        Set files = this.findServerFileUpdates(localhome);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            name = name.replace('/', File.separatorChar);
            out = new File(outBase, "classes" + File.separator + name);
            out.getParentFile().mkdirs();
            in = new File(localhome, "classes" + File.separator + name);
            VFile.Copy(in, out);
        }
        it = files.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            name = name.replace('/', File.separatorChar);
            out = new File(outBase, "files" + File.separator + name);
            out.getParentFile().mkdirs();
            in = new File(localhome, "files" + File.separator + name);
            VFile.Copy(in, out);
        }
        VFile.Copy(new File(localhome + File.separator + "classes.txt"), new File(outBase + File.separator + "classes.txt"));
        VFile.Copy(new File(localhome + File.separator + "files.txt"), new File(outBase + File.separator + "files.txt"));
    }

    public Set findServerClassUpdates(String localHome) throws Exception {
        HashMap newmap = this.readMapFile(localHome + File.separator + "classes.txt");
        HashMap oldmap = this.readMapFile(new URL(this.baseUrl + "update/classes.txt"), null);
        return this.findUpdates(oldmap, newmap);
    }

    public Set findServerFileUpdates(String localHome) throws Exception {
        HashMap newmap = this.readMapFile(localHome + File.separator + "files.txt");
        HashMap oldmap = this.readMapFile(new URL(this.baseUrl + "update/files.txt"), null);
        return this.findUpdates(oldmap, newmap);
    }

    public Set findClassUpdates(String anyjHome, INCStatus status) throws Exception {
        HashMap oldmap = this.readMapFile(anyjHome + File.separator + "bin" + File.separator + "classes.txt");
        HashMap newmap = this.readMapFile(new URL(this.baseUrl + "update/classes.txt"), status);
        return this.findUpdates(oldmap, newmap);
    }

    public Set findFileUpdates(String anyjHome, INCStatus status) throws Exception {
        HashMap oldmap = this.readMapFile(anyjHome + File.separator + "bin" + File.separator + "files.txt");
        HashMap newmap = this.readMapFile(new URL(this.baseUrl + "update/files.txt"), status);
        return this.findUpdates(oldmap, newmap);
    }

    public HashMap readMapFile(String file2) throws Exception {
        DataInputStream in = new DataInputStream(new FileInputStream(file2));
        return this.readMapFile(in, null);
    }

    public HashMap readMapFile(URL url, INCStatus status) throws Exception {
        Object ob = url.getContent();
        return this.readMapFile(new DataInputStream((InputStream)ob), status);
    }

    public HashMap readMapFile(DataInputStream in, INCStatus status) throws Exception {
        boolean end = false;
        HashMap<String, SyncEntry> res = new HashMap<String, SyncEntry>(1000);
        int count = 0;
        while (!end) {
            String name = in.readUTF();
            long crc = in.readLong();
            if ("END".equals(name)) {
                end = true;
            } else {
                res.put(name, new SyncEntry(name, crc));
            }
            if (status == null) continue;
            status.setDone(count++);
        }
        return res;
    }

    public Set findUpdates(HashMap oldver, HashMap newver) {
        HashSet<String> res = new HashSet<String>(500);
        Iterator it = newver.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            SyncEntry en = (SyncEntry)newver.get(s);
            SyncEntry old = (SyncEntry)oldver.get(s);
            if (en.name.endsWith("anyjdeploy.zip") || en.name.indexOf("META-INF") >= 0 || en.name.endsWith("/") || Platforms.IsLinux() && (en.name.endsWith(".exe") || en.name.endsWith(".bat") || en.name.endsWith(".reg") || en.name.endsWith(".ico") || en.name.endsWith(".anyj") || en.name.indexOf("/jre/") >= 0 || en.name.indexOf("/jikes/") >= 0)) continue;
            if (old == null) {
                System.out.print("NEW FILE:");
                System.out.println(en.name);
                res.add(en.name);
                continue;
            }
            if (old.crc == en.crc) continue;
            System.out.print("CHANGED:");
            System.out.println(en.name);
            res.add(en.name);
        }
        return res;
    }

    public void buildZipMapFile(String file2, String mapFile) throws Exception {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(mapFile));
        ZipFile zip = new ZipFile(file2);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            out.writeUTF(entry.getName());
            out.writeLong(entry.getCrc());
        }
        out.writeUTF("END");
        out.writeLong(-1L);
        zip.close();
        out.close();
    }

    public static void main(String[] args) throws Exception {
        if ("-serverupdate".equals(args[0])) {
            This.makeServerUpdate(args[1], args[2]);
        } else {
            System.out.println("computing filemap " + args[0] + " " + args[1]);
            This.buildZipMapFile(args[0], args[1]);
        }
    }
}

