/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.propertystore.beans;

import de.netcomputing.propertystore.IStoreAccess;
import de.netcomputing.propertystore.IStoreControl;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertyCombo
extends JComboBox
implements IStoreControl {
    IStoreAccess store;
    String dataPath;
    String collectionPath;
    boolean sortByName = false;
    boolean isValueCollection = false;

    public void addChangeListener(final ChangeListener cl) {
        super.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                cl.stateChanged(new ChangeEvent(e));
            }
        });
    }

    public void readData(IStoreAccess store) {
        this.removeAllItems();
        Enumeration en = this.getIsValueCollection() ? store.getSubnodeValues(this.collectionPath) : store.getSubnodes(this.collectionPath);
        while (en.hasMoreElements()) {
            this.addItem(en.nextElement());
        }
        if (this.getSortByName()) {
            // empty if block
        }
        this.setSelectedItem(store.getValue(this.dataPath));
    }

    public void writeData(IStoreAccess store) {
        String s = "";
        if (this.getSelectedItem() != null) {
            s = this.getSelectedItem().toString();
        }
        store.setValue(this.dataPath, s);
    }

    public void setStore(IStoreAccess store) {
        this.store = store;
    }

    public IStoreAccess getStore() {
        return this.store;
    }

    public void setIsValueCollection(boolean valueCollection) {
        this.isValueCollection = valueCollection;
    }

    public boolean getIsValueCollection() {
        return this.isValueCollection;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    public boolean getSortByName() {
        return this.sortByName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setCollectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }
}

