/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.propertystore.beans;

import de.netcomputing.propertystore.IStoreAccess;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import netcomputing.collections.Algorithms;
import netcomputing.collections.INCIndexed;

public class PropertyListBox
extends JScrollPane {
    JList list = new JList();
    DefaultListModel model;
    IStoreAccess store;
    String dataPath;
    String collectionPath;
    boolean sortByName = false;
    boolean isValueCollection = false;
    boolean isOrdered = false;

    public PropertyListBox() {
        this.getViewport().setView(this.list);
        this.model = new DefaultListModel();
        this.list.setModel(this.model);
    }

    public JList getList() {
        return this.list;
    }

    public void readData(IStoreAccess store) {
        this.model.removeAllElements();
        if (!this.getIsOrdered()) {
            Enumeration en = this.getIsValueCollection() ? store.getSubnodeValues(this.collectionPath) : store.getSubnodes(this.collectionPath);
            while (en.hasMoreElements()) {
                this.model.addElement(en.nextElement());
            }
        } else {
            int size = store.getSubnodesSize(this.getCollectionPath());
            this.model.setSize(size);
            Enumeration en = store.getSubnodes(this.collectionPath);
            while (en.hasMoreElements()) {
                Object next = en.nextElement();
                if (next.toString().startsWith("internal_")) continue;
                int index = store.getIntValue(this.getCollectionPath() + "." + next + ".internal_i", 0);
                this.model.setElementAt(next, index);
            }
        }
        this.list.setSelectedValue(store.getValue(this.dataPath), true);
    }

    public void writeData(IStoreAccess acc) {
        String s = "";
        if (this.list.getSelectedValue() != null) {
            s = this.list.getSelectedValue().toString();
        }
        acc.setValue(this.dataPath, s);
        if (this.getIsOrdered()) {
            int n = 0;
            while (n < this.model.getSize()) {
                this.writeNode(acc, this.getCollectionPath(), this.model.elementAt(n), n);
                ++n;
            }
        }
    }

    public void writeNode(IStoreAccess acc, String collectionPath, Object element, int index) {
        acc.setValue(collectionPath + "." + element + ".internal_i", "" + index);
    }

    public void setIsOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public boolean getIsOrdered() {
        return this.isOrdered;
    }

    public void setStore(IStoreAccess store) {
        this.store = store;
    }

    public IStoreAccess getStore() {
        return this.store;
    }

    public void sortByString(final boolean up) {
        final DefaultListModel model = (DefaultListModel)this.list.getModel();
        Algorithms.QuickSortByString(new INCIndexed(){

            public Object at(int index) {
                return model.get(up ? index : this.size() - index - 1);
            }

            public void setAt(int index, Object o) {
                model.set(up ? index : this.size() - index - 1, o);
            }

            public int size() {
                return model.getSize();
            }
        });
    }

    public void setIsValueCollection(boolean valueCollection) {
        this.isValueCollection = valueCollection;
    }

    public boolean getIsValueCollection() {
        return this.isValueCollection;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    public boolean getSortByName() {
        return this.sortByName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setCollectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }
}

