/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.DragHelperListener;
import de.netcomputing.swingx.IDockingContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class DragHelper
implements MouseListener,
MouseMotionListener {
    DragHelperListener dhListener;
    JComponent dragHandle;
    int startDragX = -1;
    int startDragY = -1;
    boolean dragging = false;
    JPanel dragPanel = new JPanel(new BorderLayout(0, 0));
    int xCorrection = 0;
    int yCorrection = 0;
    IDockingContainer compDraggedOver;
    JComponent glassGetter;

    public DragHelper(DragHelperListener li, JComponent dragHandle) {
        this.dhListener = li;
        this.dragHandle = dragHandle;
        dragHandle.addMouseListener(this);
        dragHandle.addMouseMotionListener(this);
    }

    public DragHelper(DragHelperListener li, JComponent dragHandle, JComponent glassGetter) {
        this(li, dragHandle);
        this.glassGetter = glassGetter;
    }

    JComponent getGlassPane() {
        JComponent glassGetter = null;
        glassGetter = this.dragHandle.getRootPane() != null ? this.dragHandle : (this.dhListener instanceof JComponent ? (JComponent)((Object)this.dhListener) : this.glassGetter);
        JComponent glass = (JComponent)glassGetter.getRootPane().getGlassPane();
        if (glass == null || !"STACKPANELDRAG".equals(glass.getName())) {
            glass = new JPanel(){

                public void doLayout() {
                    super.doLayout();
                }

                public void paint(Graphics g) {
                    super.paint(g);
                }
            };
            glass.setName("STACKPANELDRAG");
            glass.setLayout(null);
            glass.setOpaque(false);
            glass.setVisible(true);
            glassGetter.getRootPane().setGlassPane(glass);
        }
        glass.setVisible(true);
        return glass;
    }

    void dropGlassPane() {
        if (this.getGlassPane() == null) {
            return;
        }
        this.getGlassPane().removeAll();
        this.getGlassPane().setVisible(false);
    }

    void stopDragging() {
        this.compDraggedOver = null;
        this.yCorrection = 0;
        this.xCorrection = 0;
        this.dragging = false;
        this.dragPanel.removeAll();
        this.dropGlassPane();
        if (this.dragHandle != null && this.dragHandle.getRootPane() != null) {
            this.dragHandle.getRootPane().repaint();
        }
    }

    void fireDragEnter(IDockingContainer target, int targetX, int targetY) {
        this.dhListener.fireDragEnter(target, targetX, targetY);
    }

    void fireDragOver(IDockingContainer target, int targetX, int targetY) {
        this.dhListener.fireDragOver(target, targetX, targetY);
    }

    void fireDragExit(IDockingContainer target) {
        this.dhListener.fireDragExit(target);
    }

    public void doDrag(MouseEvent ev) {
        Point screenPos = ((JComponent)ev.getSource()).getLocationOnScreen();
        screenPos.x += ev.getX() - this.xCorrection;
        screenPos.y += ev.getY() - this.yCorrection;
        Point glassPos = this.dragHandle.getRootPane().getLocationOnScreen();
        glassPos.x = screenPos.x - glassPos.x;
        glassPos.y = screenPos.y - glassPos.y;
        int oldX = this.dragPanel.getX();
        int oldY = this.dragPanel.getY();
        this.dragPanel.setLocation(glassPos);
        this.dragHandle.getRootPane().repaint(Math.min(glassPos.x, oldX), Math.min(glassPos.y, oldY), this.dragPanel.getWidth() + Math.abs(Math.abs(oldX) - Math.abs(glassPos.x)), this.dragPanel.getHeight() + Math.abs(Math.abs(oldY) - Math.abs(glassPos.y)));
    }

    public void startDragging(MouseEvent ev) {
        this.xCorrection = ev.getX();
        this.yCorrection = ev.getY();
        this.dragging = true;
        Point screenPos = ((JComponent)ev.getSource()).getLocationOnScreen();
        screenPos.x += ev.getX() - this.xCorrection;
        screenPos.y += ev.getY() - this.yCorrection;
        Point glassPos = this.dragHandle.getRootPane().getLocationOnScreen();
        glassPos.x = screenPos.x - glassPos.x;
        glassPos.y = screenPos.y - glassPos.y;
        JComponent draggedComp = this.dhListener.getShapeOnStartDragging(ev);
        if (draggedComp == null) {
            this.stopDragging();
            return;
        }
        Dimension size = draggedComp.getSize();
        this.dragPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.dragPanel.add("Center", draggedComp);
        this.getGlassPane().add(this.dragPanel);
        this.dragPanel.setBounds(glassPos.x, glassPos.y, size.width, size.height);
        draggedComp.setSize(size.width, size.height);
        this.dragPanel.getRootPane().repaint();
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp != null && comp.isVisible() && !"STACKPANELDRAG".equals(comp.getName())) {
                    Point loc = comp.getLocation();
                    if ((comp = comp instanceof Container ? DragHelper.getDeepestComponentAt(comp, x - loc.x, y - loc.y) : comp.getComponentAt(x - loc.x, y - loc.y)) != null && comp.isVisible()) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return parent;
    }

    IDockingContainer getDockingContainerAt(Container cont, int screenX, int screenY) {
        int x = screenX - cont.getLocationOnScreen().x;
        int y = screenY - cont.getLocationOnScreen().y;
        Component c = DragHelper.getDeepestComponentAt(cont, x, y);
        if (c == null) {
            return null;
        }
        if (c != null) {
            while (c != null && !(c instanceof IDockingContainer)) {
                x += c.getX();
                y += c.getY();
                c = c.getParent();
            }
            return (IDockingContainer)((Object)c);
        }
        return null;
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            if (Math.abs(e.getX() - this.startDragX) < 4 && Math.abs(e.getY() - this.startDragY) < 4) {
                return;
            }
            if (e.getSource() == this.dragHandle) {
                this.startDragging(e);
            }
            return;
        }
        this.doDrag(e);
        Point p = ((JComponent)e.getSource()).getLocationOnScreen();
        p.x += e.getX();
        p.y += e.getY();
        IDockingContainer dc = this.getDockingContainerAt(this.dragHandle.getTopLevelAncestor(), p.x, p.y);
        if (dc == null) {
            if (this.compDraggedOver != null) {
                this.fireDragExit(this.compDraggedOver);
            }
            this.compDraggedOver = null;
        } else {
            Point spos = ((JComponent)((Object)dc)).getLocationOnScreen();
            int dcX = p.x - spos.x;
            int dcY = p.y - spos.y;
            if (this.compDraggedOver != dc) {
                if (this.compDraggedOver != null) {
                    this.fireDragExit(this.compDraggedOver);
                }
                this.compDraggedOver = dc;
                if (dc != null) {
                    this.fireDragEnter(dc, dcX, dcY);
                }
            }
            if (this.compDraggedOver != null) {
                this.fireDragOver(this.compDraggedOver, dcX, dcY);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!this.dragHandle.isVisible()) {
            return;
        }
        this.startDragX = e.getX();
        this.startDragY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.startDragX = -1;
        this.startDragY = -1;
        if (!this.dragging) {
            return;
        }
        Point p = ((JComponent)e.getSource()).getLocationOnScreen();
        p.x += e.getX();
        p.y += e.getY();
        IDockingContainer dc = this.getDockingContainerAt(this.dragHandle.getTopLevelAncestor(), p.x, p.y);
        if (dc != null && dc.canDrop(p.x, p.y, null) && this.compDraggedOver != null && dc == this.compDraggedOver) {
            JComponent dcComp = (JComponent)((Object)dc);
            Point spos = dcComp.getLocationOnScreen();
            int dcX = p.x - spos.x;
            int dcY = p.y - spos.y;
            Point p1 = ((JComponent)e.getSource()).getLocationOnScreen();
            JRootPane root = this.dragHandle.getRootPane();
            this.dropGlassPane();
            this.compDraggedOver = null;
            this.yCorrection = 0;
            this.xCorrection = 0;
            this.dragging = false;
            this.dhListener.notifyStopDragging(dc, this.dragHandle, p1.x, p1.y, true);
        } else {
            this.fireDragExit(dc);
            this.stopDragging();
            this.dhListener.notifyStopDragging(dc, this.dragHandle, -1, -1, false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

