/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.IDockingComponentContainer;
import de.netcomputing.swingx.StackPanelInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class StackPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    JButton closeButton;
    JComponent contentPanel;
    StackPanelInfo info;
    boolean isHorizontal = false;
    boolean canDrag = true;
    JPanel dragPanel = new JPanel(new BorderLayout(0, 0));
    int xCorrection = 0;
    int yCorrection = 0;
    IDockingComponentContainer compDraggedOver;
    boolean dragging = false;

    public static void translatePoint(Component now, Component newC, Point p) {
        try {
            Point act = now.getLocationOnScreen();
            Point n = newC.getLocationOnScreen();
            act.x -= n.x;
            act.y -= n.y;
            p.x += act.x;
            p.y += act.y;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public StackPanel(JButton aCloseButton, JComponent content, StackPanelInfo info, boolean horizontal) {
        this.isHorizontal = horizontal;
        this.info = info;
        this.setLayout(new BorderLayout(0, 0));
        this.closeButton = aCloseButton;
        this.contentPanel = content;
        if (this.isHorizontal) {
            this.add("North", this.closeButton);
            this.add("Center", this.contentPanel);
        } else {
            this.add("West", this.closeButton);
            this.add("Center", this.contentPanel);
        }
        this.closeButton.addMouseListener(this);
        this.closeButton.addMouseMotionListener(this);
    }

    public void setCanDrag(boolean canDrag) {
        this.canDrag = canDrag;
    }

    public boolean getCanDrag() {
        return this.canDrag;
    }

    public void setInfo(StackPanelInfo info) {
        this.info = info;
    }

    public StackPanelInfo getInfo() {
        return this.info;
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public boolean isVisible() {
        return this.getContentPanel().isVisible();
    }

    void fireDragEnter(IDockingComponentContainer target, int targetX, int targetY) {
        target.dragEnter(targetX, targetY, this);
    }

    void fireDragOver(IDockingComponentContainer target, int targetX, int targetY) {
        target.dragOver(targetX, targetY, this);
    }

    void fireDragExit(IDockingComponentContainer target) {
        target.dragExit();
    }

    void fireComponentDropped(IDockingComponentContainer target, int x, int y) {
        JRootPane root = this.getRootPane();
        this.dropGlassPane();
        this.getParent().remove(this);
        this.remove(this.getContentPanel());
        target.componentDropped(x, y, this);
        this.compDraggedOver = null;
        this.yCorrection = 0;
        this.xCorrection = 0;
        this.dragging = false;
        root.invalidate();
        root.validate();
        root.repaint();
    }

    public JPanel getGlassPane() {
        if (this.getRootPane() == null) {
            return null;
        }
        JPanel glass = (JPanel)this.getRootPane().getGlassPane();
        if (glass == null || !"STACKPANELDRAG".equals(glass.getName())) {
            glass = new JPanel(){

                public void doLayout() {
                    super.doLayout();
                }

                public void paint(Graphics g) {
                    super.paint(g);
                }
            };
            glass.setName("STACKPANELDRAG");
            glass.setLayout(null);
            glass.setOpaque(false);
            glass.setVisible(true);
            this.getRootPane().setGlassPane(glass);
        }
        glass.setVisible(true);
        return glass;
    }

    public void dropGlassPane() {
        if (this.getGlassPane() == null) {
            return;
        }
        this.getGlassPane().removeAll();
        this.getGlassPane().setVisible(false);
    }

    public void stopDragging() {
        this.compDraggedOver = null;
        this.yCorrection = 0;
        this.xCorrection = 0;
        this.dragging = false;
        this.dragPanel.removeAll();
        this.add("Center", this.getContentPanel());
        if (this.isHorizontal) {
            this.add("North", this.getCloseButton());
        } else {
            this.add("West", this.getCloseButton());
        }
        this.invalidate();
        this.validate();
        this.dropGlassPane();
        if (this.getRootPane() != null) {
            this.getRootPane().repaint();
        }
    }

    public void doDrag(MouseEvent ev) {
        Point screenPos = ((JComponent)ev.getSource()).getLocationOnScreen();
        screenPos.x += ev.getX() - this.xCorrection;
        screenPos.y += ev.getY() - this.yCorrection;
        Point glassPos = this.getRootPane().getLocationOnScreen();
        glassPos.x = screenPos.x - glassPos.x;
        glassPos.y = screenPos.y - glassPos.y;
        this.dragPanel.setLocation(glassPos);
        this.getRootPane().repaint();
    }

    public void startDragging(MouseEvent ev) {
        Dimension size = this.getSize();
        this.xCorrection = ev.getX();
        this.yCorrection = ev.getY();
        this.dragging = true;
        Point screenPos = ((JComponent)ev.getSource()).getLocationOnScreen();
        screenPos.x += ev.getX() - this.xCorrection;
        screenPos.y += ev.getY() - this.yCorrection;
        Point glassPos = this.getRootPane().getLocationOnScreen();
        glassPos.x = screenPos.x - glassPos.x;
        glassPos.y = screenPos.y - glassPos.y;
        this.dragPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.setMinimumSize(size);
        this.remove(this.getContentPanel());
        this.remove(this.getCloseButton());
        this.dragPanel.add("Center", this.getContentPanel());
        if (this.isHorizontal) {
            this.dragPanel.add("North", this.getCloseButton());
        } else {
            this.dragPanel.add("West", this.getCloseButton());
        }
        this.getGlassPane().add(this.dragPanel);
        this.dragPanel.setBounds(glassPos.x, glassPos.y, size.width, size.height);
        this.getRootPane().repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.doDrag(e);
        Point p = ((JComponent)e.getSource()).getLocationOnScreen();
        p.x += e.getX();
        p.y += e.getY();
        IDockingComponentContainer dc = this.getDockingContainerAt(p.x, p.y);
        if (dc != null) {
            System.out.println("DC:" + dc + " " + p);
        }
        if (dc == null) {
            if (this.compDraggedOver != null) {
                this.fireDragExit(this.compDraggedOver);
            }
            this.compDraggedOver = null;
        } else {
            Point spos = ((JComponent)((Object)dc)).getLocationOnScreen();
            int dcX = p.x - spos.x;
            int dcY = p.y - spos.y;
            if (this.compDraggedOver != dc) {
                if (this.compDraggedOver != null) {
                    this.fireDragExit(this.compDraggedOver);
                }
                this.compDraggedOver = dc;
                if (dc != null) {
                    this.fireDragEnter(dc, dcX, dcY);
                }
            }
            if (this.compDraggedOver != null) {
                this.fireDragOver(this.compDraggedOver, dcX, dcY);
            }
        }
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp != null && comp.isVisible() && !"STACKPANELDRAG".equals(comp.getName())) {
                    Point loc = comp.getLocation();
                    if ((comp = comp instanceof Container ? StackPanel.getDeepestComponentAt(comp, x - loc.x, y - loc.y) : comp.getComponentAt(x - loc.x, y - loc.y)) != null && comp.isVisible()) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return parent;
    }

    IDockingComponentContainer getDockingContainerAt(int screenX, int screenY) {
        int y;
        int x;
        Container cont = this.getTopLevelAncestor();
        Component c = StackPanel.getDeepestComponentAt(cont, x = screenX - cont.getLocationOnScreen().x, y = screenY - cont.getLocationOnScreen().y);
        if (c == null) {
            return null;
        }
        if (c != null) {
            while (c != null && !(c instanceof IDockingComponentContainer)) {
                x += c.getX();
                y += c.getY();
                c = c.getParent();
            }
            return (IDockingComponentContainer)((Object)c);
        }
        return null;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isControlDown() && this.canDrag) {
            this.startDragging(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        Point p = ((JComponent)e.getSource()).getLocationOnScreen();
        p.x += e.getX();
        p.y += e.getY();
        IDockingComponentContainer dc = this.getDockingContainerAt(p.x, p.y);
        if (this.compDraggedOver != null && dc != this && dc == this.compDraggedOver) {
            JComponent dcComp = (JComponent)((Object)dc);
            Point spos = dcComp.getLocationOnScreen();
            int dcX = p.x - spos.x;
            int dcY = p.y - spos.y;
            Point p1 = ((JComponent)e.getSource()).getLocationOnScreen();
            this.fireComponentDropped(dc, p1.x, p1.y);
        } else {
            if (dc != null) {
                this.fireDragExit(dc);
            }
            this.stopDragging();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

