/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.BumpBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;

class ToolBumps
extends JButton {
    protected Color topColor;
    protected Color shadowColor;
    protected Color backColor;
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;
    Color arrowColor = Color.gray;
    Color arrowShadow = Color.black;
    Color arrowHi = Color.white;
    boolean horizontal = false;
    int hWidth = 9;
    boolean isCollapsed = false;

    public ToolBumps(boolean collapsed, boolean isHorizontal, int horizWidth) {
        this(Color.white, Color.gray, Color.lightGray, collapsed, isHorizontal, horizWidth);
    }

    public ToolBumps(Color newTopColor, Color newShadowColor, Color newBackColor, boolean collapsed, boolean isHorizontal, int horizontalWidth) {
        this.setBumpColors(newTopColor, newShadowColor, newBackColor);
        this.horizontal = isHorizontal;
        this.hWidth = horizontalWidth;
        this.isCollapsed = collapsed;
    }

    private BumpBuffer getBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor, Color aBackColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) {
            return this.buffer;
        }
        BumpBuffer result = null;
        Enumeration elements = buffers.elements();
        while (elements.hasMoreElements()) {
            BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
            if (!aBuffer.hasSameConfiguration(gc, aTopColor, aShadowColor, aBackColor)) continue;
            result = aBuffer;
            break;
        }
        if (result == null) {
            result = new BumpBuffer(gc, this.topColor, this.shadowColor, this.backColor);
            buffers.addElement(result);
        }
        return result;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
        this.backColor = newBackColor;
    }

    public int getWidth() {
        if (this.horizontal && this.getParent() != null) {
            if (this.hWidth == 0) {
                return this.getParent().getWidth();
            }
            return this.hWidth;
        }
        if (!this.horizontal && this.getParent() != null && this.isCollapsed) {
            if (this.hWidth == 0) {
                return this.getParent().getWidth();
            }
            return this.hWidth;
        }
        return 9;
    }

    public int getHeight() {
        if (!this.horizontal && this.getParent() != null) {
            return this.getParent().getHeight();
        }
        return 9;
    }

    public Dimension getMinimumSize() {
        if (!this.isCollapsed) {
            return new Dimension(9, 9);
        }
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics g) {
        int x = 0;
        int y = 0;
        GraphicsConfiguration gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(gc, this.topColor, this.shadowColor, this.backColor);
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        int savey = y;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            x = savex;
            while (x < x2) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
                x += bufferWidth;
            }
            y += bufferHeight;
        }
        Object p = null;
        if (this.getWidth() > this.getHeight()) {
            g.setColor(this.backColor);
            g.fillRect(savex, savey, 8, iconHeight);
            this.drawArrow(g, savex + 3, savey + 2, Color.white, Color.black, Color.gray, false);
            g.setColor(Color.white);
            g.drawLine(savex + 1, savey + 1, savex + iconWidth - 2, savey + 1);
            g.drawLine(savex + 1, savey + 1, savex + 1, savey + iconHeight - 2);
            g.setColor(Color.gray);
            g.drawRect(savex, savey, iconWidth - 1, iconHeight - 1);
        } else {
            g.setColor(this.backColor);
            g.fillRect(savex, savey, --iconWidth - 1, 8);
            this.drawArrow(g, savex + 2, savey + 3, Color.white, Color.black, Color.gray, true);
            g.setColor(Color.gray);
            g.drawRect(savex + 1, savey + 1, iconWidth - 1, iconHeight - 3);
            g.setColor(Color.white);
            g.drawLine(savex + 1, savey + 1, savex + 1, savey + iconHeight - 1 - 1);
            g.drawLine(savex + 1, savey + 1, savex + iconWidth - 1, savey + 1);
            g.setColor(Color.gray);
            g.drawRect(savex, savey, iconWidth, iconHeight - 1);
        }
    }

    void drawPix(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public void drawArrow(Graphics g, int x, int y, Color hi, Color lo, Color middle, boolean vertical) {
        if (vertical) {
            g.setColor(lo);
            g.drawLine(x, y, x + 4, y);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.setColor(hi);
            g.drawLine(x + 3, y + 2, x + 3, y + 2);
            g.drawLine(x + 4, y + 1, x + 4, y + 1);
            g.drawLine(x + 5, y, x + 5, y);
            g.setColor(middle);
            g.drawLine(x + 2, y + 1, x + 3, y + 1);
        } else {
            g.setColor(hi);
            g.drawLine(x + 2, y + 3, x + 2, y + 3);
            g.drawLine(x + 1, y + 4, x + 1, y + 4);
            g.drawLine(x, y + 5, x, y + 5);
            g.setColor(lo);
            g.drawLine(x, y, x, y + 4);
            g.drawLine(x, y, x, y);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.setColor(middle);
            g.drawLine(x + 1, y + 2, x + 1, y + 3);
        }
    }
}

