/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx.layout;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Share {
    public static final int HORIZ = 0;
    public static final int VERT = 1;
    static final ArrayList emptyList = new ArrayList();
    int orientation;
    int min;
    int share;
    Component comp;
    boolean isMin;
    ArrayList subComponents;

    public static Share HGap(int width) {
        return new Share(0, new JLabel(""), width, 0);
    }

    public static Share VGap(int width) {
        return new Share(1, new JLabel(""), width, 0);
    }

    public static Share HGlue(int width, int share) {
        return new Share(0, new JLabel(""), width, share);
    }

    public static Share VGlue(int width, int share) {
        return new Share(1, new JLabel(""), width, share);
    }

    public static Share HFix(Component comp) {
        return new Share(0, comp, -1, 0);
    }

    public static Share HVar(Component comp, int share) {
        return new Share(0, comp, -1, share);
    }

    public static Share Insets(Component comp, int min, int share, int gap) {
        return Share.HBar(share).add(Share.HGap(gap)).add(Share.VBar(1).add(Share.VGap(gap)).add(Share.H(comp, min, 1)).add(Share.VGap(gap))).add(Share.HGap(gap));
    }

    public static Share Insets(Share s, int share, int gap) {
        return Share.HBar(share).add(Share.HGap(gap)).add(Share.VBar(1).add(Share.VGap(gap)).add(s).add(Share.VGap(gap))).add(Share.HGap(gap));
    }

    public static Share VFix(Component comp) {
        return new Share(1, comp, -1, 0);
    }

    public static Share VVar(Component comp, int share) {
        return new Share(1, comp, -1, share);
    }

    public static Share H(Component comp, int min, int share) {
        return new Share(0, comp, min, share);
    }

    public static Share V(Component comp, int min, int share) {
        return new Share(1, comp, min, share);
    }

    public static Share HBar(int share) {
        return new Share(0, null, -1, share);
    }

    public static Share VBar(int share) {
        return new Share(1, null, -1, share);
    }

    public static int MaxComponentWidth(Component[] comps) {
        int res = 0;
        int i = 0;
        while (i < comps.length) {
            res = Math.max(comps[i].getMinimumSize().width, res);
            ++i;
        }
        return res;
    }

    public static Share LabelAndComponent(int share, JComponent label, int minLabelWidth, JComponent component, int minComponentWidth) {
        return Share.LabelAndComponent(share, label, minLabelWidth, Share.H(component, minComponentWidth, 1));
    }

    public static Share LabelAndComponent(int share, JComponent label, int minLabelWidth, JComponent component, int minComponentWidth, int minComponentShare) {
        return Share.LabelAndComponent(share, label, minLabelWidth, Share.H(component, minComponentWidth, minComponentShare));
    }

    public static Share LabelAndComponent(int share, JComponent label, int minLabelWidth, Share component) {
        return Share.HBar(share).add(Share.H(label, minLabelWidth, 0)).add(component);
    }

    public Share() {
        this.orientation = 0;
    }

    public Share(int aOrientation) {
        this.orientation = aOrientation;
    }

    public Share(int aOrientation, Component aComp) {
        this(aOrientation, aComp, -1, 0);
    }

    public Share(int aOrientation, Component aComp, int aMin, int aShare) {
        this.orientation = aOrientation;
        this.min = aMin;
        this.share = aShare;
        this.comp = aComp;
    }

    public void removeShare(Share s) {
        this.getSubComponents().remove(s);
    }

    public Share addFix(Component comp) {
        if (this.orientation == 0) {
            this.add(Share.HFix(comp));
        } else {
            this.add(Share.VFix(comp));
        }
        return this;
    }

    public Share addFix(Component comp, int min) {
        if (this.orientation == 0) {
            this.add(Share.H(comp, min, 0));
        } else {
            this.add(Share.V(comp, min, 0));
        }
        return this;
    }

    public Share addVar(Component comp, int share) {
        if (this.orientation == 0) {
            this.add(Share.HVar(comp, share));
        } else {
            this.add(Share.VVar(comp, share));
        }
        return this;
    }

    public Share addVar(Component comp, int min, int share) {
        if (this.orientation == 0) {
            this.add(Share.H(comp, min, share));
        } else {
            this.add(Share.V(comp, min, share));
        }
        return this;
    }

    public Share addLabelStack(String label, Component comp, int min, int share, int gap) {
        if (this.orientation == 0) {
            this.add(Share.VBar(share).add(Share.V(new JLabel(label), -1, 1)).addGap(gap).add(Share.V(comp, min, 1)));
        } else {
            this.add(Share.VBar(share).add(Share.V(new JLabel(label), -1, 1)).addGap(gap).add(Share.V(comp, min, 1)));
        }
        return this;
    }

    public Share addGap(int gap) {
        if (this.orientation == 0) {
            return this.add(Share.HGap(gap));
        }
        return this.add(Share.VGap(gap));
    }

    public Share addGlue(int min, int share) {
        if (this.orientation == 0) {
            return this.add(Share.HGlue(min, share));
        }
        return this.add(Share.VGlue(min, share));
    }

    public boolean removeComponent(Component m) {
        if (this.subComponents == null) {
            return false;
        }
        int i = 0;
        while (i < this.subComponents.size()) {
            Share s = (Share)this.subComponents.get(i);
            if (s.comp == m) {
                this.removeShare(s);
                return true;
            }
            if (s.removeComponent(m)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setComp(Component comp) {
        this.comp = comp;
    }

    public Component getComp() {
        return this.comp;
    }

    public int getMinWidth() {
        if (this.orientation == 0) {
            if (this.min == -1) {
                if (this.comp != null) {
                    return this.comp.getMinimumSize().width;
                }
                int result = 0;
                if (this.subComponents == null) {
                    return 0;
                }
                int i = 0;
                while (i < this.subComponents.size()) {
                    Share s = (Share)this.subComponents.get(i);
                    result += s.getMinWidth();
                    ++i;
                }
                return result;
            }
            return this.min;
        }
        if (this.comp != null) {
            return this.comp.getMinimumSize().width;
        }
        int result = 0;
        int i = 0;
        while (i < this.subComponents.size()) {
            Share s = (Share)this.subComponents.get(i);
            result = Math.max(s.getMinWidth(), result);
            ++i;
        }
        return result;
    }

    public int getMinHeight() {
        if (this.orientation == 1) {
            if (this.min == -1) {
                if (this.comp != null) {
                    return this.comp.getMinimumSize().height;
                }
                int result = 0;
                if (this.subComponents == null) {
                    return 0;
                }
                int i = 0;
                while (i < this.subComponents.size()) {
                    Share s = (Share)this.subComponents.get(i);
                    result += s.getMinHeight();
                    ++i;
                }
                return result;
            }
            return this.min;
        }
        if (this.comp != null) {
            return this.comp.getMinimumSize().height;
        }
        int result = 0;
        if (this.subComponents == null) {
            return 0;
        }
        int i = 0;
        while (i < this.subComponents.size()) {
            Share s = (Share)this.subComponents.get(i);
            result = Math.max(s.getMinHeight(), result);
            ++i;
        }
        return result;
    }

    public void setShare(int share) {
        this.share = share;
    }

    public int getShare() {
        return this.share;
    }

    public Share add(Share sh) {
        if (this.subComponents == null) {
            this.subComponents = new ArrayList();
        }
        this.subComponents.add(sh);
        return this;
    }

    public List getSubComponents() {
        if (this.subComponents == null) {
            return emptyList;
        }
        return this.subComponents;
    }

    public void addToContainer(Container cont) {
        if (this.comp != null) {
            cont.add(this.comp);
        }
        if (this.subComponents == null) {
            return;
        }
        int i = 0;
        while (i < this.subComponents.size()) {
            Share s = (Share)this.subComponents.get(i);
            s.addToContainer(cont);
            ++i;
        }
    }

    public void setSize(Container parent, int x, int y, int availableWidth, int availableHeight) {
        if (this.subComponents == null) {
            return;
        }
        if (this.orientation == 0) {
            int sumShare = 0;
            int i = 0;
            while (i < this.subComponents.size()) {
                Share s = (Share)this.subComponents.get(i);
                s.isMin = false;
                sumShare += s.getShare();
                ++i;
            }
            int missingSpace = 0;
            int missingShare = 0;
            boolean hadCorrection = true;
            while (hadCorrection && availableWidth > 0 && sumShare > 0) {
                hadCorrection = false;
                int i2 = 0;
                while (i2 < this.subComponents.size()) {
                    int newWidth;
                    Share s = (Share)this.subComponents.get(i2);
                    int compMin = s.getMinWidth();
                    if (compMin > (newWidth = availableWidth * s.getShare() / sumShare) && !s.isMin) {
                        missingSpace += compMin;
                        missingShare += s.getShare();
                        hadCorrection = true;
                        s.isMin = true;
                        break;
                    }
                    ++i2;
                }
                availableWidth -= missingSpace;
                sumShare -= missingShare;
                missingSpace = 0;
                missingShare = 0;
            }
            int incX = x;
            int height = availableHeight;
            int i3 = 0;
            while (i3 < this.subComponents.size()) {
                Share s = (Share)this.subComponents.get(i3);
                int compMin = s.getMinWidth();
                int newWidth = 0;
                if (sumShare > 0) {
                    newWidth = availableWidth * s.getShare() / sumShare;
                }
                newWidth = Math.max(compMin, newWidth);
                if (s.getComp() == null) {
                    s.setSize(parent, incX, y, newWidth, height);
                    incX += newWidth;
                } else {
                    s.getComp().setBounds(incX, y, newWidth, height);
                    incX += newWidth;
                }
                ++i3;
            }
        } else {
            int sumShare = 0;
            int i = 0;
            while (i < this.subComponents.size()) {
                Share s = (Share)this.subComponents.get(i);
                s.isMin = false;
                sumShare += s.getShare();
                ++i;
            }
            int missingSpace = 0;
            int missingShare = 0;
            boolean hadCorrection = true;
            while (hadCorrection && availableHeight > 0 && sumShare > 0) {
                hadCorrection = false;
                int i4 = 0;
                while (i4 < this.subComponents.size()) {
                    int newHeight;
                    Share s = (Share)this.subComponents.get(i4);
                    int compMin = s.getMinHeight();
                    if (compMin > (newHeight = availableHeight * s.getShare() / sumShare) && !s.isMin) {
                        missingSpace += compMin;
                        missingShare += s.getShare();
                        hadCorrection = true;
                        s.isMin = true;
                        break;
                    }
                    ++i4;
                }
                availableHeight -= missingSpace;
                sumShare -= missingShare;
                missingSpace = 0;
                missingShare = 0;
            }
            int incY = y;
            int width = availableWidth;
            int i5 = 0;
            while (i5 < this.subComponents.size()) {
                Share s = (Share)this.subComponents.get(i5);
                int compMin = s.getMinHeight();
                int newHeight = 0;
                if (sumShare > 0) {
                    newHeight = availableHeight * s.getShare() / sumShare;
                }
                newHeight = Math.max(compMin, newHeight);
                if (s.getComp() == null) {
                    s.setSize(parent, x, incY, width, newHeight);
                } else {
                    s.getComp().setBounds(x, incY, width, newHeight);
                }
                incY += newHeight;
                ++i5;
            }
        }
    }
}

