/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.templates.ejb;

import Jxe.TextDocument;
import de.netcomputing.templates.ejb.EJBMethodDescriptor;
import de.netcomputing.util.NCStringUtilities;
import editapp.FileEntry;
import editapp.FileRegistry;
import editapp.IndexEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class EJBContext {
    IndexEntry clz;
    HashSet interfaces;
    TextDocument sourceFile;
    ArrayList methodDescriptors;
    boolean isLocal = true;
    boolean isRemote = true;
    boolean isStateLess = false;

    public EJBContext(IndexEntry clz, HashSet interfaces) {
        this.clz = clz;
        this.interfaces = interfaces;
        this.sourceFile = new TextDocument(new File(clz.getFileString()));
        this.computeMethodDescriptors(interfaces);
    }

    void computeMethodDescriptors(HashSet interfaces) {
        this.methodDescriptors = new ArrayList(10);
        ArrayList al = this.clz.getMethods();
        int i = 0;
        while (i < al.size()) {
            IndexEntry mthd = (IndexEntry)al.get(i);
            String prevLine = this.sourceFile.lineAt(mthd.decl().getLine() - 2).toString().trim();
            if (prevLine.startsWith("//@EJB:")) {
                Vector flags = NCStringUtilities.SplitSeparatedString(",", prevLine.substring("//@EJB:".length()));
                EJBMethodDescriptor desc = new EJBMethodDescriptor(mthd, this);
                desc.setIsHome(mthd.getName().startsWith("ejbHome") || mthd.getName().startsWith("ejbCreate") || mthd.getName().startsWith("ejbFind"));
                desc.setIsLocal(flags.contains("local"));
                desc.setIsRemote(flags.contains("remote"));
                desc.setIsEntity(interfaces.contains("EntityBean"));
                desc.setClazzName(this.clz.getName());
                this.methodDescriptors.add(desc);
            }
            ++i;
        }
        String prevLine = this.sourceFile.lineAt(this.clz.decl().getLine() - 2).toString().trim();
        if (prevLine.startsWith("//@EJB:")) {
            Vector flags = NCStringUtilities.SplitSeparatedString(",", prevLine.substring("//@EJB:".length()));
            this.isLocal = flags.contains("local");
            this.isRemote = flags.contains("remote");
            this.isStateLess = flags.contains("stateless");
        }
    }

    public Vector getImports() {
        String[] s;
        FileEntry fe = FileRegistry.This.get(this.clz.getFileString());
        Vector<String> res = new Vector<String>();
        if (fe != null && (s = fe.imports()) != null) {
            int i = 0;
            while (i < s.length) {
                if (!(s[i].equals("java.lang") || s[i].equals("javax.ejb") || s[i].equals("java.rmi") || s[i].equals("java.util") || s[i].equals(this.clz.getPackageName()))) {
                    res.add(s[i]);
                }
                ++i;
            }
        }
        return res;
    }

    public boolean getIsStateLess() {
        return this.isStateLess;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public String getClazzName() {
        return this.clz.realClassName();
    }

    public String getPackage() {
        return this.clz.getPackageName();
    }

    public void dump() {
        int i = 0;
        while (i < this.methodDescriptors.size()) {
            ((EJBMethodDescriptor)this.methodDescriptors.get(i)).dump();
            ++i;
        }
    }

    public IndexEntry getClz() {
        return this.clz;
    }

    public ArrayList getMethodDescriptors() {
        return this.methodDescriptors;
    }
}

