/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.PrintOut;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BasicPrintStream
extends OutputStream
implements PrintOut {
    public static final char[] LINEFEED = System.getProperty("line.separator", "\r\n").toCharArray();
    protected char[] linefeed = LINEFEED;
    protected boolean enforceLineFeed = true;

    public BasicPrintStream() {
    }

    public BasicPrintStream(String linefeed) {
        this.linefeed = linefeed.toCharArray();
    }

    public boolean isLineFeedEnforced() {
        return this.enforceLineFeed;
    }

    public void setLineFeedEnforced(boolean flag) {
        this.enforceLineFeed = flag;
    }

    public abstract void append(char var1);

    public void rawappend(int b) {
        this.append((char)b);
    }

    public void rawappend(byte[] bytes, int off, int len) {
        int idx = off;
        int max = off + len;
        while (idx < max) {
            this.rawappend(bytes[idx]);
            ++idx;
        }
    }

    public void write(int b) throws IOException {
        if (this.enforceLineFeed) {
            this.append((char)b);
        } else {
            this.rawappend(b);
        }
    }

    public void write(byte[] bytes) throws IOException {
        if (this.enforceLineFeed) {
            this.append(bytes, 0, bytes.length);
        } else {
            this.rawappend(bytes, 0, bytes.length);
        }
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if (this.enforceLineFeed) {
            this.append(bytes, off, len);
        } else {
            this.rawappend(bytes, off, len);
        }
    }

    public int currentPosition() {
        return -1;
    }

    public boolean hasLinefeed(char[] chars) {
        if (this.linefeed.length != chars.length) {
            return false;
        }
        int idx = 0;
        while (idx < chars.length) {
            if (this.linefeed[idx] != chars[idx]) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public void append(String str, int offs, int len) {
        int idx = 0;
        while (idx < len) {
            char ch = str.charAt(offs + idx);
            if (ch == '\n') {
                this.newline();
            } else if (ch != '\r') {
                this.append(ch);
            }
            ++idx;
        }
    }

    public void append(char[] arr, int offs, int len) {
        int idx = 0;
        while (idx < len) {
            char ch = arr[offs + idx];
            if (ch == '\n') {
                this.newline();
            } else if (ch != '\r') {
                this.append(ch);
            }
            ++idx;
        }
    }

    public void append(byte[] arr, int offs, int len) {
        int idx = 0;
        while (idx < len) {
            byte ch = arr[offs + idx];
            if (ch == 10) {
                this.newline();
            } else if (ch != 13) {
                this.append((char)ch);
            }
            ++idx;
        }
    }

    public void append(String str) {
        if (str == null) {
            str = "null";
        }
        this.append(str, 0, str.length());
    }

    public void newline() {
        int idx = 0;
        while (idx < this.linefeed.length) {
            this.append(this.linefeed[idx]);
            ++idx;
        }
    }

    public void print(boolean val) {
        this.append(val ? "true" : "false");
    }

    public void print(char val) {
        this.append(String.valueOf(val));
    }

    public void print(int val) {
        this.append(String.valueOf(val));
    }

    public void print(long val) {
        this.append(String.valueOf(val));
    }

    public void print(float val) {
        this.append(String.valueOf(val));
    }

    public void print(double val) {
        this.append(String.valueOf(val));
    }

    public void print(char[] val) {
        this.append(val, 0, val.length);
    }

    public void print(String val) {
        this.append(val);
    }

    public void print(Object obj) {
        this.append(String.valueOf(obj));
    }

    public void println() {
        this.newline();
    }

    public void println(boolean val) {
        this.print(val);
        this.newline();
    }

    public void println(char val) {
        this.print(val);
        this.newline();
    }

    public void println(int val) {
        this.print(val);
        this.newline();
    }

    public void println(long val) {
        this.print(val);
        this.newline();
    }

    public void println(float val) {
        this.print(val);
        this.newline();
    }

    public void println(double val) {
        this.print(val);
        this.newline();
    }

    public void println(char[] val) {
        this.print(val);
        this.newline();
    }

    public void println(String val) {
        this.print(val);
        this.newline();
    }

    public void println(Object val) {
        this.print(val);
        this.newline();
    }

    public void print(String s1, String s2) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
    }

    public void print(String s1, String s2, String s3) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
    }

    public void print(String s1, String s2, String s3, String s4) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
        this.append(s10, 0, s10.length());
    }

    public void print(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
        this.append(s10, 0, s10.length());
        this.append(s11, 0, s11.length());
    }

    public void println(String s1, String s2) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
        this.append(s10, 0, s10.length());
        this.newline();
    }

    public void println(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11) {
        this.append(s1, 0, s1.length());
        this.append(s2, 0, s2.length());
        this.append(s3, 0, s3.length());
        this.append(s4, 0, s4.length());
        this.append(s5, 0, s5.length());
        this.append(s6, 0, s6.length());
        this.append(s7, 0, s7.length());
        this.append(s8, 0, s8.length());
        this.append(s9, 0, s9.length());
        this.append(s10, 0, s10.length());
        this.append(s11, 0, s11.length());
        this.newline();
    }
}

