/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.DataNode;
import de.netcomputing.util.xml.DataNodeFactory;
import de.netcomputing.util.xml.DataNodeReflectionAdapter;
import de.netcomputing.util.xml.Node;

public class DataNodeReflectionFactory
implements DataNodeFactory {
    protected String[] pkgs;

    public DataNodeReflectionFactory(String pkg) {
        this(new String[]{pkg});
    }

    public DataNodeReflectionFactory(String[] pkgs) {
        this.pkgs = pkgs;
    }

    public DataNode createNode(DataNode parent, String name) {
        Class<?> clazz = null;
        if (this.pkgs != null) {
            int idx = 0;
            while (idx < this.pkgs.length && clazz == null) {
                String cname = this.pkgs[idx];
                cname = cname.length() > 0 && !cname.endsWith(".") ? cname + '.' + name : cname + name;
                try {
                    clazz = Class.forName(cname);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                ++idx;
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (clazz == null) {
            return new Node(parent, name);
        }
        try {
            DataNodeReflectionAdapter node = new DataNodeReflectionAdapter(clazz.newInstance());
            parent.addSubnode(node);
            node.setParent(parent);
            return node;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

