/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPUtils {
    private static String qualifiedHostName = null;
    private static String simpleHostName = null;

    public static String getQualifiedHostName() throws UnknownHostException, IOException {
        if (qualifiedHostName == null) {
            String name = InetAddress.getLocalHost().getHostName();
            if (name.indexOf(46) < 0) {
                name = IPUtils.forceQualifiedHostName(name);
            }
            qualifiedHostName = name.toLowerCase();
        }
        return qualifiedHostName;
    }

    public static String getSimpleHostName() throws UnknownHostException, IOException {
        if (simpleHostName == null) {
            String name = IPUtils.getQualifiedHostName();
            simpleHostName = name.substring(name.lastIndexOf(46) + 1);
        }
        return simpleHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String forceQualifiedHostName(String name) throws IOException {
        final ByteArrayBuffer buf = new ByteArrayBuffer();
        final Process proc = Runtime.getRuntime().exec("tracert " + name);
        final InputStream pout = proc.getInputStream();
        final InputStream perr = proc.getErrorStream();
        final Boolean[] finished = new Boolean[]{Boolean.FALSE};
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void run() {
                int exitValue = 259;
                while (exitValue == 259) {
                    exitValue = 0;
                    try {
                        exitValue = proc.exitValue();
                        if (pout.available() <= 0 && perr.available() <= 0) {
                            break;
                        }
                    }
                    catch (Exception iex) {
                        exitValue = 259;
                        try {
                            this.wait(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        buf.append(pout, pout.available());
                        buf.append(perr, perr.available());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Boolean[] booleanArray = finished;
                synchronized (booleanArray) {
                    finished[0] = Boolean.TRUE;
                }
            }
        }).start();
        int idx = -1;
        while (true) {
            Boolean[] booleanArray = finished;
            synchronized (booleanArray) {
                idx = buf.indexOf('[', 0);
                if (idx >= 0 || finished[0].booleanValue()) {
                    break;
                }
                try {
                    finished.wait(20L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            }
        }
        int end = idx;
        byte[] arr = buf.getInternal();
        while (arr[--idx] <= 32) {
            end = idx;
        }
        while (arr[idx - 1] > 32) {
            --idx;
        }
        return buf.toString(idx, end - idx);
    }
}

