/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.Hashtable;

public class StringUnifier
extends Hashtable {
    public static final boolean USE_SHARED = false;
    public static final int SHARED_MAX_LEN = 0;
    public static final StringUnifier SHARED = null;

    public static final void clearShared(int threshold) {
        if (SHARED.size() >= threshold) {
            SHARED.reset(threshold);
        }
    }

    public StringUnifier() {
    }

    public StringUnifier(int capacity) {
        super(capacity);
    }

    public synchronized String getString(String str) {
        if (str == null) {
            return null;
        }
        int pos = this.locateIndex(str, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            return (String)this.data[pos + 1];
        }
        String string = str;
        this.data[pos + 1] = string;
        this.data[pos] = string;
        return str;
    }

    public synchronized String getString(byte[] str, int offs, int length) {
        String newstr;
        if (str == null) {
            return null;
        }
        int pos = this.locateIndex(str, offs, length, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            return (String)this.data[pos + 1];
        }
        String string = newstr = new String(str, 0, offs, length);
        this.data[pos + 1] = string;
        this.data[pos] = string;
        return newstr;
    }

    public synchronized String getString(char[] str, int offs, int length) {
        String newstr;
        if (str == null) {
            return null;
        }
        int pos = this.locateIndex(str, offs, length, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            return (String)this.data[pos + 1];
        }
        String string = newstr = new String(str, offs, length);
        this.data[pos + 1] = string;
        this.data[pos] = string;
        return newstr;
    }

    public static final int stringHash(byte[] str, int offs, int length) {
        int hash1 = 0;
        int hash2 = 0;
        int idx = length - 1;
        while (idx >= offs) {
            int ch = str[idx] & 0xFF;
            hash1 = (hash1 << 13 | ch) ^ hash1 >>> 19;
            hash2 = (hash2 >>> 13 | ch << 24) ^ hash2 << 19;
            --idx;
        }
        return hash1 + hash2;
    }

    public static final int stringHash(char[] str, int offs, int length) {
        int hash1 = 0;
        int hash2 = 0;
        int idx = length - 1;
        while (idx >= offs) {
            int ch = str[idx] & 0xFF;
            hash1 = (hash1 << 13 | ch) ^ hash1 >>> 19;
            hash2 = (hash2 >>> 13 | ch << 24) ^ hash2 << 19;
            --idx;
        }
        return hash1 + hash2;
    }

    protected int hashCode(Object obj) {
        if (obj instanceof String) {
            return Hashtable.stringHash((String)obj);
        }
        if (obj instanceof byte[]) {
            byte[] bobj = (byte[])obj;
            return StringUnifier.stringHash(bobj, 0, bobj.length);
        }
        if (obj instanceof char[]) {
            char[] cobj = (char[])obj;
            return StringUnifier.stringHash(cobj, 0, cobj.length);
        }
        return obj.hashCode();
    }

    public static final boolean isEqualKey(byte[] key, int offs, int length, String refKey) {
        int idx = refKey.length();
        if (length == idx) {
            int idy = offs + length;
            while (idx > 0) {
                if (key[--idy] == refKey.charAt(--idx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isEqualKey(char[] key, int offs, int length, String refKey) {
        int idx = refKey.length();
        if (length == idx) {
            int idy = offs + length;
            while (idx > 0) {
                if (key[--idy] == refKey.charAt(--idx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isEqualKey(Object key, Object refKey) {
        if (key == refKey) {
            return true;
        }
        if (key instanceof byte[]) {
            byte[] bkey = (byte[])key;
            return StringUnifier.isEqualKey(bkey, 0, bkey.length, (String)refKey);
        }
        if (key instanceof char[]) {
            char[] ckey = (char[])key;
            return StringUnifier.isEqualKey(ckey, 0, ckey.length, (String)refKey);
        }
        return key.equals(refKey);
    }

    protected int locateIndex(byte[] key, int offs, int length, boolean doGrow) {
        if (doGrow && this.size >= this.threshold) {
            this.resizeToCapacity(this.data.length);
        }
        int hash = StringUnifier.stringHash(key, offs, length);
        int cap = this.data.length;
        int pos = (hash * 7621 + 1 & Integer.MAX_VALUE) % (cap >> 1) << 1;
        while (this.data[pos] != null) {
            if (StringUnifier.isEqualKey(key, offs, length, (String)this.data[pos])) break;
            pos = (pos + 2) % cap;
        }
        return pos;
    }

    protected int locateIndex(char[] key, int offs, int length, boolean doGrow) {
        if (doGrow && this.size >= this.threshold) {
            this.resizeToCapacity(this.data.length);
        }
        int hash = StringUnifier.stringHash(key, offs, length);
        int cap = this.data.length;
        int pos = (hash * 7621 + 1 & Integer.MAX_VALUE) % (cap >> 1) << 1;
        while (this.data[pos] != null) {
            if (StringUnifier.isEqualKey(key, offs, length, (String)this.data[pos])) break;
            pos = (pos + 2) % cap;
        }
        return pos;
    }
}

